// #region [Imports] ===================================================================================================

// Types
import IDashboardData from "../../types/dashboard";

// #endregion [Imports]

// #region [Action Payloads] ===========================================================================================

export interface IReadDashboardDataActionPayload {
    processingCB?: () => void;
    successCB?: (arg: any) => void;
    failCB?: (arg: any) => void;
}

export interface ISetStoreDashboardDataActionPayload {
    data: IDashboardData;
}

// #endregion [Action Payloads]

// #region [Action Types] ==============================================================================================

export enum EDashboardDataActionTypes {
    READ_DASHBOARD_DATA = "READ_DASHBOARD_DATA",
    SET_DASHBOARD_DATA = "SET_DASHBOARD_DATA",
}

// #endregion [Action Types]

// #region [Action Creators] ===========================================================================================

export const DashboardDataActions = {
    readDashboardData: (payload: IReadDashboardDataActionPayload) => ({
        type: EDashboardDataActionTypes.READ_DASHBOARD_DATA,
        payload,
    }),
    setStoreDashboardData: (payload: ISetStoreDashboardDataActionPayload) => ({
        type: EDashboardDataActionTypes.SET_DASHBOARD_DATA,
        payload,
    }),
};

// #endregion [Action Creators]
