// #region [Imports] ===================================================================================================

// Types
import ICustomer, {
    ICustomerStatus,
    ICustomerSource,
    IHistoryEntry,
} from "../../types/customer";

// #endregion [Imports]

// #region [Action Payloads] ===========================================================================================

export interface IReadCustomerStatusActionPayload {
    id: number | null;
    processingCB?: () => void;
    successCB?: (arg: any) => void;
    failCB?: (arg: any) => void;
}

export interface IReadCustomerHistoryActionPayload {
    id: number | null;
    page?: number | null;
    processingCB?: () => void;
    successCB?: (arg: any) => void;
    failCB?: (arg: any) => void;
}

export interface IAdjustCustomerPointsActionPayload {
    id: number | null;
    type: string;
    points: number | string;
    processingCB?: () => void;
    successCB?: (arg: any) => void;
    failCB?: (arg: any) => void;
}

export interface ISetCustomerActionPayload {
    data: ICustomer | null;
}

export interface ISetCustomerStatusActionPayload {
    data: ICustomerStatus[];
}

export interface ISetCustomerSourcesActionPayload {
    data: ICustomerSource[];
}

export interface ISetHistoryEntriesActionPayload {
    data: IHistoryEntry[];
}

export interface ISetHistoryEntryActionPayload {
    data: IHistoryEntry;
}

// #endregion [Action Payloads]

// #region [Action Types] ==============================================================================================

export enum ECustomerDataActionTypes {
    READ_CUSTOMER_STATUS = "READ_CUSTOMER_STATUS",
    READ_CUSTOMER_HISTORY = "READ_CUSTOMER_HISTORY",
    ADJUST_CUSTOMER_POINTS = "ADJUST_CUSTOMER_POINTS",
    SET_STORE_CUSTOMER = "SET_STORE_CUSTOMER",
    SET_STORE_CUSTOMER_STATUS = "SET_STORE_CUSTOMER_STATUS",
    SET_STORE_CUSTOMER_SOURCES = "SET_STORE_CUSTOMER_SOURCES",
    SET_STORE_HISTORY_ENTRIES = "SET_STORE_HISTORY_ENTRIES",
    SET_STORE_HISTORY_ENTRY = "SET_STORE_HISTORY_ENTRY",
}

// #endregion [Action Types]

// #region [Action Creators] ===========================================================================================

export const CustomerDataActions = {
    readCustomerStatus: (payload: IReadCustomerStatusActionPayload) => ({
        type: ECustomerDataActionTypes.READ_CUSTOMER_STATUS,
        payload,
    }),
    readCustomerHistory: (payload: IReadCustomerHistoryActionPayload) => ({
        type: ECustomerDataActionTypes.READ_CUSTOMER_HISTORY,
        payload,
    }),
    adjustCustomerPoints: (payload: IAdjustCustomerPointsActionPayload) => ({
        type: ECustomerDataActionTypes.ADJUST_CUSTOMER_POINTS,
        payload,
    }),
    setStoreCustomer: (payload: ISetCustomerActionPayload) => ({
        type: ECustomerDataActionTypes.SET_STORE_CUSTOMER,
        payload,
    }),
    setStoreCustomerStatus: (payload: ISetCustomerStatusActionPayload) => ({
        type: ECustomerDataActionTypes.SET_STORE_CUSTOMER_STATUS,
        payload,
    }),
    setStoreCustomerSources: (payload: ISetCustomerSourcesActionPayload) => ({
        type: ECustomerDataActionTypes.SET_STORE_CUSTOMER_SOURCES,
        payload,
    }),
    setStoreHIstoryEntries: (payload: ISetHistoryEntriesActionPayload) => ({
        type: ECustomerDataActionTypes.SET_STORE_HISTORY_ENTRIES,
        payload,
    }),
    setStoreHistoryEntry: (payload: ISetHistoryEntryActionPayload) => ({
        type: ECustomerDataActionTypes.SET_STORE_HISTORY_ENTRY,
        payload,
    }),
};

// #endregion [Action Creators]
