// #region [Imports] ===================================================================================================

// Libraries
import React from "react";

// Actions
import { CustomerDataActions } from "../../store/actions/customer";
// Types
import { ITopCustomer } from "../../types/dashboard";

// #endregion [Imports]

// #region [Variables] =================================================================================================

declare var acfwAdminApp: any;
declare var acfwpElements: any;

const {
    element: { useState, useEffect },
    router: { Link },
    antd: { Table },
    redux: { bindActionCreators, connect },
    pathPrefix,
} = acfwpElements;
const { setStoreCustomer } = CustomerDataActions;

// #endregion [Variables]

// #region [Interfaces] ================================================================================================

interface IActions {
    setStoreCustomer: typeof setStoreCustomer;
}

interface IProps {
    customers: ITopCustomer[];
    actions: IActions;
}

// #endregion [Interfaces]

// #region [Component] =================================================================================================

const TopCustomers = (props: IProps) => {
    const { customers, actions } = props;
    const {
        loyalty_program: { labels },
    } = acfwAdminApp;
    const [loading, setLoading]: [boolean, any] = useState(true);

    const columns = [
        {
            title: labels.customer,
            dataIndex: "name",
            key: "name",
            render: (value: string, record: ITopCustomer) => (
                <Link
                    to={`${pathPrefix}admin.php?page=acfw-loyalty-program&tab=customers`}
                    onClick={() => viewCustomer(record)}
                >
                    {value}
                </Link>
            ),
        },
        {
            title: labels.points,
            dataIndex: "points",
            key: "points",
        },
    ];

    /**
     * Set loading state when top customers list is empty.
     */
    useEffect(() => {
        if (Array.isArray(customers)) setLoading(false);
    }, [customers, setLoading]);

    const viewCustomer = (record: ITopCustomer) => {
        const { id, name, email } = record;
        actions.setStoreCustomer({
            data: { id, name, email },
        });
    };

    return (
        <Table
            loading={loading}
            pagination={false}
            dataSource={customers}
            columns={columns}
        />
    );
};

const mapStateToProps = (store: any) => ({
    customers: store.dashboard?.customers,
});

const mapDispatchToProps = (dispatch: any) => ({
    actions: bindActionCreators({ setStoreCustomer }, dispatch),
});

export default connect(mapStateToProps, mapDispatchToProps)(TopCustomers);
