// #region [Imports] ===================================================================================================

// Libraries
import React from "react";

// CSS
import "./index.scss";

// Components
import SearchCustomers from "./SearchCustomers";
import AdjustPoints from "./AdjustPoints";
import CustomerStatus from "./CustomerStatus";
import CustomerSources from "./CustomerSources";
import CustomerHistory from "./CustomerHistory";

// Actions
import { CustomerDataActions } from "../../store/actions/customer";

// Types
import ICustomer from "../../types/customer";

// #endregion [Imports]

// #region [Variables] =================================================================================================

declare var acfwpElements: any;

const {
    element: { Fragment, useState, useEffect },
    redux: { bindActionCreators, connect },
    antd: { Row, Col },
} = acfwpElements;

const { readCustomerStatus, readCustomerHistory } = CustomerDataActions;

// #endregion [Variables]

// #region [Interfaces] ================================================================================================

interface IActions {
    readCustomerStatus: typeof readCustomerStatus;
    readCustomerHistory: typeof readCustomerHistory;
}

interface IProps {
    customer: ICustomer;
    actions: IActions;
}

// #endregion [Interfaces]

// #region [Component] =================================================================================================

const Customers = (props: IProps) => {
    const { customer, actions } = props;
    const [currentId, setCurrentId]: [number, any] = useState(0);
    const customerID = customer?.id ?? 0;

    /**
     * Read customer data.
     */
    useEffect(() => {
        if (!customerID) {
            setCurrentId(0);
            return;
        }

        if (customerID === currentId) return;

        actions.readCustomerStatus({ id: customerID });
        setCurrentId(customer.id);
    }, [customerID]);

    return (
        <div className="lpfw-customers">
            <SearchCustomers />
            {customerID ? (
                <Fragment>
                    <AdjustPoints />
                    <Row gutter={16}>
                        <Col span={12}>
                            <CustomerStatus />
                        </Col>
                        <Col span={12}>
                            <CustomerSources />
                        </Col>
                    </Row>
                    <CustomerHistory />
                </Fragment>
            ) : null}
        </div>
    );
};

const mapStateToProps = (store: any) => ({
    customer: store.customer,
});

const mapDispatchToProps = (dispatch: any) => ({
    actions: bindActionCreators(
        { readCustomerStatus, readCustomerHistory },
        dispatch
    ),
});

export default connect(mapStateToProps, mapDispatchToProps)(Customers);

// #endregion [Component]
