// #region [Imports] ===================================================================================================

// Libraries
import React from "react";

// Types
import { ICustomerSource } from "../../types/customer";

// #endregion [Imports]

// #region [Variables] =================================================================================================

declare var acfwAdminApp: any;
declare var acfwpElements: any;

const {
    element: { useState, useEffect },
    antd: { Card, Table },
    redux: { bindActionCreators, connect },
} = acfwpElements;

// #endregion [Variables]

// #region [Interfaces] ================================================================================================

interface IProps {
    sources: ICustomerSource[];
}

// #endregion [Interfaces]

// #region [Component] =================================================================================================

const CustomerSources = (props: IProps) => {
    const { sources } = props;
    const {
        loyalty_program: { labels },
    } = acfwAdminApp;
    const [loading, setLoading]: [boolean, any] = useState(true);

    const columns = [
        {
            title: labels.source,
            dataIndex: "label",
            key: "label",
        },
        {
            title: labels.points,
            dataIndex: "points",
            key: "points",
        },
    ];

    /**
     * Set loading state when sources list is empty.
     */
    useEffect(() => {
        if (sources && sources.length) setLoading(false);
        else setLoading(true);
    }, [sources, setLoading]);

    return (
        <Card className="customer-points-sources" title={labels.points_sources}>
            <Table
                loading={loading}
                pagination={false}
                dataSource={sources}
                columns={columns}
            />
        </Card>
    );
};

const mapStateToProps = (store: any) => ({ sources: store.customer?.sources });

const mapDispatchToProps = (dispatch: any) => ({
    actions: bindActionCreators({}, dispatch),
});

export default connect(mapStateToProps, mapDispatchToProps)(CustomerSources);
