<?php 

if ( ! defined( 'ABSPATH' ) )
	exit;

if ( !class_exists( 'fspHandleVersionReversion' ) ) {
class fspHandleVersionReversion {

	public function __construct() {

		if ( get_option( "BPFWP_Trial_Happening" ) == "Yes" and time() > get_option( "BPFWP_Trial_Expiry_Time" ) ) { $this->fsp_bpfwp_version_reversion(); }
		if ( get_option( "FDM_Trial_Happening" ) == "Yes" and time() > get_option( "FDM_Trial_Expiry_Time" ) ) { $this->fsp_fdm_version_reversion(); }
		if ( get_option( "GRFWP_Trial_Happening" ) == "Yes" and time() > get_option( "GRFWP_Trial_Expiry_Time" ) ) { $this->fsp_grfwp_version_reversion(); }
		if ( get_option( "RTB_Trial_Happening" ) == "Yes" and time() > get_option( "RTB_Trial_Expiry_Time" ) ) { $this->fsp_rtb_version_reversion(); }
		if ( get_option( "RTU_Trial_Happening" ) == "Yes" and time() > get_option( "RTU_Trial_Expiry_Time" ) ) { $this->fsp_rtu_version_reversion(); }
	}

	public function fsp_plugin_deactivation_reversion() {

		if ( get_option( 'bpfwp-permission-level' ) and get_option( "BPFWP_Trial_Happening" ) == "Yes" ) { $this->fsp_bpfwp_version_reversion(); }
		if ( get_option( 'fdm-permission-level' ) and get_option( "FDM_Trial_Happening" ) == "Yes" ) { $this->fsp_fdm_version_reversion(); }
		if ( get_option( 'grfwp-permission-level' ) and get_option( "GRFWP_Trial_Happening" ) == "Yes" ) { $this->fsp_grfwp_version_reversion(); }
		if ( get_option( 'rtb-permission-level' ) and get_option( "RTB_Trial_Happening" ) == "Yes" ) { $this->fsp_rtb_version_reversion(); }
		if ( get_option( 'rtb-permission-level' ) and get_option( "RTU_Trial_Happening" ) == "Yes" ) { $this->fsp_rtu_version_reversion(); }
	}

	public function fsp_bpfwp_version_reversion() {
		global $bpfwp_controller;

		$bpfwp_controller->settings->set_setting( 'article-rich-snippets', false );
		$bpfwp_controller->settings->set_setting( 'schema-default-helpers', false );
		$bpfwp_controller->settings->set_setting( 'woocommerce-integration', false );

		$bpfwp_controller->settings->save_settings();

		delete_option( 'BPFWP_Trial_Expiry_Time' );
		update_option( 'BPFWP_Trial_Happening', 'No' );

		update_option( 'bpfwp-permission-level', get_option( 'bpfwp-pre-permission-level' ) ? get_option( 'bpfwp-pre-permission-level' ) : 1 );
	}

	public function fsp_fdm_version_reversion() {
		global $fdm_controller;

		$fdm_controller->settings->set_setting( 'fdm-styling-section-title-font-family', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-section-title-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-section-title-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-name-font-family', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-name-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-name-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-description-font-family', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-description-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-description-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-price-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-price-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-image-width', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-image-border-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-image-border-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-separating-line-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-separating-line-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-filtering-font-family', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-filtering-title-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-filtering-title-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-filtering-labels-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-filtering-labels-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-sidebar-font-family', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-sidebar-title-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-sidebar-title-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-sidebar-description-font-size', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-sidebar-description-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-item-icon-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-add-to-cart-background-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-add-to-cart-text-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-shopping-cart-accent-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-order-progress-color', '' );
		$fdm_controller->settings->set_setting( 'fdm-styling-order-progress-border-color', '' );

		$fdm_controller->settings->set_setting( 'fdm-text-search', array() );
		$fdm_controller->settings->set_setting( 'fdm-enable-price-filtering', false );
		$fdm_controller->settings->set_setting( 'fdm-enable-sorting', false );

		$fdm_controller->settings->set_setting( 'fdm-related-items', 'none' );
		$fdm_controller->settings->set_setting( 'fdm-disable-menu-item-flags', true );
		$fdm_controller->settings->set_setting( 'fdm-disable-specials', true );
		$fdm_controller->settings->set_setting( 'fdm-disable-price-discounted', true );
		$fdm_controller->settings->set_setting( 'fdm-disable-src', true );
		$fdm_controller->settings->set_setting( 'fdm-disable-src-map', true );
		
		$fdm_controller->settings->set_setting( 'fdm-enable-ordering-options', false );
		$fdm_controller->settings->set_setting( 'fdm-enable-ordering-progress-display', false );
		$fdm_controller->settings->set_setting( 'enable-payment', false );

		$fdm_controller->settings->set_setting( 'fdm-custom-fields', array() );

		$fdm_controller->settings->save_settings();

		delete_option( 'FDM_Trial_Expiry_Time' );
		update_option( 'FDM_Trial_Happening', 'No' );

		update_option( 'fdm-permission-level', get_option( 'fdm-pre-permission-level' ) ? get_option( 'fdm-pre-permission-level' ) : 1 );
	}	

	public function fsp_grfwp_version_reversion() {
		global $grfwp_controller;

		$grfwp_controller->settings->set_setting( 'grfwp-styling-layout', 'default' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-stars-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-rating-font-size', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-review-text-font-size', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-review-text-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-author-font-size', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-author-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-organization-font-size', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-organization-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-read-more-background-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-read-more-text-color', '' );
		$grfwp_controller->settings->set_setting( 'grfwp-styling-icon-color', '' );

		$grfwp_controller->settings->save_settings();

		delete_option( 'GRFWP_Trial_Expiry_Time' );
		update_option( 'GRFWP_Trial_Happening', 'No' );

		update_option( 'grfwp-permission-level', get_option( 'grfwp-pre-permission-level' ) ? get_option( 'grfwp-pre-permission-level' ) : 1 );
	}

	public function fsp_rtb_version_reversion() {
		global $rtb_controller;

		$rtb_controller->settings->set_setting( 'view-bookings-page', '' );
		$rtb_controller->settings->set_setting( 'view-bookings-arrivals', false );
		
		$rtb_controller->settings->set_setting( 'auto-confirm-max-reservations', '' );
		$rtb_controller->settings->set_setting( 'auto-confirm-max-seats', '' );
		
		$rtb_controller->settings->set_setting( 'mc-lists', '' );
		
		$rtb_controller->settings->set_setting( 'rtb-styling-layout', 'default' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-title-font-family', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-title-font-size', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-title-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-background-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-border-size', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-section-border-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-label-font-family', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-label-font-size', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-label-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-add-message-button-background-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-add-message-button-background-hover-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-add-message-button-text-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-add-message-button-text-hover-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-request-booking-button-background-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-request-booking-button-background-hover-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-request-booking-button-text-color', '' );
		$rtb_controller->settings->set_setting( 'rtb-styling-request-booking-button-text-hover-color', '' );
		
		$rtb_controller->settings->save_settings();

		delete_option( 'RTB_Trial_Expiry_Time' );
		update_option( 'RTB_Trial_Happening', 'No' );

		update_option( 'rtb-permission-level', get_option( 'rtb-pre-permission-level' ) ? get_option( 'rtb-pre-permission-level' ) : 1 );
	}

	public function fsp_rtu_version_reversion() {
		global $rtb_controller;

		$rtb_controller->settings->set_setting( 'require-deposit', false );
		
		$rtb_controller->settings->set_setting( 'time-reminder-user', '' );
		$rtb_controller->settings->set_setting( 'time-late-user', '' );
		
		$rtb_controller->settings->set_setting( 'enable-tables', false );
		$rtb_controller->settings->set_setting( 'require-table', false );

		delete_option( 'RTU_Trial_Expiry_Time' );
		update_option( 'RTU_Trial_Happening', 'No' );

		if ( get_option( 'rtb-pre-permission-level' ) == 1 ) { $this->fsp_rtb_version_reversion(); }

		update_option( 'rtb-permission-level', get_option( 'rtb-pre-permission-level' ) ? get_option( 'rtb-pre-permission-level' ) : 1 );
	}

}
}

 ?>
