<?php
/**
 * Plugin Name: FSP Premium Helper
 * Plugin URI: http://www.fivestarplugins.com/upgrading-to-premium/
 * Description: Allows a website to access the premium trial and unlocks premium features of Five Star Design plugins with an upgrade code
 * Version: 0.0.2
 * Author: Five Star Plugins
 * Author URI: https://profiles.wordpress.org/fivestarplugins/
 * Text Domain: fsp-premium-helper
 */
if ( ! defined( 'ABSPATH' ) )
	exit;

if ( !class_exists( 'fspPremiumHelper' ) ) {
class fspPremiumHelper {

	/**
	 * Initialize the plugin and register hooks
	 */
	public function __construct() {

		// Common strings
		define( 'FSPPH_VERSION', '0.0.2' );
		define( 'FSPPH_PLUGIN_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'FSPPH_PLUGIN_URL', untrailingslashit( plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) ) );
		define( 'FSPPH_PLUGIN_FNAME', plugin_basename( __FILE__ ) );

		register_deactivation_hook( FSPPH_PLUGIN_FNAME, array( $this, 'register_deactivation') );

		// Initialize the plugin
		add_action( 'init', array( $this, 'load_textdomain' ) );

		// Load form adding class
		require_once( FSPPH_PLUGIN_DIR . '/includes/DashboardForms.class.php' );
		new fspDashboardForms();

		// Load upgrade class
		require_once( FSPPH_PLUGIN_DIR . '/includes/Upgrade.class.php' );
		new fspHandleUpgrades();

		// Load version reversion class
		require_once( FSPPH_PLUGIN_DIR . '/includes/VersionReversion.class.php' );
		new fspHandleVersionReversion();

		// Load update class
		require_once( FSPPH_PLUGIN_DIR . '/includes/Updates.class.php' );
		new fspHandleUpdates();

		// Load helper functions
		require_once( FSPPH_PLUGIN_DIR . '/includes/template-functions.php' );
	}

	/**
	 * Load the plugin textdomain for localistion
	 * @since 0.0.1
	 */
	public function load_textdomain() {
		load_plugin_textdomain( 'fsp-premium-helper', false, plugin_basename( dirname( __FILE__ ) ) . "/languages/" );
	}

	/**
	 * Add links to the plugin listing on the installed plugins page
	 * @since 0.0.1
	 */
	public function plugin_action_links( $links, $plugin ) {

		if ( $plugin == FSPPH_PLUGIN_FNAME ) {

			$links['help'] = '<a href="https://www.etoilewebdesign.com/premium-upgrade-instructions/" title="' . __( 'View detailed instructions on how to upgrade.', 'fsp-premium-helper' ) . '">' . __( 'Help Upgrading', 'fsp-premium-helper' ) . '</a>';
		}

		return $links;
	}

	public function register_deactivation() {

		// Load version reversion class
		require_once( FSPPH_PLUGIN_DIR . '/includes/VersionReversion.class.php' );
		$version_reversion = new fspHandleVersionReversion();

		$version_reversion->fsp_plugin_deactivation_reversion();
	}

}
} // endif;

global $fsp_premium_helper;
$fsp_premium_helper = new fspPremiumHelper();

