<?php

class pisol_ewcl_search_order_meta{
    static function orderMeta($key, $user_id){
        $meta = self::getMetaValue($key, $user_id);
        return $meta;
    }

    static function getMetaValue($key, $user_id){
        $orders = self::getCustomerOrders($user_id);

        if(empty($orders) || !is_array($orders)) return '';

        foreach($orders as $order){
            if(!is_object($order) || is_wp_error($order)) continue;

            $meta = get_post_meta($order->ID, $key, true);

            if(!empty($meta)) return $meta;
        }

        return '';
    }

    static function getCustomerOrders($customer_id){
        $customer_orders = get_posts( array(
            'numberposts' => -1,
            'meta_key'    => '_customer_user',
            'meta_value'  => $customer_id,
            'post_type'   => wc_get_order_types(),
            'post_status' => array_keys( wc_get_order_statuses() ),
        ) );
        return $customer_orders;
    }

    static function isCustomFields($key){
        $custom_fields = get_option('pi_customer_added_fields',array());

        if(!is_array($custom_fields) || empty($custom_fields) ) return false;

        $search_result = array_search($key, array_column($custom_fields, 'field'));

        if($search_result !== false) return true;

        return false;
    }
}