<?php

class pisol_registered_customer_fields{
    public $plugin_name;

    private $settings = array();

    private $active_tab;

    private $this_tab = 'registered_customer_fields';

    private $tab_name = "Fields to include";

    private $setting_key = 'pi_ewcl_fields_setting';

    function __construct($plugin_name){
        $this->plugin_name = $plugin_name;

        $this->settings = array(
            
            array('field'=>'pi_customer_row')
            
        );

        $this->active_tab = (isset($_GET['tab'])) ? sanitize_text_field($_GET['tab']) : 'default';

        if($this->this_tab == $this->active_tab){
            add_action($this->plugin_name.'_tab_content', array($this,'tab_content'));
        }

        $this->register_settings();
    }

    function register_settings(){   

        foreach($this->settings as $setting){
            register_setting( $this->setting_key, $setting['field']);
        }

    }

    function tab(){
        ?>
        <a class=" px-3 text-light d-flex align-items-center  border-left border-right  <?php echo ($this->active_tab == $this->this_tab ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab ); ?>">
            <?php _e( $this->tab_name); ?> 
        </a>
        <?php
    }

    function tab_content(){
        $this->tabContentCsvFields();
    }

    function tabContentCsvFields(){
        $customer_rows = get_option('pi_customer_row',array());
        if(empty($customer_rows) || !is_array($customer_rows)) $customer_rows = array();
        ?>
       <form action="options.php" method="POST">
       <?php //print_r($customer_rows); ?>
       <?php settings_fields( $this->setting_key ); ?>
            <div id="row_title" class=" row py-4 border-bottom align-items-center bg-primary text-light">
                    <div class="col-6">
                    <h2 class="mt-0 mb-0 text-light font-weight-light h4">CSV fields for Registered customer </h2>
                    </div>
                    <div class="col-6 text-right">
                    <a href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab=add_custom_fields'); ?>" class="btn btn-secondary">Add Custom Meta Fields</a>
                    </div>
            </div>
        
            <div>
                <?php $this->generateFieldsTable($customer_rows); ?>
            </div>
            
            <input type="submit" class="btn btn-primary mt-3" value="Save Fields">
        </form>
        <?php
    }

    function generateFieldsTable($customer_rows){
        $fields = self::fields();
        ?>
        <table id="datagrid" class="table">
            <tbody>
                <tr>
                <th style="text-align: left;">
                    <label for="v_columns">Tick the columns you want</label>
                </th>
                <th style="text-align: left;">
                    <label for="v_columns_name">Column name</label>
                </th>
                </tr>
                <?php
                foreach($fields as $key => $value){
                echo '    
                    <tr>
                    <td style="vertical-align:middle;">
                        <input name="pi_customer_row['.$key.'][enabled]" id="pi_customer_row['.$key.'][enabled]" type="checkbox" '.(isset($customer_rows[$key]['enabled']) || count($customer_rows) == 0 ? 'checked="checked"' : '').'>
                        <label for="pi_customer_row['.$key.'][enabled]" class="mb-0 ml-2">'.$key.'</label>
                    </td>
                    <td>
                         <input type="text" name="pi_customer_row['.$key.'][label]" value="'.(isset($customer_rows[$key]['label']) && $customer_rows[$key]['label'] != "" ? $customer_rows[$key]['label'] : $value).'" class="form-control">
                    </td>
                    </tr>
                    ';
                }
                ?>
            </tbody>
        </table>
        <?php
    }

    static function fields(){
        $fields = array(
            'ID'=> 'ID',
            'user_login'=>'user_login',
            'user_pass'=>'user_pass',
            'user_nickname'=>'user_nickname',
            'user_email'=>'user_email',
            'user_url'=>'user_url',
            'user_registered'=>'user_registered',
            'display_name'=>'display_name',
            'first_name'=>'first_name',
            'last_name'=>'last_name',
            'user_status'=>'user_status',
            'roles'=>'roles',
            'billing_first_name'=>'billing_first_name',
            'billing_last_name'=>'billing_last_name',
            'billing_company'=>'billing_company',
            'billing_address_1'=>'billing_address_1',
            'billing_address_2'=>'billing_address_2',
            'billing_city'=>'billing_city',
            'billing_postcode'=>'billing_postcode',
            'billing_country'=>'billing_country',
            'billing_state'=>'billing_state',
            'billing_email'=>'billing_email',
            'billing_phone'=>'billing_phone',
            'shipping_first_name'=>'shipping_first_name',
            'shipping_last_name'=>'shipping_last_name',
            'shipping_company'=>'shipping_company',
            'shipping_address_1'=>'shipping_address_1',
            'shipping_address_2'=>'shipping_address_2',
            'shipping_city'=>'shipping_city',
            'shipping_postcode'=>'shipping_postcode',
            'shipping_country'=>'shipping_country',
            'shipping_state'=>'shipping_state',
        );
        $fields = apply_filters('pisol_ewcl_fields_filter', $fields);
        return $fields;
    }

}

new pisol_registered_customer_fields( $this->plugin_name );