<?php

class class_guest_data_extractor{

    function __construct($after, $before, $order_status = array(), $limit = -1, $offset = 0){

        $saved_fields = get_option('pi_guest_customer_row',array()) ;

        $this->fields = self::selectedFields($saved_fields);

        $this->after_date = $after;
        $this->before_date = $before;
        $this->order_status = $order_status;

        $this->limit = $limit;
        $this->offset = $offset;
    }

    function getOrders(){
        $args = array(
            'limit' => $this->limit,
            'customer_id'=>0,
            'offset'=>$this->offset
        );

        if(empty($this->before_date)){
            $this->before_date = current_time('Y-m-d');
        }

        if($this->after_date != "" && $this->before_date !=""){
            $time_range = $this->after_date.'...'.$this->before_date;
            $args['date_created'] = $time_range;
        }elseif($this->after_date == "" && $this->before_date !=""){
            $time_range = '<'.$this->before_date;
            $args['date_created'] = $time_range;
        }elseif($this->after_date != "" && $this->before_date ==""){
            $time_range = '>'.$this->after_date;
            $args['date_created'] = $time_range;
        }

        

        if(is_array($this->order_status) && count($this->order_status) > 0){
            $args['status'] = $this->order_status;
        }
        //error_log(print_r($args, true));
        $orders = wc_get_orders($args);
        return $orders;
    }

    function getRows(){
        $orders = $this->getOrders();
        $rows = array();
        foreach($orders as $order){
            if($order instanceof WC_Order_Refund) continue;
            $row = $this->getRow($order);
            $rows[] = $row;
        }
        return $rows;
    }

    function getRow($order){
        $creation_date = $order->get_date_created();
        $creation_date = !empty($creation_date) ? $creation_date->format ('Y-m-d') : "";
        $row = array(
            'ID' => $order->get_id(),
            'email' => $order->get_billing_email(),
            'phone' =>$order->get_billing_phone(),
            'billing_first_name'=>$order->get_billing_first_name(),
            'billing_last_name' =>  $order->get_billing_last_name(),
            'billing_address_1'=> $order->get_billing_address_1(),
            'billing_address_2'=> $order->get_billing_address_2(),
            'billing_city'=> $order->get_billing_city(),
            'billing_state'=> $order->get_billing_state(),
            'billing_postcode'=> $order->get_billing_postcode(),
            'billing_country'=> $order->get_billing_country(),
            'shipping_first_name'=> $order->get_shipping_first_name(),
            'shipping_last_name'=> $order->get_shipping_last_name(),
            'shipping_address_1'=> $order->get_shipping_address_1(),
            'shipping_address_2'=> $order->get_shipping_address_2(),
            'shipping_city'=> $order->get_shipping_city(),
            'shipping_state'=> $order->get_shipping_state(),
            'shipping_postcode'=> $order->get_shipping_postcode(),
            'shipping_country'=> $order->get_shipping_country(),
            'order_date'=> $creation_date
        );

        $custom_fields_data = self::customFieldData($order);

        $row = array_merge($row, $custom_fields_data);

        $row = $this->dataAsPerFields($row);

        return $row;
    }

    function dataAsPerFields($row_data){
        $new_row = array();
        foreach($this->fields as $key => $value){
            $new_row[$key] = isset($row_data[$key]) ? $row_data[$key] : '';
        }
        return $new_row;
    }

    static function customFieldData($order){
        $order_id = version_compare( WC_VERSION, '3.0.0', '<' ) ? $order->id : $order->get_id();
        $custom_fields = get_option('pi_customer_added_fields',array());

        if(!is_array($custom_fields) || empty($custom_fields) ) return array();

        $custom_data = array();

        foreach($custom_fields as $custom_field){
            if(!empty($custom_field['field'])){
                $custom_data[$custom_field['field']] = get_post_meta($order_id, $custom_field['field'], true);
            }
        }

        return $custom_data;
    }

    function getHeader(){
        foreach($this->fields as $key => $value){
            $header[] =  $value;
        }

        return $header;
    }


    static function fields(){
        $header = array(
            'ID' => __('Order ID','pisol-ewcl'),
            'email' => __('Email','pisol-ewcl'),
            'phone' => __('Phone','pisol-ewcl'),
            'billing_first_name'=> __('Billing First Name','pisol-ewcl'),
            'billing_last_name' => __('Billing Last Name','pisol-ewcl'),
            'billing_address_1'=> __('Billing Address 1','pisol-ewcl'),
            'billing_address_2'=>__('Billing Address 2','pisol-ewcl'),
            'billing_city'=>__('Billing City','pisol-ewcl'),
            'billing_state'=>__('Billing State','pisol-ewcl'),
            'billing_postcode'=>__('Billing Post Code','pisol-ewcl'),
            'billing_country'=>__('Billing Country','pisol-ewcl'),
            'shipping_first_name'=>__('Shipping First Name','pisol-ewcl'),
            'shipping_last_name'=>__('Shipping Last Name','pisol-ewcl'),
            'shipping_address_1'=>__('Shipping Address 1','pisol-ewcl'),
            'shipping_address_2'=>__('Shipping Address 2','pisol-ewcl'),
            'shipping_city'=>__('Shipping City','pisol-ewcl'),
            'shipping_state'=>__('Shipping State','pisol-ewcl'),
            'shipping_postcode'=>__('Shipping Post Code','pisol-ewcl'),
            'shipping_country'=>__('Shipping Country','pisol-ewcl'),
            'order_date'=>__('Order Date','pisol-ewcl'),
        );
        $fields = apply_filters('pisol_ewcl_fields_filter', $header);
        return $fields;
    }

    static function selectedFields($saved_fields){
        $fields = self::fields();
        $formated_saved_fields = array();
        if(count($saved_fields) > 0 ){
            foreach($fields as $key => $value){
                if(isset($saved_fields[$key]['enabled'])){
                    $formated_saved_fields[$key] = $saved_fields[$key]['label'];
                }elseif($key == 'ID'){
                    $formated_saved_fields[$key] = $value;
                }
            }
        }else{
            return $fields;
        }
        return $formated_saved_fields;
    }


}