<?php

class Class_Pi_Ewcl_Product_Customer{

    public $plugin_name;

    private $settings = array();

    private $active_tab;

    private $this_tab = 'product-customer';

    private $tab_name = "Product customer list";

    private $setting_key = 'pi_ewcl_product_customer_setting';
    

    function __construct($plugin_name){
        $this->plugin_name = $plugin_name;

        $this->settings = array(
            
            array('field'=>'pi_product_customer_row')
            
        );
        
        $this->active_tab = (isset($_GET['tab'])) ? sanitize_text_field($_GET['tab']) : 'default';

        if($this->this_tab == $this->active_tab){
            add_action($this->plugin_name.'_tab_content', array($this,'tab_content'));
        }


        add_action($this->plugin_name.'_tab', array($this,'tab'),3);

       
        $this->register_settings();

        if(PI_EWCL_DELETE_SETTING){
            $this->deleteSettings();
        }

    }

    function deleteSettings(){
        delete_option('pi_product_customer_row');
    }

    function register_settings(){   

        foreach($this->settings as $setting){
            register_setting( $this->setting_key, $setting['field']);
        }
    
    }

    function tab(){
        ?>
        <a class=" px-3 text-light d-flex align-items-center  border-left border-right  <?php echo ($this->active_tab == $this->this_tab || $this->active_tab == 'product_customer_fields' ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab ); ?>">
            <?php _e( $this->tab_name); ?> 
        </a>
        <?php
    }

    function get_roles() {
        global $wp_roles;
    
        $all_roles = $wp_roles->roles;
    
        return  $all_roles;
    }

    function tab_content(){
        $customer_rows = get_option('pi_customer_row',array());
        $roles = $this->get_roles();
       ?>
       <form id="ewcl-download-prod-customer-record" action="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&pi_action=download_product_customer_list'); ?>" method="POST">
       <div id="row_title" class="row py-4 border-bottom align-items-center bg-primary text-light">
            <div class="col-6">
            <h2 class="mt-0 mb-0 text-light font-weight-light h4">Get customer who purchased this product</h2>
            </div>
            <div class="col-6 text-right">
            <a href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab=product_customer_fields'); ?>" class="btn btn-secondary">Customize columns</a>
            <a href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab=add_custom_fields'); ?>" class="btn btn-secondary ml-2">Add Custom Meta Fields</a>
            </div>
        </div>
        <div id="row_products" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="products">Get customer who purchased</label>            <br><small>Select the products whose customer record you want to download</small>            </div>
            <div class="col-12 col-md-2">
                <select id="selection_logic" name="selection_logic" class="form-control">
                    <option value="any-one">Any One of this product</option>
                    <option value="all">All this products</option>
                </select> 
            </div>
            <div class="col-12 col-md-5">
                <select id="products" class="pi-ewcl-products form-control" multiple  name="products[]" ></select>     
            </div>
        </div>
        <div id="row_pi_ewcl_order_status" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_order_status">Order status</label>            <br><small>Download based on the order status</small>            </div>
            <div class="col-12 col-md-7">
                <select class="form-control" name="pi_ewcl_order_status[]" id="pi_ewcl_order_status" multiple>
                    <option value='pending'>Pending</option>
                    <option value="processing">Processing</option>
                    <option value="on-hold">On-Hold</option>
                    <option value="completed">Completed</option>
                    <option value="refunded">Refunded</option>
                    <option value="failed">Failed</option>
                    <option value="cancelled">Cancelled</option>
                </select>           
            </div>
        </div>
        <div id="row_pi_ewcl_download_offset" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_download_offset">Purchase done between</label>            <br><small>select the date range</small>            </div>
            <div class="col-12 col-md-3 d-flex">
            <div>
            <label for="pi_ewcl_download_after_date">Start Date</label>
            <input type="text" readonly class="form-control datepicker" name="pi_ewcl_download_after_date" id="pi_ewcl_download_after_date" placeholder="From this date">
            </div>
            <a href="javascript:void()" class="pi-clear-date btn btn-danger align-self-end">Clear</a>
            </div>
            <div class="col-12 col-md-1 text-center">
            <label>&</label>
            </div>
            <div class="col-12 col-md-3 d-flex">
            <div>
            <label for="pi_ewcl_download_before_date">End Date</label>
            <input type="text" readonly class="form-control datepicker" name="pi_ewcl_download_before_date" id="pi_ewcl_download_before_date" placeholder="Till this date">
            </div>
            <a href="javascript:void()" class="pi-clear-date btn btn-danger align-self-end">Clear</a>
            </div>
        </div>

        <div id="row_title" class="pisol-toggle-advance-option row py-4 border-bottom align-items-center bg-primary text-light" data-target="#pisol-registered-customer-advance-option">
            <div class="col-9">
            <h2 class="mt-0 mb-0 text-light font-weight-light h4">Other options</h2>
            </div>
            <div class="col-3 text-right">
            <a href="javascript:void(0);" ><span class="dashicons dashicons-plus-alt text-light"></span></a>
            </div>
        </div>
        <div id="pisol-registered-customer-advance-option" style="display:none">            
        <div id="row_pi_ewcl_delimiter" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_delimiter">Delimiters</label>            <br><small>How value are separated in csv</small>            </div>
            <div class="col-12 col-md-7">
                <select class="form-control" name="pi_ewcl_delimiter" id="pi_ewcl_delimiter">
                    <option value=",">,</option>
                    <option value=";">;</option>
                </select>           
            </div>
        </div>
        <div id="row_pi_ewcl_limit" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_limit">Extraction speed</label><br><small>You can increase the speed of extraction by increasing this number, but if you are trying to extract a large record on shared hosting having this set to large number can break the extraction process</small>
            </div>
            <div class="col-12 col-md-7">
                <input type="number" name="pi_limit"  id="pi_limit" value="60" class="form-control" step="1" min="10">         
            </div>
        </div>

        <div id="row_pi_ewcl_download_limit" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_download_limit">Number of rows to extract</label>            <br><small>Specify number of rows to extract, 0 means all rows will be extracted</small>            </div>
            <div class="col-12 col-md-7">
            <input type="number" class="form-control " name="pi_ewcl_download_limit" id="pi_ewcl_download_limit" value="0" min="0" step="1">            </div>
        </div>

        <div id="row_pi_ewcl_download_offset" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_download_offset">Number of rows to skip</label>            <br><small>Specify number of rows to skip from top</small>            </div>
            <div class="col-12 col-md-7">
            <input type="number" class="form-control " name="pi_ewcl_download_offset" id="pi_ewcl_download_offset" value="0" min="0" step="1">            </div>
        </div>
        </div>

       <div class="text-center pt-5">
        <input type="submit" class="btn btn-primary btn-lg my-2" value="Download Customer List">
        </div>
        <?php wp_nonce_field( 'pisol-ewcl-registered-customer'); ?>
       </form>
       
       <?php
    }
    
    
}
add_action('init',function(){
new Class_Pi_Ewcl_Product_Customer($this->plugin_name);
});