<?php

class Class_Pi_Ewcl_Guest{

    public $plugin_name;

    private $settings = array();

    private $active_tab;

    private $this_tab = 'guest';

    private $tab_name = "Guest Customer list";

    private $setting_key = 'pi_ewcl_guest_setting';
    

    function __construct($plugin_name){
        $this->plugin_name = $plugin_name;

        $this->settings = array(
            
            array('field'=>'pi_guest_row')
            
        );
        
        $this->active_tab = (isset($_GET['tab'])) ? sanitize_text_field($_GET['tab']) : 'default';

        if($this->this_tab == $this->active_tab){
            add_action($this->plugin_name.'_tab_content', array($this,'tab_content'));
        }


        add_action($this->plugin_name.'_tab', array($this,'tab'),2);

       
        $this->register_settings();

        if(PI_EWCL_DELETE_SETTING){
            $this->delete_settings();
        }
        
    }

    function delete_settings(){
        foreach($this->settings as $setting){
            delete_option( $setting['field'] );
        }
    }

    function register_settings(){   

        foreach($this->settings as $setting){
            register_setting( $this->setting_key, $setting['field']);
        }
    
    }

    function tab(){
        ?>
        <a class=" px-3 text-light d-flex align-items-center  border-left border-right  <?php echo ($this->active_tab == $this->this_tab || $this->active_tab == 'guest_customer_fields' ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab ); ?>">
            <?php _e( $this->tab_name); ?> 
        </a>
        <?php
    }

    function tab_content(){
        $customer_rows = get_option('pi_guest_row',array());
       ?>
       <form id="ewcl-download-guest-record"  action="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab.'&pi_action=download_guest_list'); ?>" method="POST">

       <div id="row_title" class="row py-4 border-bottom align-items-center bg-primary text-light">
            <div class="col-6">
            <h2 class="mt-0 mb-0 text-light font-weight-light h4">Download Guest Customer</h2>
            </div>
            <div class="col-6 text-right">
            <a href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab=guest_customer_fields'); ?>" class="btn btn-secondary">Customize columns</a>
            <a href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab=add_custom_fields'); ?>" class="btn btn-secondary ml-2">Add Custom Meta Fields</a>
            </div>
        </div>
        <div id="row_title" class="row py-4 border-bottom">
            <div class="col-12">
            <div class="alert alert-primary">
                Guest customer list will not be affected by the field saved in the "field in CSV" tab, "Field in CSV" tab only works on the CSV of registered customer
            </div>
            </div>
        </div>
        <div id="row_pi_ewcl_order_status" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_order_status">Guest customer based on order status</label>            <br><small>Download guest customer based on the order status, use control to select multiple status, if left empty all guest will be selected</small>            </div>
            <div class="col-12 col-md-7">
                <select class="form-control" name="pi_ewcl_order_status[]" id="pi_ewcl_order_status" multiple>
                    <option value='pending'>Pending</option>
                    <option value="processing">Processing</option>
                    <option value="on-hold">On-Hold</option>
                    <option value="completed">Completed</option>
                    <option value="refunded">Refunded</option>
                    <option value="failed">Failed</option>
                    <option value="cancelled">Cancelled</option>
                </select>           
            </div>
        </div>
        <div id="row_pi_ewcl_download_offset" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_download_offset">Gust checkout done between</label>            <br><small>select the date range, If you leave this date empty it will download all the guest users in your website</small>            </div>
            <div class="col-12 col-md-3 d-flex">
            <div>
            <label for="pi_ewcl_download_after_date">Start Date</label>
            <input type="text" readonly class="form-control datepicker" name="pi_ewcl_download_after_date" id="pi_ewcl_download_after_date" placeholder="From this date">
            </div>
            <a href="javascript:void()" class="pi-clear-date btn btn-danger align-self-end">Clear</a>
            </div>
            <div class="col-12 col-md-1 text-center">
            <label>&</label>
            </div>
            <div class="col-12 col-md-3 d-flex">
            <div>
            <label for="pi_ewcl_download_before_date">End Date</label>
            <input type="text" readonly class="form-control datepicker" name="pi_ewcl_download_before_date" id="pi_ewcl_download_before_date" placeholder="Till this date">
            </div>
            <a href="javascript:void()" class="pi-clear-date btn btn-danger align-self-end">Clear</a>
            </div>
        </div>

        <div id="row_title" class="pisol-toggle-advance-option row py-4 border-bottom align-items-center bg-primary text-light" data-target="#pisol-guest-customer-advance-option">
            <div class="col-9">
            <h2 class="mt-0 mb-0 text-light font-weight-light h4">Other options</h2>
            </div>
            <div class="col-3 text-right">
            <a href="javascript:void()" ><span class="dashicons dashicons-plus-alt text-light"></span></a>
            </div>
        </div>
        <div id="pisol-guest-customer-advance-option" style="display:none">
        <div id="row_pi_ewcl_delimiter" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_ewcl_delimiter">Delimiters</label>            <br><small>How value are separated in csv</small>            </div>
            <div class="col-12 col-md-7">
                <select class="form-control" name="pi_ewcl_delimiter" id="pi_ewcl_delimiter">
                    <option value=",">,</option>
                    <option value=";">;</option>
                </select>           
            </div>
        </div>
        <div id="row_pi_ewcl_limit" class="row py-4 border-bottom align-items-center ">
            <div class="col-12 col-md-5">
            <label class="h6 mb-0" for="pi_limit">Extraction speed</label><br><small>You can increase the speed of extraction by increasing this number, but if you are trying to extract a large record on shared hosting having this set to large number can break the extraction process</small>
            </div>
            <div class="col-12 col-md-7">
                <input type="number" name="pi_limit"  id="pi_limit" value="50" class="form-control" step="1" min="10">         
            </div>
        </div>
        </div>
       
       <div class="text-center pt-5">
        <input type="submit" class="btn btn-primary btn-lg my-2" value="Download Guest Customer list">
        </div>
        <?php wp_nonce_field( 'pisol-ewcl-guest-customer'); ?>
       </form>
       
       <?php
    }
}
add_action('init',function(){
new Class_Pi_Ewcl_Guest($this->plugin_name);
});