<?php

class Class_Pi_Ewcl_Email{

    public $plugin_name;

    private $settings = array();

    private $active_tab;

    private $this_tab = 'email';

    private $tab_name = "Get scheduled email with CSV (attachment)";

    private $setting_key = 'pi_ewcl_email_setting';
    

    function __construct($plugin_name){
        $this->plugin_name = $plugin_name;

        $this->settings = array(
            
            array('field'=>'title', 'class'=> 'bg-primary text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=>"Automatically send customer list csv", 'type'=>"setting_category"),
            array('field'=>'pi_ewcl_enable_email', 'label'=>__('Send customer list in email'),'type'=>'switch', 'default'=> 0,   'desc'=>'You can schedule when to receive the emails'),
            array('field'=>'pi_ewcl_email', 'label'=>__('Email id'),'type'=>'text',   'desc'=>'Email id that will receive the csv attachment email, you can add more then one email id separated with comma ,'),
            array('field'=>'pi_ewcl_email_subject', 'label'=>__('Subject of the email'),'type'=>'text',   'desc'=>'subject of the email'),
            array('field'=>'pi_ewcl_email_message', 'label'=>__('Message of the email'),'type'=>'textarea',   'desc'=>'Message of the email, this support 2 short code using this short code you can know the registration record is between which time frame <br><strong>[after]</strong> => show the start time , <br><strong>[before]</strong> => show the end time used for setting the extraction range ', 'default'=>'This is auto generated email containing the list of the customers who registered in your site between [after] and [before]'),
            array('field'=>'pi_ewcl_email_frequency', 'label'=>__('Frequency of email'),'type'=>'select',   'desc'=>'Email should be send daily, weekly (weekly email will be send on every Monday) or twice daily', 'value'=>array('hourly'=>'Hourly', 'daily'=>'Daily','twicedaily'=>'Twice daily', 'weekly'=>'Weekly'), 'default'=>'daily'),

            array('field'=>'pi_ewcl_include_report', 'label'=>__('Include Customer'),'type'=>'select',   'desc'=>'Include Registered customer csv, Guest customer csv or both the customer csv in report', 'value'=>array('registered'=>'Send only registered customer detail', 'guest'=>'Send only gust customer detail', 'both'=>'Send registered and guest customer detail'), 'default'=>'registered'),
            
        );
        
        $this->active_tab = (isset($_GET['tab'])) ? sanitize_text_field($_GET['tab']) : 'default';

        if($this->this_tab == $this->active_tab){
            add_action($this->plugin_name.'_tab_content', array($this,'tab_content'));
        }


        add_action($this->plugin_name.'_tab', array($this,'tab'),3);

       
        $this->register_settings();

        if(PI_EWCL_DELETE_SETTING){
            $this->delete_settings();
        }

        $this->pi_ewcl_enable_email = get_option('pi_ewcl_enable_email',0);
        $this->email = get_option('pi_ewcl_email');
        $this->subject = get_option('pi_ewcl_email_subject');
        $this->message = get_option('pi_ewcl_email_message');
        $this->frequency = get_option('pi_ewcl_email_frequency','daily');

        add_filter( 'cron_schedules', array($this, 'cron_add_weekly') );

        $this->cron_event = 'pi_ewcl_customer_email';
        //add_action( 'wp_loaded' , array($this, 'sendEmail') );
        $time_based_on_frequency = $this->timeBasedOnFrequency();
        if($this->pi_ewcl_enable_email == 1 && $this->email != ""){
            add_action( $this->cron_event , array($this, 'sendEmail') );
            
            if ( ! wp_next_scheduled( $this->cron_event ) ) {
                wp_schedule_event( $time_based_on_frequency, $this->frequency, $this->cron_event );
            }
            $set_frequency = wp_get_schedule($this->cron_event);
            if($set_frequency != $this->frequency){
                wp_clear_scheduled_hook($this->cron_event);
                wp_schedule_event( $time_based_on_frequency, $this->frequency, $this->cron_event );
            }
        }

    }

    function timeBasedOnFrequency(){
        $today = current_time('Y/m/d');
        switch($this->frequency){
            case 'daily':
                return $this->wp_strtotime(date('Y/m/d',strtotime('+1 days', current_time('timestamp'))));
            break;

            case 'weekly':
                return $this->wp_strtotime(date('Y/m/d H:i',strtotime('next monday', current_time('timestamp'))));
            break;

            case 'hourly':
                return $this->wp_strtotime(date('Y/m/d H:00',strtotime('+1 hour', current_time('timestamp'))));
            break;

            case 'twicedaily':
                return $this->wp_strtotime(date('Y/m/d H:00',strtotime('+12 hour', current_time('timestamp'))));
            break;
        }
    }

    function wp_strtotime($str) {
        // This function behaves a bit like PHP's StrToTime() function, but taking into account the Wordpress site's timezone
        // CAUTION: It will throw an exception when it receives invalid input - please catch it accordingly
        // From https://mediarealm.com.au/
        
        $tz_string = get_option('timezone_string');
        $tz_offset = get_option('gmt_offset', 0);
        
        if (!empty($tz_string)) {
            // If site timezone option string exists, use it
            $timezone = $tz_string;
        
        } elseif ($tz_offset == 0) {
            // get UTC offset, if it isn’t set then return UTC
            $timezone = 'UTC';
        
        } else {
            $timezone = $tz_offset;
            
            if(substr($tz_offset, 0, 1) != "-" && substr($tz_offset, 0, 1) != "+" && substr($tz_offset, 0, 1) != "U") {
                $timezone = "+" . $tz_offset;
            }
        }
        
        $datetime = new DateTime($str, new DateTimeZone($timezone));
        return $datetime->format('U');
      }

    
    function delete_settings(){
        foreach($this->settings as $setting){
            delete_option( $setting['field'] );
        }
    }

    function register_settings(){   

        foreach($this->settings as $setting){
            register_setting( $this->setting_key, $setting['field']);
        }
    
    }

    function tab(){
        ?>
        <a class=" px-3 text-light d-flex align-items-center  border-left border-right  <?php echo ($this->active_tab == $this->this_tab ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab ); ?>">
            <?php _e( $this->tab_name); ?> 
        </a>
        <?php
    }

    function tab_content(){
        ?>
        <form method="post" action="options.php"  class="pisol-setting-form">
        <?php settings_fields( $this->setting_key ); ?>
        <?php
            foreach($this->settings as $setting){
                new pisol_class_form_ewcl($setting, $this->setting_key);
            }
        ?>
        <input type="submit" class="mt-3 btn btn-primary btn-sm" value="Save Option" />
        </form>
       <?php
    }

    function save(){
        
        $before = $this->before(true);
        $after = $this->after(true);

        //error_log('after:'.$after);
       // error_log('before:'.$before);

        $data_obj = new class_customer_data_extractor(0, 0,  $after, $before, array('customer'));
        $rows = $data_obj->getRows();
        $header = $data_obj->getHeader();
        $delimiter = ",";
        $filename_initial = "customer_initial";
        
        $csv_file_obj = new class_pisol_ewcl_csv_maker($header, $rows, $delimiter, $filename_initial);

        $file = $csv_file_obj->save();
        return $file;
    }    

    function guestCustomer(){

        $delimiter = ",";

        
        $after = $this->after(true); 
        
        $before = $this->before(true);

        //error_log('G after:'.$after);
        //error_log('G before:'.$before);

        $after = strtotime($after);
        $before = strtotime($before);

        $order_status = array();

        $data_obj = new class_guest_data_extractor($after, $before, $order_status);

        $rows = $data_obj->getRows();
        $header = $data_obj->getHeader();
        
        $filename_initial = "guest_customer_initial";
        
        $csv_file_obj = new class_pisol_ewcl_csv_maker($header, $rows, $delimiter, $filename_initial);
        $file = $csv_file_obj->save();
        return $file;
        
    }

    function sendEmail(){
        $file_to_attach = get_option('pi_ewcl_include_report','registered');
        if($file_to_attach == 'registered'){
            $file[] = $this->save();
        }elseif($file_to_attach == 'guest'){
            $file[] = $this->guestCustomer();
        }elseif($file_to_attach == 'both'){
            $file[] = $this->guestCustomer();
            $file[] = $this->save();
        }

        $before = $this->before();
        $after = $this->after();

        $message = get_option('pi_ewcl_email_message','This is auto generated email containing the list of the customers who registered in your site between [after] and [before]');

        $short_code = array('[before]' => $before, '[after]' => $after);

        $message = str_replace(array_keys($short_code), array_values($short_code), $message);

        

        $email = $this->email;
        $subject = $this->subject; 
        $template = file_get_contents(plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/email_template.html');  

        $template = str_replace ('[message]', $message, $template);

       $email_obj = new class_pisol_ewcl_email($email, $subject, $template, $file);
       $email_obj->send();
    }

    function after($without_gmt = false){  
        $next_run = wp_next_scheduled($this->cron_event);
        $frequency = get_option('pi_ewcl_email_frequency','daily');
        $value = '-2 day';
        if($next_run){
            if($frequency == 'daily'){
                $value = '-2 days';
            }

            if($frequency == 'weekly'){
                $value = '-14 days';
            }

            if($frequency == 'hourly'){
                $value = '-2 hour';
            }

            if($frequency == 'twicedaily'){
                $value = '-24 hour';
            }

            if($without_gmt){
                /**
                 * without GMT is needed for the registered customer data as registered customer time is saved in universal time format
                 */
                $next_run = date( 'Y-m-d H:i:s', $next_run );
            }else{
                $next_run = get_date_from_gmt( date( 'Y-m-d H:i:s', $next_run ), 'Y-m-d H:i:s' );
            }
            return date('Y-m-d H:i:s', strtotime($value, strtotime($next_run)));
        }
        return "";
    }

    function before($without_gmt = false){  
        $next_run = wp_next_scheduled($this->cron_event);
        $frequency = get_option('pi_ewcl_email_frequency','daily');
        $value = '-1 day';
        if($next_run){
            if($frequency == 'daily'){
                $value = '-1 days';
            }

            if($frequency == 'weekly'){
                $value = '-7 days';
            }

            if($frequency == 'hourly'){
                $value = '-1 hour';
            }

            if($frequency == 'twicedaily'){
                $value = '-12 hour';
            }

            if($without_gmt){
                /**
                 * without GMT is needed for the registered customer data as registered customer time is saved in universal time format
                 */
                $next_run = date( 'Y-m-d H:i:s', $next_run );
            }else{
                $next_run = get_date_from_gmt( date( 'Y-m-d H:i:s', $next_run ), 'Y-m-d H:i:s' );
            }
            return date('Y-m-d H:i:s', strtotime($value, strtotime($next_run)));
        }
        return "";
    }
    
    function cron_add_weekly( $schedules ) {
        // Adds once weekly to the existing schedules.
        $schedules['weekly'] = array(
            'interval' => 604800,
            'display' => __( 'Once Weekly' )
        );
        return $schedules;
     }
    
}

new Class_Pi_Ewcl_Email($this->plugin_name);