<?php

class pisol_ewcl_ajax_registered_data_extractor{
    function __construct(){
        add_action('wp_ajax_pisol_ewcl_export_registered_data', array($this, 'exportRegisteredRecord'));
    }

    function exportRegisteredRecord(){


        if(!current_user_can( 'administrator' )) return;

        parse_str( $_POST['form'], $form );

	    $_REQUEST = $form = (array) $form;

        $step     = absint( $_POST['step'] );

        $limit = !empty($form['pi_limit']) && is_numeric($form['pi_limit']) ? $form['pi_limit'] : 10;

        $after = (isset($form['pi_ewcl_download_after_date']) && $form['pi_ewcl_download_after_date'] != "") ? sanitize_text_field($form['pi_ewcl_download_after_date']).' 00:00:01' : "1986-08-20 00:00:01";
        
        $before = (isset($form['pi_ewcl_download_before_date']) && $form['pi_ewcl_download_before_date'] != "") ? sanitize_text_field($form['pi_ewcl_download_before_date']).' 23:59:59' : "";

        $delimiter = isset($form['pi_ewcl_delimiter']) ? $form['pi_ewcl_delimiter'] : ",";

        $roles = (isset($form['pi_ewcl_user_role']) && is_array($form['pi_ewcl_user_role'])) ? $form['pi_ewcl_user_role']: array('customer');

        $download_limit = empty($form['pi_ewcl_download_limit']) || !is_numeric($form['pi_ewcl_download_limit']) ? 0 : esc_html($form['pi_ewcl_download_limit']);

        $skip_rows = empty($form['pi_ewcl_download_offset']) || !is_numeric($form['pi_ewcl_download_offset']) ? 0 : esc_html($form['pi_ewcl_download_offset']);

        $row_extracted = empty($_POST['row_extracted']) || !is_numeric($_POST['row_extracted']) ? 0 : esc_html($_POST['row_extracted']);

    
        $step = $step === 0 || $step === '0' ? $skip_rows : $step;

        if(!empty($before) && !empty($after) && strtotime($after) > strtotime($before)){
            $data = array(
                'error'=> "Start date cant be after End date",
            );
            wp_send_json($data,400);
        }


        
        $data_obj = new class_customer_data_extractor($limit, $step, $after, $before, $roles);

        $rows = $data_obj->getRows();
        $header = '';

        $row_extracted = count($rows) + $row_extracted;

        if(empty($_POST['file_name'])){
            
            $filename_initial = "customer_initial";

            $file_name = class_pisol_ewcl_csv_maker2::createFile($filename_initial);

            $header = $data_obj->getHeader();
        }else{
            $file_name = $_POST['file_name'];
        }

        $write_result = class_pisol_ewcl_csv_maker2::writeToFile($file_name, $header, $rows, $delimiter);
        
        if(empty($rows)){
            $step = 'done';
        }else{
            $step = $limit + $step;
        }

        if(!empty( $download_limit) && $row_extracted >= $download_limit ){
            $step = 'done';
        }

        $download_url = add_query_arg('pisol_download_file', $file_name, $form['_wp_http_referer']);

        $data = array(
            'step'=>$step ,
            'file_name'=> $file_name,
            'download_url' => $download_url,
            'row_extracted' => $row_extracted
        );

        if($write_result !== true){
            $data = array(
                'error'=> $write_result,
            );
            wp_send_json($data,400);
        }

        wp_send_json($data);
	    
    }

}
new pisol_ewcl_ajax_registered_data_extractor();