<?php

class pisol_ewcl_ajax_prod_customer_data_extractor{
    function __construct(){
        add_action('wp_ajax_pisol_ewcl_export_prod_customer_data', array($this, 'exportRegisteredRecord'));

        add_action( 'wp_ajax_pi_ewcl_search_product', array( $this, 'search_product' ) );
    }

    function exportRegisteredRecord(){


        if(!current_user_can( 'administrator' )) return;

        parse_str( $_POST['form'], $form );

	    $_REQUEST = $form = (array) $form;

        $step     = absint( $_POST['step'] );

        $limit = !empty($form['pi_limit']) && is_numeric($form['pi_limit']) ? $form['pi_limit'] : 10;

        $after = (isset($form['pi_ewcl_download_after_date']) && $form['pi_ewcl_download_after_date'] != "") ? sanitize_text_field($form['pi_ewcl_download_after_date']).' 00:00:01' : "1986-08-20 00:00:01";
        
        $before = (isset($form['pi_ewcl_download_before_date']) && $form['pi_ewcl_download_before_date'] != "") ? sanitize_text_field($form['pi_ewcl_download_before_date']).' 23:59:59' : "";

        $delimiter = isset($form['pi_ewcl_delimiter']) ? $form['pi_ewcl_delimiter'] : ",";

        $products = (isset($form['products']) && is_array($form['products'])) ? $form['products']: array();

        $download_limit = empty($form['pi_ewcl_download_limit']) || !is_numeric($form['pi_ewcl_download_limit']) ? 0 : esc_html($form['pi_ewcl_download_limit']);

        $skip_rows = empty($form['pi_ewcl_download_offset']) || !is_numeric($form['pi_ewcl_download_offset']) ? 0 : esc_html($form['pi_ewcl_download_offset']);

        $selection_logic = empty($form['selection_logic']) ? 'any-one' : sanitize_text_field($form['selection_logic']);

        $row_extracted = empty($_POST['row_extracted']) || !is_numeric($_POST['row_extracted']) ? 0 : esc_html($_POST['row_extracted']);

        $order_status = isset($form['pi_ewcl_order_status']) ? $form['pi_ewcl_order_status'] : array();

    
        $step = $step === 0 || $step === '0' ? $skip_rows : $step;

        if(!empty($before) && !empty($after) && strtotime($after) > strtotime($before)){
            $data = array(
                'error'=> "Start date cant be after End date",
            );
            wp_send_json($data,400);
        }


        
        $data_obj = new class_prod_customer_data_extractor($after, $before, $products, $order_status, $limit, $step,  $selection_logic );

        $rows = $data_obj->getRows();
        $header = '';

        $row_extracted = count($rows) + $row_extracted;

        if(empty($_POST['file_name'])){
            
            $filename_initial = "customer_initial";

            $file_name = class_pisol_ewcl_csv_maker2::createFile($filename_initial);

            $header = $data_obj->getHeader();
        }else{
            $file_name = $_POST['file_name'];
        }

        $write_result = class_pisol_ewcl_csv_maker2::writeToFile($file_name, $header, $rows, $delimiter);
        
        if(empty($rows)){
            $step = 'done';
        }else{
            $step = $limit + $step;
        }

        if(!empty( $download_limit) && $row_extracted >= $download_limit ){
            $step = 'done';
        }

        $download_url = add_query_arg('pisol_download_file', $file_name, $form['_wp_http_referer']);

        $data = array(
            'step'=>$step ,
            'file_name'=> $file_name,
            'download_url' => $download_url,
            'row_extracted' => $row_extracted
        );

        if($write_result !== true){
            $data = array(
                'error'=> $write_result,
            );
            wp_send_json($data,400);
        }

        wp_send_json($data);
	    
    }

    public function search_product( $x = '', $post_types = array( 'product' ) ) {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

        ob_start();
        
        if(!isset($_GET['keyword'])) die;

		$keyword = isset($_GET['keyword']) ? sanitize_text_field($_GET['keyword']) : "";

		if ( empty( $keyword ) ) {
			die();
		}
		$arg            = array(
			'post_status'    => 'publish',
			'post_type'      => $post_types,
			'posts_per_page' => 50,
			's'              => $keyword

		);
		$the_query      = new WP_Query( $arg );
		$found_products = array();
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$prd = wc_get_product( get_the_ID() );
				$cat_ids  = wp_get_post_terms( get_the_ID(), 'product_cat', array( 'fields' => 'ids' ) );

				/* remove grouped product or external product */
				if($prd->is_type('grouped') || $prd->is_type('external')){
					continue;
				}
				

				if ( $prd->has_child() && $prd->is_type( 'variable' ) ) {
					$product_children = $prd->get_children();
                    $parent_id = $prd->get_id();
                    $parent = array(
                        'id'   => $parent_id,
                        'text' => get_the_title( $parent_id )." (#{$parent_id})"
                    );

                    $found_products[] = $parent;

					if ( count( $product_children ) ) {
						foreach ( $product_children as $product_child ) {
							if ( pisol_wc_version_check() ) {
								$product = array(
									'id'   => $product_child,
									'text' => str_replace("&#8211;",">",get_the_title( $product_child )." (#{$product_child})")
								);

							} else {
								$child_wc  = wc_get_product( $product_child );
								$get_atts  = $child_wc->get_variation_attributes();
								$attr_name = array_values( $get_atts )[0];
								$product   = array(
									'id'   => $product_child,
									'text' => get_the_title() . ' - ' . $attr_name." (#{$product_child})"
								);

							}
							$found_products[] = $product;
						}

					}
				} else {
					$product_id    = get_the_ID();
					$product_title = get_the_title();
					$the_product   = new WC_Product( $product_id );
					if ( ! $the_product->is_in_stock() ) {
						$product_title .= ' (Out of stock)';
					}
					$product          = array( 'id' => $product_id, 'text' => $product_title." (#{$product_id})" );
					$found_products[] = $product;
				}
			}
        }
		wp_send_json( $found_products );
		die;
    }


}
new pisol_ewcl_ajax_prod_customer_data_extractor();

if(!function_exists('pisol_wc_version_check')){
    function pisol_wc_version_check( $version = '3.0' ) {
        if ( class_exists( 'WooCommerce' ) ) {
            global $woocommerce;
            if ( version_compare( $woocommerce->version, $version, ">=" ) ) {
                return true;
            }
        }
        return false;
    }
}