<?php

class pisol_ewcl_ajax_guest_data_extractor{
    function __construct(){
        add_action('wp_ajax_pisol_ewcl_export_guest_data', array($this, 'exportGuestRecord'));

        add_action('wp_loaded', array($this, 'download'));
    }

    function exportGuestRecord(){


        if(!current_user_can( 'administrator' )) return;

        parse_str( $_POST['form'], $form );

	    $_REQUEST = $form = (array) $form;

        $step     = absint( $_POST['step'] );

        $limit = !empty($form['pi_limit']) && is_numeric($form['pi_limit']) ? $form['pi_limit'] : 10;

        

        $delimiter = isset($form['pi_ewcl_delimiter']) ? $form['pi_ewcl_delimiter'] : ",";

        $after = isset($form['pi_ewcl_download_after_date']) ? sanitize_text_field($form['pi_ewcl_download_after_date']): "";
        
        $before = isset($form['pi_ewcl_download_before_date']) ? sanitize_text_field($form['pi_ewcl_download_before_date']) : "";

        $order_status = isset($form['pi_ewcl_order_status']) ? $form['pi_ewcl_order_status'] : array();

        $row_extracted = empty($_POST['row_extracted']) || !is_numeric($_POST['row_extracted']) ? 0 : esc_html($_POST['row_extracted']);

        if(!empty($before) && !empty($after) && strtotime($after) > strtotime($before)){
            $data = array(
                'error'=> "Start date cant be after End date",
            );
            wp_send_json($data,400);
        }


        $data_obj = new class_guest_data_extractor($after, $before, $order_status, $limit, $step );

        $rows = $data_obj->getRows();
        $header = '';

        $row_extracted = count($rows) + $row_extracted;

        if($step == 0 && empty($_POST['file_name'])){
            
            $filename_initial = "customer_initial";

            $file_name = class_pisol_ewcl_csv_maker2::createFile($filename_initial);

            $header = $data_obj->getHeader();
        }else{
            $file_name = $_POST['file_name'];
        }

        $write_result = class_pisol_ewcl_csv_maker2::writeToFile($file_name, $header, $rows, $delimiter);
        
        if(empty($rows)){
            $step = 'done';
        }else{
            $step = $limit + $step;
        }

        $download_url = add_query_arg('pisol_download_file', $file_name, $form['_wp_http_referer']);

        $data = array(
            'step'=>$step ,
            'file_name'=> $file_name,
            'download_url' => $download_url,
            'row_extracted' => $row_extracted
        );

        if($write_result !== true){
            $data = array(
                'error'=> $write_result,
            );
            wp_send_json($data,400);
        }

        wp_send_json($data);
	    
    }

    function download(){
        if(!empty($_GET['pisol_download_file']) && current_user_can( 'administrator' )){
            class_pisol_ewcl_csv_maker2::triggerDownload($_GET['pisol_download_file']);
        }
    }
}
new pisol_ewcl_ajax_guest_data_extractor();