<?php

class class_customer_data_extractor{

    private $fields = array();
    private $header = array();
    private $rows = array();

    function __construct($limit, $offset, $after, $before, $roles = array('customer')){
        $saved_fields = get_option('pi_customer_row',array()) ;
        $this->fields = self::selectedFields($saved_fields);
        $this->limit = $limit;
        $this->offset = $offset;
        $this->after_date = $after;
        $this->before_date = $before;
        $this->roles = $roles;

        $this->header = $this->header();
        $this->rows = $this->rows();
        
    }

    function rows(){
        $users_array = $this->getUsers();
        $wp_users = $this->getWpUsers($users_array);
        $formated = array();
        foreach($wp_users as $user){
            $formated[] = $this->row($user);
        }
        return $formated ;
    }

    function getWpUsers($users_array){
        $users = array();
        foreach($users_array as $user){
            $id = $user['ID'];
            $users[] = get_user_by('id', $id);
        }
        return $users;
    }

    function getUsers(){
        global $wpdb;


        $sql = 'SELECT * FROM '.$wpdb->users.' INNER JOIN '.$wpdb->usermeta.'
        ON '.$wpdb->users.'.ID = '.$wpdb->usermeta.'.user_id
        WHERE '.$wpdb->usermeta.'.meta_key = "'.$wpdb->prefix.'capabilities"
        AND ';

        $roles_query = $this->roleQuery();

        $sql = $sql.$roles_query;

        $date_query = $this->datequery();

        $sql = $sql.$date_query;

        $sql = $sql.$this->limit();
        $sql = $sql.$this->offset();

        //error_log('sql:'.$sql);
        
        $users = $wpdb->get_results($sql, ARRAY_A);
        
        return $users;
    }

    function getRoles(){
        $roles = $this->roles; 
        return $roles;
    }

    /** 
     * if date range is given or single date is given
     */
    function datequery(){
        global $wpdb;
        $where = "";
        $after = "";
        $and = "";
        $before = "";
        if($this->after_date != ""){
            $after = ' '.$wpdb->users.'.user_registered >= "'.$this->after_date.'" ';
        } 

        if($this->before_date != ""){
            $before = ' '.$wpdb->users.'.user_registered <= "'.$this->before_date.'" ';
        } 

        if($this->after_date != "" && $this->before_date != ""){
            $and = ' AND ';
        }

        if($this->after_date == "" && $this->before_date == ""){
            return;
        }

        return ' AND ('.$after.$and.$before.')';
    }

    function limit(){
        if(isset($this->limit) && $this->limit != "" && $this->limit != 0){
            return ' LIMIT '.$this->limit;
        }else{
            return ' LIMIT 10000000000000000000';
        }
        
    }

    function offset(){
        if(isset($this->offset) && $this->offset != ""){
            return ' OFFSET '.$this->offset;
        }
        return ;
    }

    function roleQuery(){
        global $wpdb;
        $roles = $this->getRoles();
        $roles_like = array();
        foreach($roles as $role){
            $roles_like[] = $wpdb->usermeta.'.meta_value LIKE "%'.$role.'%" ';
        }
        if(count($roles_like) > 0){
            $roles_query = '('.implode(" OR ", $roles_like).')';
        }else{
            $roles_query = 0;
        }
        return $roles_query;
    }

    private function row($user){
        foreach($this->fields as $key => $value){
            $user_meta =  $user->get($key);

            if(empty($user_meta) && pisol_ewcl_search_order_meta::isCustomFields($key)){
                $user_meta =  pisol_ewcl_search_order_meta::orderMeta($key, $user->ID);
            }

            $woocommerce_user[$key] =  $user_meta;
        }
        return $woocommerce_user;
    }

    private function header(){
        foreach($this->fields as $key => $value){
            $header[] =  $value;
        }
        return $header;
    }

    function getRows(){
        return $this->rows;
    }

    function getHeader(){
        return $this->header;
    }

    static function fields(){
        $fields = array(
            'ID'=> 'ID',
            'user_login'=>'user_login',
            'user_pass'=>'user_pass',
            'user_nickname'=>'user_nickname',
            'user_email'=>'user_email',
            'user_url'=>'user_url',
            'user_registered'=>'user_registered',
            'display_name'=>'display_name',
            'first_name'=>'first_name',
            'last_name'=>'last_name',
            'user_status'=>'user_status',
            'roles'=>'roles',
            'billing_first_name'=>'billing_first_name',
            'billing_last_name'=>'billing_last_name',
            'billing_company'=>'billing_company',
            'billing_address_1'=>'billing_address_1',
            'billing_address_2'=>'billing_address_2',
            'billing_city'=>'billing_city',
            'billing_postcode'=>'billing_postcode',
            'billing_country'=>'billing_country',
            'billing_state'=>'billing_state',
            'billing_email'=>'billing_email',
            'billing_phone'=>'billing_phone',
            'shipping_first_name'=>'shipping_first_name',
            'shipping_last_name'=>'shipping_last_name',
            'shipping_company'=>'shipping_company',
            'shipping_address_1'=>'shipping_address_1',
            'shipping_address_2'=>'shipping_address_2',
            'shipping_city'=>'shipping_city',
            'shipping_postcode'=>'shipping_postcode',
            'shipping_country'=>'shipping_country',
            'shipping_state'=>'shipping_state',
        );
        $fields = apply_filters('pisol_ewcl_fields_filter', $fields);
        return $fields;
    }

    static function selectedFields($saved_fields){
        $fields = self::fields();
        $formated_saved_fields = array();
        if(count($saved_fields) > 0 ){
            foreach($fields as $key => $value){
                if(isset($saved_fields[$key]['enabled'])){
                    $formated_saved_fields[$key] = $saved_fields[$key]['label'];
                }elseif($key == 'ID'){
                    $formated_saved_fields[$key] = $value;
                }
            }
        }else{
            return $fields;
        }
        return $formated_saved_fields;
    }

}