<?php

class pisol_ewcl_add_custom_fields{
    public $plugin_name;

    private $settings = array();

    private $active_tab;

    private $this_tab = 'add_custom_fields';

    private $tab_name = "Custom data fields";

    private $setting_key = 'pi_ewcl_custom_fields';

    function __construct($plugin_name){
        $this->plugin_name = $plugin_name;

        $this->settings = array(
            
            array('field'=>'pi_customer_added_fields')
            
        );

        $this->active_tab = (isset($_GET['tab'])) ? sanitize_text_field($_GET['tab']) : 'default';

        if($this->this_tab == $this->active_tab){
            add_action($this->plugin_name.'_tab_content', array($this,'tab_content'));
        }

        $this->register_settings();

        /**
         * we will auto enable this newly added field in the 
         * list of columns
         */
        add_action('update_option_pi_customer_added_fields', array($this, 'enablingNewlyAddedField'),10,2);
    }

    function register_settings(){   

        foreach($this->settings as $setting){
            register_setting( $this->setting_key, $setting['field']);
        }

    }

    function tab(){
        ?>
        <a class=" px-3 text-light d-flex align-items-center  border-left border-right  <?php echo ($this->active_tab == $this->this_tab ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo admin_url( 'admin.php?page='.sanitize_text_field($_GET['page']).'&tab='.$this->this_tab ); ?>">
            <?php _e( $this->tab_name); ?> 
        </a>
        <?php
    }

    function tab_content(){
        $this->tabContentAddExtraFields();
    }

    function tabContentAddExtraFields(){
        $customer_rows2 = get_option('pi_customer_added_fields',array());
        if(!is_array( $customer_rows2 )){
            $customer_rows2 = array();
        }
       ?>
       <div id="row_title" class="row py-4 border-bottom align-items-center bg-primary text-light mb-3">
                <div class="col-6">
                <h2 class="mt-0 mb-0 text-light font-weight-light h4">Add custom  user meta / order meta field name that you want to download</h2>
                </div>
            </div>
       <div class="row">
            <div class="col-12 col-md-6">
            <form action="options.php" method="POST">
            <script>
                var pi_extra_custom_field = <?php echo json_encode(array_values($customer_rows2)); ?>
            </script>
            <?php //print_r($customer_rows2); ?>
            <?php settings_fields( $this->setting_key ); ?>
            
            <div class="row">
                <div class="col-12 text-left">
                    <a href="javascript:void(0);" class="btn btn-primary btn-sm " id="pi-ewcl-add-custom-meta">Add Field</a>
                </div>
            </div>
            <div id="pi-ewcl-field-container">

            </div>
            <input type="submit" class="btn btn-primary mt-3" value="Save Fields">
            </form>
            </div>
            <div class="col-12 col-md-6">
            <div class="border p-2">
                <b>Step 1:</b> Get the name of the user meta / order meta field that you want to add in csv (and make sure that field is not present in our given list)<br>
                <b>Step 2:</b> Add that name on the left side form<br>
                <b>Step 3:</b> Go to the "Columns in CSV"<br>
                <b>Step 4:</b> Your added field will appear in the list, select it and save it <br>
                <br>
                In case you want to remove that field from CSV you can unselect it, or if you want to completely remove it then remove it from this form where you addd it
            </div>
            </div>
       </div>
       <?php
    }

    function enablingNewlyAddedField($old_custom_fields, $custom_fields){
        $new_fields = array();
        if(empty($custom_fields) || !is_array($custom_fields)) return;
        
        $saved_customer_columns = get_option('pi_customer_row', array());
        $count_saved_customer_columns = is_array($saved_customer_columns) ? count($saved_customer_columns) : 0;

        if($count_saved_customer_columns <= 0){
            self::initializeCustomerCol();
            $saved_customer_columns = get_option('pi_customer_row', array());
            $count_saved_customer_columns = is_array($saved_customer_columns) ? count($saved_customer_columns) : 0;
        }
        
        $saved_guest_columns = get_option('pi_guest_customer_row', array());
        $count_saved_guest_columns = is_array($saved_guest_columns) ? count($saved_guest_columns) : 0;

        if($count_saved_guest_columns <= 0){
            self::initializeGuestCustomerCol();
            $saved_guest_columns = get_option('pi_guest_customer_row', array());
            $count_saved_guest_columns = is_array($saved_guest_columns) ? count($saved_guest_columns) : 0;
        }

        foreach($custom_fields as $custom_field){

            if($count_saved_customer_columns > 0 && !isset($saved_customer_columns[$custom_field['field']])){
                $saved_customer_columns[$custom_field['field']] = array('enabled'=>'on', 'label'=>$custom_field['field']);
            }

            if($count_saved_guest_columns > 0 && !isset($saved_guest_columns[$custom_field['field']])){
                $saved_guest_columns[$custom_field['field']] = array('enabled'=>'on', 'label'=>$custom_field['field']);
            }

        }

        update_option('pi_customer_row', $saved_customer_columns);
        //delete_option('pi_customer_row');
        update_option('pi_guest_customer_row', $saved_guest_columns);
        //delete_option('pi_guest_customer_row');
    }   

	static function initializeCustomerCol(){
		$saved_customer_columns = get_option('pi_customer_row', array());
        
		if(empty($saved_customer_columns)){
			$customer_fields = class_customer_data_extractor::fields();
			foreach($customer_fields as $c_field => $label){
				if(!isset($saved_customer_columns[$c_field])){
					$saved_customer_columns[$c_field] = array('enabled'=>'on', 'label'=>$label);
				}
			}
		}

		update_option('pi_customer_row', $saved_customer_columns);
	}

	static function initializeGuestCustomerCol(){
		$saved_customer_columns = get_option('pi_guest_customer_row', array());
        
		if(empty($saved_customer_columns)){
			$customer_fields = class_guest_data_extractor::fields();
			foreach($customer_fields as $c_field => $label){
				if(!isset($saved_customer_columns[$c_field])){
					$saved_customer_columns[$c_field] = array('enabled'=>'on', 'label'=>$label);
				}
			}
		}

		update_option('pi_guest_customer_row', $saved_customer_columns);
	}
}

new pisol_ewcl_add_custom_fields($this->plugin_name);