export default function BrandIcon({width = 24, height = 24, ...props}) {
    return (
        <svg
            width={width}
            height={height}
            clipRule="evenodd"
            fillRule="evenodd"
            strokeLinejoin="round"
            strokeMiterlimit="1.41421"
            viewBox="0 0 208 115"
            xmlns="http://www.w3.org/2000/svg"
            {...props}
        >
            <g fillRule="nonzero">
                <path
                    d="m136.03 50.254c0-11.712 9.528-21.24 21.24-21.24 11.711 0 21.239 9.528 21.239 21.24v50.28c0 7.989 6.474 14.463 14.463 14.463 7.988 0 14.463-6.474 14.463-14.463v-50.28c0-27.66-22.505-50.166-50.165-50.166-13.96 0-26.601 5.738-35.704 14.971 8.934 9.063 14.461 21.494 14.461 35.195z"
                    fill="#46c1c2"/>
                <path
                    d="m107.104 50.254c0-13.701 5.527-26.132 14.462-35.195-9.104-9.233-21.745-14.971-35.704-14.971-13.958 0-26.597 5.736-35.7 14.967 8.913 9.038 14.433 21.429 14.463 35.088.06-11.661 9.562-21.129 21.237-21.129 11.711 0 21.239 9.528 21.239 21.24z"
                    fill="#3bc3d5"/>
                <path
                    d="m136.027 100.534v-50.28c0-13.701-5.527-26.132-14.461-35.195-8.935 9.063-14.462 21.494-14.462 35.195v50.283c0 3.994 1.618 7.609 4.235 10.226 2.617 2.616 6.232 4.234 10.225 4.234 7.988 0 14.463-6.474 14.463-14.463z"
                    fill="#14a9b2"/>
                <path
                    d="m14.462.088c-7.988 0-14.462 6.475-14.462 14.463 0 7.989 6.474 14.463 14.462 14.463 11.675 0 21.177 9.468 21.237 21.129.03-13.659 5.55-26.05 14.463-35.088-9.103-9.231-21.742-14.967-35.7-14.967z"
                    fill="#1482c5"/>
                <path
                    d="m35.699 50.143c0 .037.003.074.003.111v50.28c0 7.989 6.474 14.463 14.463 14.463 2.494 0 4.841-.631 6.889-1.743 4.508-2.449 7.568-7.225 7.568-12.717v-50.283c0-.037.003-.074.003-.111-.03-13.659-5.55-26.05-14.463-35.088-8.913 9.038-14.433 21.429-14.463 35.088z"
                    fill="#0f6cb2"/>
                <path
                    d="m28.907 14.542c0 7.983-6.471 14.454-14.454 14.454-7.982 0-14.453-6.471-14.453-14.454 0-7.982 6.471-14.453 14.453-14.453 7.983 0 14.454 6.471 14.454 14.453z"
                    fill="#164699"/>
                <path
                    d="m64.603 100.546c0 7.983-6.471 14.454-14.453 14.454-7.983 0-14.454-6.471-14.454-14.454 0-7.982 6.471-14.453 14.454-14.453 7.982 0 14.453 6.471 14.453 14.453z"
                    fill="#0a579b"/>
                <path
                    d="m136.011 100.546c0 7.983-6.472 14.454-14.453 14.454-7.983 0-14.454-6.471-14.454-14.454 0-7.982 6.471-14.453 14.454-14.453 7.981 0 14.453 6.471 14.453 14.453z"
                    fill="#108e9f"/>
                <path
                    d="m207.435 100.546c0 7.983-6.471 14.454-14.454 14.454-7.982 0-14.453-6.471-14.453-14.454 0-7.982 6.471-14.453 14.453-14.453 7.983 0 14.454 6.471 14.454 14.453z"
                    fill="#14aba3"/>
            </g>
        </svg>
    );
}
