<?php

use memberpress\courses\helpers as helpers;
use memberpress\quizzes\models as models;

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}

if (helpers\Lessons::has_next_lesson($current_lesson_index, $lesson_nav_ids)) {
    $next_page_url        = helpers\Lessons::next_lesson_link($current_lesson_index, $lesson_nav_ids);
    $continue_button_text = __('Continue', 'memberpress-course-quizzes');
} elseif (helpers\Lessons::has_next_section($current_section_index, $section_ids)) {
    $next_page_url        = helpers\Lessons::next_section_link($current_section_index, $section_ids);
    $continue_button_text = __('Continue', 'memberpress-course-quizzes');
} else {
    $next_page_url        = get_permalink($current_course->ID);
    $continue_button_text = __('Course Overview', 'memberpress-course-quizzes');
}
?>
<div id="mpcs-quiz-navigation">
  <?php if ($attempt instanceof models\Attempt && $attempt->is_complete() && !$show_submit) : ?>
    <button type="button" id="mpcs-quiz-continue-bottom" data-href="<?php echo esc_attr($next_page_url); ?>" class="<?php echo esc_attr(helpers\Options::val($options, 'complete-link-css')); ?>">
        <?php echo esc_html($continue_button_text); ?>
    </button>
  <?php else : ?>
    <button type="button" id="mpcs-quiz-submit-bottom" data-next-page-url="<?php echo esc_attr($next_page_url); ?>" class="<?php echo esc_attr(helpers\Options::val($options, 'complete-link-css')); ?>">
      <?php esc_html_e('Submit', 'memberpress-course-quizzes'); ?>
    </button>
  <?php endif; ?>
</div>
