<?php

use memberpress\courses as courses;
use memberpress\quizzes\models as models;

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}


if (courses\helpers\Lessons::has_next_lesson($current_lesson_index, $lesson_nav_ids)) {
    $next_page_url        = courses\helpers\Lessons::next_lesson_link($current_lesson_index, $lesson_nav_ids);
    $continue_button_text = __('Continue', 'memberpress-course-quizzes');
} elseif (courses\helpers\Lessons::has_next_section($current_section_index, $section_ids)) {
    $next_page_url        = courses\helpers\Lessons::next_section_link($current_section_index, $section_ids);
    $continue_button_text = __('Continue', 'memberpress-course-quizzes');
} else {
    $next_page_url        = get_permalink($current_course->ID);
    $continue_button_text = __('Course Overview', 'memberpress-course-quizzes');
}
?>
<section class="navbar-section" id="mpcs-lesson-navigation">
    <?php if ($attempt instanceof models\Attempt && $attempt->is_complete()) : ?>
        <button id="mpcs-classroom-next-lesson-link" data-href="<?php echo esc_attr($next_page_url); ?>" data-value="<?php echo esc_attr($post->ID) ?>" class="<?php echo esc_attr(courses\helpers\Options::val($options, 'complete-link-css')); ?>">
            <?php printf('<span>%s <i class="mpcs-right-big"></i></span>', esc_html($continue_button_text)); ?>
        </button>
    <?php else : ?>
        <button type="button" id="mpcs-quiz-submit" data-next-page-url="<?php echo esc_attr($next_page_url); ?>" class="<?php echo esc_attr(courses\helpers\Options::val($options, 'complete-link-css')); ?>">
            <?php printf('<span>%s <i class="mpcs-right-big"></i></span>', esc_html__('Submit', 'memberpress-course-quizzes')); ?>
        </button>
    <?php endif; ?>
    <a class="btn sidebar-open show-sm">
        <i class="mpcs-th-list"></i>
    </a>
</section>
