<?php

namespace memberpress\quizzes\emails;

use memberpress\courses as courses;
use memberpress\quizzes\helpers;
use memberpress\quizzes as base;

class UserQuizGradedEmail extends courses\lib\BaseEmail
{
    public $key = 'user_quiz_graded_email';

    /**
     * Set the default enabled, title, subject & body.
     *
     * @param array $args The arguments to set the defaults.
     */
    public function set_defaults($args = [])
    {
        $options           = get_option('mpcs-options');
        $this->title       = esc_html__('Quiz Graded Notice', 'memberpress-course-quizzes');
        $this->description = esc_html__('This email is sent to the student after their quiz has been graded.', 'memberpress-course-quizzes');
        $this->ui_order    = 0;

        $enabled = $use_template = $this->show_form = true;
        $subject = esc_html__('Your Quiz Grade for {$quiz_name} is Available', 'memberpress-course-quizzes');
        $body    = $this->body_partial();

        $this->defaults  = compact('enabled', 'subject', 'body', 'use_template');
        $this->variables = array_unique(courses\helpers\Courses::get_email_vars($this));
        $this->test_vars = [
            'quiz_url'                    => home_url() . '/courses/test-course/quiz/302',
            'quiz_points_possible'        => 100,
            'quiz_points_scored'          => 85,
            'quiz_score_percentage'       => 60,
            'quiz_bonus_points'           => 5,
            'quiz_passing_score_required' => 70,
            'quiz_did_pass'               => esc_html__('Yes', 'memberpress-course-quizzes'),
            'quiz_name'                   => esc_html__('Final Exam', 'memberpress-course-quizzes'),
            'quiz_id'                     => 302,
            'grade_quiz_url'              => home_url() . '/wp-admin/admin.php?page=grade-quiz&quiz_id=302',
            'quiz_retakes_allowed'        => esc_html__('Yes', 'memberpress-course-quizzes'),
            'quiz_retakes_remaining'      => 0,
        ];
    }

    /**
     * Get the views path for the email.
     *
     * @return string
     */
    public function get_views_path()
    {
        return base\VIEWS_PATH . '/emails/';
    }
}
