<?php

namespace memberpress\quizzes\emails;

use memberpress\courses as courses;
use memberpress\quizzes\helpers;
use memberpress\quizzes as base;

class AdminQuizFailedEmail extends courses\lib\BaseEmail
{
    public $key = 'admin_quiz_failed_email';

    /**
     * Set the default enabled, title, subject & body.
     *
     * @param array $args The arguments to set the defaults.
     */
    public function set_defaults($args = [])
    {
        $options           = get_option('mpcs-options');
        $this->to          = courses\helpers\Options::val($options, 'course_emails_admin_email');
        $this->title       = esc_html__('Admin Quiz Failed Notice', 'memberpress-course-quizzes');
        $this->description = esc_html__('This email is sent to the admin when a student fails a quiz and has reached the maximum retake attempts.', 'memberpress-course-quizzes');
        $this->ui_order    = 0;

        $enabled = $use_template = $this->show_form = true;
        $subject = esc_html__('{$user_full_name} failed Quiz: {$quiz_name}', 'memberpress-course-quizzes');
        $body    = $this->body_partial();

        $this->defaults  = compact('enabled', 'subject', 'body', 'use_template');
        $this->variables = array_unique(courses\helpers\Courses::get_email_vars($this));

        $this->test_vars = [
            'quiz_url'                    => home_url() . '/courses/test-course/quiz/302',
            'quiz_points_possible'        => 100,
            'quiz_points_scored'          => 85,
            'quiz_score_percentage'       => '60%',
            'quiz_bonus_points'           => 5,
            'quiz_passing_score_required' => 70,
            'quiz_did_pass'               => esc_html__('Yes', 'memberpress-course-quizzes'),
            'quiz_name'                   => esc_html__('Final Exam', 'memberpress-course-quizzes'),
            'quiz_id'                     => 302,
            'grade_quiz_url'              => home_url() . '/wp-admin/admin.php?page=grade-quiz&quiz_id=302',
            'quiz_retakes_allowed'        => esc_html__('Yes', 'memberpress-course-quizzes'),
            'quiz_retakes_remaining'      => 0,
        ];
    }

    /**
     * Get the views path for the email
     *
     * @return string
     */
    public function get_views_path()
    {
        return base\VIEWS_PATH . '/emails/';
    }
}
