<?php

namespace memberpress\quizzes\lib;

use memberpress\courses as courses;
use memberpress\quizzes as base;
use memberpress\quizzes\models as models;

class AttemptsTable extends \WP_List_Table
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct([
            'singular' => 'wp_list_mpcs_quiz_attempt',
            'plural'   => 'wp_list_mpcs_quiz_attempts',
            'ajax'     => false,
        ]);
    }

    /**
     * Returns the columns
     *
     * @return array
     */
    public function get_columns()
    {
        return [
            'cb'              => '<input type="checkbox">',
            'col_name'        => esc_html__('Name', 'memberpress-course-quizzes'),
            'col_score'       => esc_html__('Score', 'memberpress-course-quizzes'),
            'col_attempts'    => esc_html__('Attempts', 'memberpress-course-quizzes'),
            'col_finished_at' => esc_html__('Finished', 'memberpress-course-quizzes'),
        ];
    }

    /**
     * Returns the columns that are sortable
     *
     * @return array
     */
    public function get_sortable_columns()
    {
        return [
            'col_name'        => ['name', true],
            'col_score'       => ['score', true],
            'col_attempts'    => ['attempts', true],
            'col_finished_at' => ['finished_at', true],
        ];
    }

    /**
     * Returns the bulk actions
     *
     * @return array
     */
    protected function get_bulk_actions()
    {
        return [
            'delete' => __('Delete permanently', 'memberpress-course-quizzes'),
        ];
    }

    /**
     * Prepares the list of items
     *
     * @return void
     */
    public function prepare_items()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Recommended
        $valid_orderby = ['name', 'score', 'finished_at'];
        $orderby       = isset($_GET['orderby']) && is_string($_GET['orderby']) && in_array($_GET['orderby'], $valid_orderby, true) ? $_GET['orderby'] : 'finished_at';
        $order         = isset($_GET['order']) && is_string($_GET['order']) && strtoupper($_GET['order']) === 'DESC' ? 'DESC' : 'ASC';
        $paged         = isset($_GET['paged']) && is_numeric($_GET['paged']) ? max((int) $_GET['paged'], 1) : 1;
        $search        = isset($_GET['s']) && is_string($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
        $perpage       = courses\lib\Utils::get_per_page_screen_option('mpcs_attempts_per_page');
        $quiz_id       = isset($_GET['id']) ? (int) $_GET['id'] : 0;

        $list_table = models\Attempt::list_table($orderby, $order, $paged, $search, $perpage, $quiz_id);

        $totalitems = $list_table['count'];

        // How many pages do we have in total?
        $totalpages = ceil($totalitems / $perpage);

        // Register the pagination.
        $this->set_pagination_args([
            'total_items' => $totalitems,
            'total_pages' => $totalpages,
            'per_page'    => $perpage,
        ]);

        // Register the columns.
        $columns               = $this->get_columns();
        $hidden                = [];
        $sortable              = $this->get_sortable_columns();
        $this->_column_headers = [$columns, $hidden, $sortable];

        // Fetch the items.
        $this->items = $list_table['results'];
    }

    /**
     * Displays the rows
     *
     * @return void
     */
    public function display_rows()
    {
        $rows                              = $this->items;
        list($columns, $hidden,, $primary) = $this->get_column_info();

        require base\VIEWS_PATH . '/admin/attempts/rows.php';
    }
}
