export default function BrandLogo({width = 200, height = 50, ...props}) {
    return (
        <svg
            width={width}
            height={height}
            version="1.1"
            viewBox="0 0 252 40"
            xmlSpace="preserve"
            xmlns="http://www.w3.org/2000/svg"
            {...props}
        >
            <style type="text/css">
                {`.st0 { fill:#20D1CC }`}
                {`.st1 { fill:#05D0E0 }`}
                {`.st2 { fill:#01A9B2 }`}
                {`.st3 { fill:#0282C9 }`}
                {`.st4 { fill:#016BB1 }`}
                {`.st5 { fill:#06429E }`}
                {`.st6 { fill:#01569A }`}
                {`.st7 { fill:#008C9D }`}
                {`.st8 { fill:#03ABA3 }`}
            </style>

            <path
                className="st0"
                d="m48 17.5c0-4.1 3.3-7.4 7.4-7.4s7.4 3.3 7.4 7.4v17.5c0 2.8 2.3 5 5 5 2.8 0 5-2.3 5-5v-17.5c0.1-9.7-7.7-17.5-17.4-17.5-4.8 0-9.2 2-12.4 5.2 3.1 3.2 5 7.5 5 12.3z"
            />
            <path
                className="st1"
                d="m38 17.5c0-4.8 1.9-9.1 5-12.3-3.2-3.2-7.6-5.2-12.4-5.2-4.9 0-9.3 2-12.4 5.2 3.1 3.1 5 7.5 5 12.2 0-4.1 3.3-7.4 7.4-7.4 4.1 0.1 7.4 3.4 7.4 7.5z"
            />
            <path
                className="st2"
                d="m48 35v-17.5c0-4.8-1.9-9.1-5-12.3-3.1 3.2-5 7.5-5 12.3v17.5c0 1.4 0.6 2.6 1.5 3.6 0.9 0.9 2.2 1.5 3.6 1.5 2.7-0.1 4.9-2.4 4.9-5.1z"
            />
            <path
                className="st3"
                d="M5.7,0c-2.8,0-5,2.3-5,5c0,2.8,2.3,5,5,5c4.1,0,7.4,3.3,7.4,7.4c0-4.8,1.9-9.1,5-12.2C15,2,10.6,0,5.7,0z"
            />
            <path
                className="st4"
                d="m13.1 17.4v17.5c0 2.8 2.3 5 5 5 0.9 0 1.7-0.2 2.4-0.6 1.6-0.9 2.6-2.5 2.6-4.4v-17.4c0-4.8-1.9-9.1-5-12.2-3.1 3.1-5 7.4-5 12.1z"
            />

            <circle className="st5" cx="5.7" cy="5" r="5"/>
            <circle className="st6" cx="18.1" cy="35" r="5"/>
            <circle className="st7" cx="43" cy="35" r="5"/>
            <circle className="st8" cx="67.9" cy="35" r="5"/>

            <path
                className="st5"
                d="m101 15.6c-1.8 0-3.6 0.8-4.5 2.8-0.6-2.1-2.3-2.8-4.3-2.8-1.5 0-3 0.6-3.8 2.1v-0.8c0-0.6-0.5-1.1-1.1-1.1s-1.1 0.5-1.1 1.1v10.9c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c0-2.1 1.4-3.7 3.5-3.7 2.3 0 3.5 1.6 3.5 3.7v6.5c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c0-2.1 1.4-3.7 3.5-3.7 2.3 0 3.4 1.5 3.4 3.7v6.5c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c-0.3-3.5-2.2-5.7-5.7-5.7z"
            />
            <path
                className="st5"
                d="m138.3 15.6c-1.8 0-3.6 0.8-4.5 2.8-0.6-2.1-2.3-2.8-4.3-2.8-1.5 0-3 0.6-3.8 2.1v-0.8c0-0.6-0.5-1.1-1.1-1.1s-1.1 0.5-1.1 1.1v10.9c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c0-2.1 1.4-3.7 3.5-3.7 2.3 0 3.5 1.6 3.5 3.7v6.5c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c0-2.1 1.4-3.7 3.5-3.7 2.3 0 3.4 1.5 3.4 3.7v6.5c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.5c-0.3-3.5-2.1-5.7-5.7-5.7z"
            />
            <path
                className="st5"
                d="m120.5 23.1c0.5 0 1-0.4 1-1 0-4.5-2.8-6.6-6.5-6.6-3.9 0-6.7 2.8-6.7 6.7 0 4.1 2.8 6.7 6.8 6.7 1.9 0 4-0.7 5.3-2 0.2-0.2 0.3-0.4 0.3-0.7 0-0.5-0.4-1-1-1-0.3 0-0.5 0.1-0.7 0.3-0.9 0.9-2.5 1.4-3.9 1.4-2.5 0-4.4-1.5-4.7-3.8h10.1zm-10-1.8c0.4-2.5 2.3-3.8 4.5-3.8 2.5 0 4.2 1.3 4.3 3.8h-8.8z"
            />
            <path
                className="st5"
                d="m173.4 23.1c0.5 0 1-0.4 1-1 0-4.5-2.8-6.6-6.5-6.6-3.9 0-6.7 2.8-6.7 6.7 0 4.1 2.8 6.7 6.8 6.7 1.9 0 4-0.7 5.3-2 0.2-0.2 0.3-0.4 0.3-0.7 0-0.5-0.4-1-1-1-0.3 0-0.5 0.1-0.7 0.3-0.9 0.9-2.5 1.4-3.9 1.4-2.5 0-4.4-1.5-4.7-3.8h10.1zm-10-1.8c0.4-2.5 2.3-3.8 4.5-3.8 2.5 0 4.2 1.3 4.3 3.8h-8.8z"
            />
            <path
                className="st5"
                d="m225.1 23.1c0.5 0 1-0.4 1-1 0-4.5-2.8-6.6-6.5-6.6-3.9 0-6.7 2.8-6.7 6.7 0 4.1 2.8 6.7 6.8 6.7 1.9 0 4-0.7 5.3-2 0.2-0.2 0.3-0.4 0.3-0.7 0-0.5-0.4-1-1-1-0.3 0-0.5 0.1-0.7 0.3-0.9 0.9-2.5 1.4-3.9 1.4-2.5 0-4.4-1.5-4.7-3.8h10.1zm-10-1.8c0.4-2.5 2.3-3.8 4.5-3.8 2.5 0 4.2 1.3 4.3 3.8h-8.8z"
            />
            <path
                className="st5"
                d="m153.3 15.6c-1.8 0-3.9 0.8-4.8 2.5v-6.6c0-0.6-0.5-1.1-1.1-1.1s-1.1 0.5-1.1 1.1v16.3c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-1.4c1 1.7 2.9 2.4 4.8 2.4 3.7 0 6.6-2.4 6.6-6.6 0-4.3-2.9-6.6-6.6-6.6zm-0.1 11.3c-2.5 0-4.5-1.9-4.5-4.7s2-4.7 4.5-4.7 4.5 1.6 4.5 4.7c0 3-2 4.7-4.5 4.7z"
            />
            <path
                className="st5"
                d="m194.4 15.6c-1.9 0-3.8 0.8-4.8 2.4v-1.4c0-0.6-0.5-1.1-1.1-1.1s-1.1 0.5-1.1 1.1v17.1c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1 0-7.4 0-7.4c0.9 1.7 3 2.5 4.8 2.5 3.7 0 6.5-2.3 6.5-6.7 0-4.1-2.8-6.5-6.5-6.5zm-0.1 11.3c-2.5 0-4.5-1.9-4.5-4.7s2-4.7 4.5-4.7 4.5 1.7 4.5 4.6c0 3.2-2 4.8-4.5 4.8z"
            />
            <path
                className="st5"
                d="m185.1 16.1c-0.7-0.3-1.4-0.5-2.3-0.5-1.6 0-3.2 0.6-4 2v-0.9c0-0.6-0.5-1-1-1-0.6 0-1 0.5-1 1v11.2c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.3c0-2.4 1.4-3.8 3.8-3.8 0.6 0 1.1 0.1 1.6 0.3 0.1 0.1 0.3 0.1 0.4 0.1 0.6 0 1-0.5 1-1-0.1-0.6-0.4-0.9-0.7-1.1z"
            />
            <path
                className="st5"
                d="m211.7 16.1c-0.7-0.3-1.4-0.5-2.3-0.5-1.6 0-3.2 0.6-4 2v-0.9c0-0.6-0.5-1-1-1-0.6 0-1 0.5-1 1v11.2c0 0.6 0.5 1.1 1.1 1.1s1.1-0.5 1.1-1.1v-6.3c0-2.4 1.4-3.8 3.8-3.8 0.6 0 1.1 0.1 1.6 0.3 0.1 0.1 0.3 0.1 0.4 0.1 0.6 0 1-0.5 1-1-0.1-0.6-0.4-0.9-0.7-1.1z"
            />
            <path
                className="st5"
                d="m233.2 21.1c-1.6-0.2-3.2-0.5-3.2-1.8 0-1.4 1.4-2.1 3.2-2.1 0.8 0 2.2 0.2 2.9 0.5l0.6 0.3c0.1 0.1 0.3 0.1 0.4 0.1 0.5 0 1-0.4 1-1 0-0.4-0.3-0.8-0.6-0.9-0.2-0.1-0.4-0.2-0.6-0.2-1.2-0.4-2.5-0.6-3.6-0.6-2.5 0-5.3 1.1-5.3 3.9 0 2.7 2.7 3.3 5.2 3.7 2 0.2 3.6 0.6 3.6 2.1-0.1 1.7-2.1 2-3.4 2-1.2 0-2.4-0.3-3.4-0.8-0.1-0.1-0.3-0.1-0.5-0.1-0.6 0-1 0.5-1 1 0 0.4 0.2 0.8 0.6 0.9 1.3 0.6 2.6 0.9 4.2 0.9 2.9 0 5.4-1.2 5.5-3.9 0-3.2-3.2-3.6-5.6-4z"
            />
            <path
                className="st5"
                d="m245.8 21.1c-1.6-0.2-3.2-0.5-3.2-1.8 0-1.4 1.4-2.1 3.2-2.1 0.8 0 2.2 0.2 2.9 0.5l0.6 0.3c0.1 0.1 0.3 0.1 0.4 0.1 0.5 0 1-0.4 1-1 0-0.4-0.3-0.8-0.6-0.9-0.2-0.1-0.4-0.2-0.6-0.2-1.2-0.4-2.5-0.6-3.6-0.6-2.5 0-5.3 1.1-5.3 3.9 0 2.7 2.7 3.3 5.2 3.7 2 0.2 3.6 0.6 3.6 2.1-0.1 1.7-2.1 2-3.4 2-1.2 0-2.4-0.3-3.4-0.8-0.1-0.1-0.3-0.1-0.5-0.1-0.6 0-1 0.5-1 1 0 0.4 0.2 0.8 0.6 0.9 1.3 0.6 2.6 0.9 4.2 0.9 2.9 0 5.4-1.2 5.5-3.9 0-3.2-3.2-3.6-5.6-4z"
            />
        </svg>
    );
}
