<?php

namespace memberpress\quizzes\helpers;

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}

class Quizzes
{
  /**
   * Check if passing score is met
   *
   * @param object $quiz The quiz object.
   * @param object $attempt The attempt object.
   * @return string
   */
    public static function meets_passing_score($quiz, $attempt)
    {
        $unit = $quiz->passing_score_unit;
        switch ($unit) {
            case 'percent':
                $passed = $attempt->score >= $quiz->passing_score;
                break;

            case 'points':
                $passed = $attempt->points_awarded >= $quiz->passing_score;
                break;

            default:
                $passed = false;
                break;
        }

        return $passed;
    }
}
