<?php

namespace memberpress\quizzes\helpers;

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}

use memberpress\courses as courses;
use memberpress\quizzes\models as models;

class App
{
    /**
     * Get permalink base slug for quizzes
     *
     * @return string
     */
    public static function get_quizzes_permalink_base()
    {
        $slug         = models\Quiz::$permalink_slug;
        $options      = get_option('mpcs-options');
        $quizzes_slug = courses\helpers\Options::val($options, 'quizzes-slug');

        if (!empty($quizzes_slug)) {
            $slug = $quizzes_slug;
        }

        return $slug;
    }
}
