<?php

namespace memberpress\quizzes\controllers;

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}

use memberpress\quizzes as base;
use memberpress\quizzes\models as models;
use memberpress\courses as courses;

class Questions extends courses\lib\BaseCtrl
{
    /**
     * Load hooks
     */
    public function load_hooks()
    {
        add_action('init', [$this, 'register_block_types']);
    }

    /**
     * Register block types
     */
    public function register_block_types()
    {
        if (!function_exists('register_block_type')) {
            return;
        }

        foreach (models\Question::get_types() as $type) {
            register_block_type("memberpress-courses/$type-question", [
                'api_version'     => 1,
                'attributes'      => [
                    'questionId' => [
                        'type'    => 'integer',
                        'default' => 0,
                    ],
                ],
                'render_callback' => base\HELPERS_NAMESPACE . '\Questions::render_question',
            ]);
        }
    }
}
