<?php
if ( !class_exists( 'Class_Ced_Onbuy_Manager' ) ) {

	/**
	 * Single product related functionality.
	*
	* Manage all single product related functionality required for listing product on marketplaces.
	*
	* @since      1.0.0
	* @package    Onbuy_Integration_By_CedCommerce
	* @subpackage Onbuy_Integration_By_CedCommerce/admin/onbuy-fr
	* @author     CedCommerce <cedcommerce.com>
	*/
	class Class_Ced_Onbuy_Manager {
		
		/**
		 * The Instace of Class_Ced_Onbuy_Manager.
		 *
		 * @since    1.0.0
		 * @var      $_instance   The Instance of Class_Ced_Onbuy_Manager class.
		 */
		private static $_instance;
		private $plugin_name;
		private $version;
		public $new_id;
		/**
		 * Class_Ced_Onbuy_Manager Instance.
		 *
		 * Ensures only one instance of Class_Ced_Onbuy_Manager is loaded or can be loaded.
		 *
		 * @author CedCommerce <plugins@cedcommerce.com>
		 * @since 1.0.0
		 * @static
		 * @return Class_Ced_Onbuy_Manager instance.
		 */
		public static function get_instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}
		
		public function __construct() {

			$this->load_dependency();
			add_action('ced_onbuy_refresh_token',array($this,'ced_onbuy_refresh_token'));
		}

		public function ced_onbuy_refresh_token( $shop_id = '' ) {

			$file_request = CED_ONBUY_DIRPATH . 'admin/onbuy/lib/class-ced-onbuy-request.php';
			if ( file_exists( $file_request ) ) {
				include_once $file_request;
			}

			global $wpdb;
			// echo '<pre>';
			$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM wp_ced_onbuy_accounts WHERE `shop_id` = %d" , $shop_id ), 'ARRAY_A' );
			
			// print_r($result);

			$consumerKey = isset($result[0]['consumer_key']) ? $result[0]['consumer_key'] : '';
			$secretKey = isset($result[0]['consumer_secret']) ? $result[0]['consumer_secret'] : '';
			$ced_onbuy_request = new Class_Ced_Onbuy_Request($consumerKey , $secretKey );
			$action            = 'auth/request-token';
			$refresh_token     = $ced_onbuy_request->sendCurlPostMethod($action);
			// print_r($refresh_token);
			if (isset($refresh_token['access_token']) && !empty($refresh_token['access_token'])) {
				set_transient('ced_onbuy_refresh_token_' . $shop_id, $refresh_token['access_token'], 14*60);
			}
		}

		public function load_dependency() {
			$file_request = CED_ONBUY_DIRPATH . 'admin/onbuy/lib/class-ced-onbuy-request.php';
			if ( file_exists( $file_request ) ) {
				include_once $file_request;
			}
			$this->ced_onbuy_request = new Class_Ced_Onbuy_Request();

			$file_product = CED_ONBUY_DIRPATH . 'admin/onbuy/partials/class-ced-onbuy-products.php';
			if ( file_exists( $file_product ) ) {
				include_once $file_product;
			}
			$this->ced_onbuy_product = new Class_Ced_Onbuy_Products();
		}

		public function ced_get_validation_account( $consumerKey = '', $secretKey = '', $sellerId = '') {

			$file_request = CED_ONBUY_DIRPATH . 'admin/onbuy/lib/class-ced-onbuy-request.php';
			if ( file_exists( $file_request ) ) {
				include_once $file_request;
			}
			$ced_onbuy_request = new Class_Ced_Onbuy_Request($consumerKey , $secretKey );
			$action            = 'auth/request-token';
			$refresh_token     = $ced_onbuy_request->sendCurlPostMethod($action);
			if (isset($refresh_token['access_token']) && !empty($refresh_token['access_token'])) {
				$action           = 'sellers/' . $sellerId;
				$sellerData       = $ced_onbuy_request->ced_onbuy_get_method($action , '' , $refresh_token['access_token']);
				$action           = 'sellers/deliveries';
				$queries          = 'site_id=2000';
				$sellerDeliveries = $ced_onbuy_request->ced_onbuy_get_method($action , $queries , $refresh_token['access_token']);
				global $wpdb;
				$table_name = 'wp_ced_onbuy_accounts';
				$wpdb->insert(
					$table_name,
					array(
						'account_status'    => 'active',
						'shop_id'           => (int) $sellerId,
						'consumer_key'      => $consumerKey,
						'consumer_secret'   => $secretKey,
						'seller_data'       => json_encode($sellerData['results']),
						'seller_deliveries' => json_encode($sellerDeliveries['results']),
					)
				);
				set_transient('ced_onbuy_refresh_token_' . $sellerId, $refresh_token['access_token'], 14*60);
				return '200';
			} else {
				return 'Unauthorised';	
			}
		}

		public function ced_onbuy_fetch_category_method( $keyword = '', $shop_id = '') {
			do_action('ced_onbuy_refresh_token',$shop_id);
			$action       = 'categories';
			$queries      = 'site_id=2000&limit=100&filter[name]=' . $keyword . '&filter[can_list_in]=1';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$categories   = $this->ced_onbuy_request->ced_onbuy_get_method($action , $queries , $access_token);
			return $categories;
		}

		public function ced_onbuy_fetch_queue_status( $queue_id = '', $shop_id = '') {
			do_action('ced_onbuy_refresh_token',$shop_id);
			$action         = 'queues/' . $queue_id;
			$queries        = 'site_id=2000';
			$access_token   = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$queue_response = $this->ced_onbuy_request->ced_onbuy_get_method($action , $queries , $access_token);
			return $queue_response;
		}

		public function ced_onbuy_get_category_features( $catId = '', $shop_id = '') {
			do_action('ced_onbuy_refresh_token',$shop_id);
			$action       = 'categories/' . $catId . '/features';
			$queries      = 'site_id=2000&limit=10&offset=0';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$categories   = $this->ced_onbuy_request->ced_onbuy_get_method($action , $queries , $access_token);
			return $categories;
		}

		public function ced_onbuy_process_queue( $pro_ids = array(), $shop_id) {
			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}

			
			foreach ($pro_ids as $key => $pro_id) {
				$_product = wc_get_product( $pro_id );

				if(!is_object($_product)) {
					continue;
				}
				$type     = $_product->get_type();
				$queue_id = get_post_meta($pro_id , '_ced_onbuy_queue_id_' . $shop_id , true );
				

				if (isset($queue_id) && !empty($queue_id)) {
					$response = $this->ced_onbuy_fetch_queue_status($queue_id , $shop_id);
					if (isset($response['results']['opc']) && !empty($response['results']['opc'])) {
						if ( 'variable' == $type ) {
							update_post_meta($pro_id , '_ced_onbuy_listing_id_' . $shop_id, $response['results']['opc']);
							if ($response['results']['variant_opcs']) {
								$variant_opcs = $response['results']['variant_opcs'];
								$_product     = wc_get_product($pro_id);
								$variations   = $_product->get_available_variations();
								foreach ($variations as $key => $variation) {
									update_post_meta($variation['variation_id'] , '_ced_onbuy_listing_id_' . $shop_id , $variant_opcs[$key]);
								}
							}
						} else {
							update_post_meta($pro_id , '_ced_onbuy_listing_id_' . $shop_id, $response['results']['opc']);
						}
						delete_post_meta( $pro_id , '_ced_onbuy_queue_id_' . $shop_id );
						delete_post_meta( $pro_id , '_ced_onbuy_error' . $shop_id );
					} elseif( isset($response['results']['status']) && 'failed' == $response['results']['status'] ){
						update_post_meta($pro_id , '_ced_onbuy_error' . $shop_id, $response['results']['error_message']);
					}
				}
			}
		}

		public function ced_prepare_product_html_for_upload( $pro_ids = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_uploading( $pro_ids, $shop_id );
			return $response;
		}
// -------------------------------------------------------------------------------------------
		public function ced_prepare_product_html_for_check_winning( $skus = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $skus ) ) {
				$skus = array( $skus );
			} 
			$response = $this->ced_onbuy_product->ced_check_winning_price_to_onbuy( $skus, $shop_id );
			return $response;
		}
// ------------------------------------------------------------------------------------------
		public function ced_prepare_product_html_for_update( $pro_ids = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_updating( $pro_ids, $shop_id );
			return $response;
		}

		public function ced_prepare_product_html_for_delete( $pro_ids = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_delete( $pro_ids, $shop_id );
			return $response;
		}

		public function ced_prepare_product_html_for_update_stock( $pro_ids = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_update_stock( $pro_ids, $shop_id );
			return $response;
		}

		public function ced_prepare_product_html_for_create_listing( $pro_ids = array(), $shop_id )
		{
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_create_listing( $pro_ids, $shop_id );
			return $response;
		}

		public function ced_prepare_product_html_for_product_sync( $pro_ids = array(), $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			if ( ! is_array( $pro_ids ) ) {
				$pro_ids = array( $pro_ids );
			}
			$response = $this->ced_onbuy_product->ced_onbuy_prepare_data_for_product_sync( $pro_ids, $shop_id );
			return $response;
		}

		public function ced_create_onbuy_order( $shop_id ) {
			do_action('ced_onbuy_refresh_token',$shop_id);

			$response = $this->ced_onbuy_order->ced_create_onbuy_order_post($shop_id );
			return $response;
		}

	}
}
