<?php
/**
 * Header of the extensiom
 *
 * @package  Onbuy_Integration_By_CedCommerce
 * @version  1.0.0
 * @link     https://cedcommerce.com
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
}
$shop_id = isset( $_GET['shop_id'] ) ? sanitize_text_field( wp_unslash( $_GET['shop_id'] ) ) : '';
update_option( 'ced_onbuy_shop_id' , $shop_id );
global $wpdb;
$shop_details = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM wp_ced_onbuy_accounts WHERE `shop_id` = %d ', $shop_id ), 'ARRAY_A' );
$shop_details = $shop_details[0];
if ( isset( $_GET['section'] ) ) {
	$section = sanitize_text_field( wp_unslash( $_GET['section'] ) );
}

?>
<div class="ced_onbuy_loader">
	<img src="<?php echo esc_url( CED_ONBUY_URL . 'admin/images/loading.gif' ); ?>" width="50px" height="50px" class="ced_onbuy_loading_img" >
</div>
<div class="success-admin-notices is-dismissible"></div>
<div class="navigation-wrapper">
	<?php esc_attr( ced_onbuy_cedcommerce_logo() ); ?>
	<ul class="navigation">
		<li>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=accounts-view&shop_id=' . $shop_id ) ); ?>" class="
			<?php
			if ( 'accounts-view' == $section ) {
				echo 'active';
			}
			?>
			"><?php esc_html_e( 'Account Details', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
		<li>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=category-mapping-view&shop_id=' . $shop_id ) ); ?>" class="
			<?php
			if ( 'category-mapping-view' == $section ) {
				echo 'active';
			}
			?>
			"><?php esc_html_e( 'Category Search', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
		<li>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=settings-view&shop_id=' . $shop_id ) ); ?>" class="
				<?php
				if ( 'settings-view' == $section ) {
					echo 'active';
				}
				?>
				"><?php esc_html_e( 'Global Settings', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
		<li>
			<a class="
			<?php
			if ( 'class-onbuylistproducts' == $section ) {
				echo 'active';
			}
			?>
			" href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=class-onbuylistproducts&shop_id=' . $shop_id ) ); ?>"><?php esc_html_e( 'Products', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
		<li>
			<a class="
			<?php
			if ( 'class-onbuyQueueManagement' == $section ) {
				echo 'active';
			}
			?>
			" href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=class-onbuyQueueManagement&shop_id=' . $shop_id ) ); ?>"><?php esc_html_e( 'Queue Management', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
		<li>
			<a class="
			<?php
			if ( 'class-ced-onbuy-list-orders' == $section ) {
				echo 'active';
			}
			?>
			" href="<?php echo esc_url( admin_url( 'admin.php?page=ced_onbuy&section=class-ced-onbuy-list-orders&shop_id=' . $shop_id ) ); ?>"><?php esc_html_e( 'Orders', 'onbuy-integration-by-cedcommerce' ); ?></a>
		</li>
	</ul>
	
	<?php
	// seller name on rightside of setting tab
	/*if ( isset( $shop_details['seller_data'] ) ) {
		
		$seller_data = json_decode($shop_details['seller_data'], 1);	
		?>
		<span class="ced_onbuy_current_account_name"><?php echo '<b>Account Name</b> - <label><b>' . esc_attr( $seller_data['seller_name'] ) . '</b></label>'; ?></span>
		<?php
	}*/
	?>
	<!-- <div class="ced_onbuy_render_meta_keys_wrapper ced_onbuy_global_wrap">

		<label class="basic_heading ced_onbuy_instructions_toggle"><?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?></label>
		<div class="ced_onbuy_instructions_content hide">

			<div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
				<ol>
					<li><b>METAKEYS AND ATTRIBUTES LIST -- </b>  Enter the product name to search metakeys and attributes for mapping.</li>
					<li><b>PRODUCT DATA SETTING -- </b> Fill out the required fields for product data.</li>
					<li><b>ORDER SETTING -- </b> Map the Order Settings.</li>
					<li><b>SCHEDULER SETTING -- </b> Set the Schedulers.</li>
				</ol>
			</div>
		</div>
	</div> -->
</div>

<div class="ced_contact_menu_wrap">
	<input type="checkbox" href="#" class="ced_menu_open" name="menu-open" id="menu-open" />
	<label class="ced_menu_button" for="menu-open">
		<img src="<?php echo esc_url( CED_ONBUY_URL . 'admin/images/icon.png' ); ?>" alt="" title="Click to Chat">
	</label>
	<a href="https://join.skype.com/rzxfe8JrHbao" class="ced_menu_content ced_skype" target="_blank"> <i class="fa fa-skype" aria-hidden="true"></i> </a>
	<a href="https://chat.whatsapp.com/GgYqefNlVeJH0KcXZyOrkp" class="ced_menu_content ced_whatsapp" target="_blank"> <i class="fa fa-whatsapp" aria-hidden="true"></i> </a>
</div>

