<?php
/**
 * Instructions of the extensiom
 *
 * @package  Onbuy_Integration_By_CedCommerce
 * @version  1.0.0
 * @link     https://cedcommerce.com
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

if ( isset( $_GET['section'] ) ) {
	$section = sanitize_text_field( wp_unslash( $_GET['section'] ) );
}

?>
	
<?php
if ( 'accounts-view' == $section ) {
    ?> 
        
    <div class="ced_onbuy_heading">
        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li>After <b>Account Configuration</b>, now click on <b>Category Search</b> to map the categories</li>
                </ul>
            </div>
        </div>
    </div>
<?php
}
?>
  
<?php
if ( 'category-mapping-view' == $section ) {
?> 
        
    <div class="ced_onbuy_heading">

        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li> In <b>Search OnBuy category</b>, the admin has to enter the “KEYWORD” to search the category for that product. <b><a href="javascript:void(0);" id="ced_onbuy_category_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li>In <b>Fetched Category</b>, all the categories saved by the admin will get displayed.</li>
                    <li>After the <b>Category mapping</b>, now click on <b>Global Settings</b> tab to map the product meta keys and attributes of products</li>
                </ul>
            </div>
        </div>
    </div>
<?php
    }
?>

<?php
if ( 'settings-view' == $section ) {
?> 
        
    <div class="ced_onbuy_heading">
        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li>In <b>Global Settings,</b> to map the product meta keys and attributes of products click on <b>METAKEYS AND ATTRIBUTES LIST</b>.  <b><a href="javascript:void(0);" id="ced_onbuy_global_settings_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li>Fill out the required fields for product data. <b><a href="javascript:void(0);" id="ced_onbuy_product_data_settings_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li>After completed the <b>Global Settings</b>, now click on <b>Products</b> tab.</li>
                </ul>
            </div>
        </div>
    </div>
<?php
}
?>
         
<?php
if ( 'class-onbuylistproducts' == $section ) {
    ?> 
        
    <div class="ced_onbuy_heading">
        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li>In <b>Products Settings</b>, the admin will perform the following task. <b><a href="javascript:void(0);" id="ced_onbuy_product_settings_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_upload_product_link" ><?php esc_html_e( 'Upload Products', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_update_product_link" ><?php esc_html_e( 'Update Products', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_update_stock_link" ><?php esc_html_e( 'Update Stock', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_create_listing_link" ><?php esc_html_e( 'Create Listing', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_remove_listing_link" ><?php esc_html_e( 'Remove Listing', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                    <li><b><a href="javascript:void(0);" id="ced_onbuy_mark_not_uploaded_link" ><?php esc_html_e( 'Mark as not Uploaded', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                </ul>
            </div>
        </div>
    </div>
<?php
}
?>
 
<?php
if ( 'class-onbuyQueueManagement' == $section ) {
?>     
    <div class="ced_onbuy_heading">
        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li>In <b>Queue Management </b>section, where the admin can view the OnBuy Queue of the products. <b><a href="javascript:void(0);" id="ced_onbuy_queue_manage_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                </ul>
            </div>
        </div>
    </div>
<?php
}
?>

<?php
if ( 'class-ced-onbuy-list-orders' == $section ) {
    ?> 
        
    <div class="ced_onbuy_heading">
        <?php esc_html_e( get_onbuy_instuctions_html ('INSTRUCTIONS', 'onbuy-integration-by-cedcommerce' )); ?>
        <div class="ced_onbuy_child_element">

            <div class="ced_onbuy_render_meta_key_search_box_wrapper ced_onbuy_global_wrap">
                <ul>
                    <li>In <b>Order Section</b>, where the admin will click the Fetch Orders tab to fetch the orders. <b><a href="javascript:void(0);" id="ced_onbuy_orders_link" ><?php esc_html_e( 'For more details', 'onbuy-integration-by-cedcommerce' ); ?></a></b></li>
                </ul>
            </div>
        </div>
    </div>
<?php
}
?>
	
