<?php
if ( ! defined( 'ABSPATH' ) ) {
	die;
}
$file = CED_ONBUY_DIRPATH . 'admin/partials/header.php';
if ( file_exists( $file ) ) {
	require_once $file;
}

$file = CED_ONBUY_DIRPATH . 'admin/partials/ced-instructions.php';
if ( file_exists( $file ) ) {
	require_once $file;

}

$file_onbuy = CED_ONBUY_DIRPATH . 'admin/onbuy/class-onbuy.php';
if ( file_exists( $file_onbuy ) ) {
	include_once $file_onbuy;
}
$ced_onbuy_instance = new Class_Ced_Onbuy_Manager();

if ( isset( $_POST['save_category_search'] ) ) {
	if ( ! isset( $_POST['save_category_submit'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['save_category_submit'] ) ), 'save_category_search' ) ) {
		return;
	}

	$category_technical_details = $_POST['ced_onbuy_tech_details'];
	update_option('ced_onbuy_technical_details'.$shop_id, $category_technical_details);

	$shop_id                                = isset( $_GET['shop_id'] ) ? sanitize_text_field( $_GET['shop_id'] ) : '';
	$saved_cat                              = get_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array());
	$ced_onbuy_fetched_categories           = get_option('ced_onbuy_fetched_categories', array());
	$ced_onbuy_fetched_categories[$shop_id] = isset($_POST['ced_onbuy_cat']) ? sanitize_text_field( $_POST['ced_onbuy_cat'] ) : '';
	update_option('ced_onbuy_fetched_categories', $ced_onbuy_fetched_categories);
	if (!empty($_POST['ced_onbuy_category_select'])) {
		$categories = isset($_POST['ced_onbuy_category_select']) ?  $_POST['ced_onbuy_category_select']  : '';
		if (isset($categories) && !empty($categories) && is_array($categories)) {
			
			foreach ($categories as $key => $value) {
				$obtain_cat  = explode('$', $value);
				$catId       = $obtain_cat[0];

				$cat_specific_technical_detail = get_option('ced_technical_detail_of_onbuy_categories'.$shop_id, array());

				if(!isset($cat_specific_technical_detail[$catId])){

					$file_request = CED_ONBUY_DIRPATH . 'admin/onbuy/lib/class-ced-onbuy-request.php';
					if ( file_exists( $file_request ) ) {
						include_once $file_request;
					}
					$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
					$ced_onbuy_request = new Class_Ced_Onbuy_Request($consumerKey , $secretKey );
					$action = 'categories'.'/'.$catId.'/technical-details';

					$technical_details_format = $ced_onbuy_request->ced_onbuy_get_method($action , 'site_id=2000' , $access_token);

					$technical_details_format = $technical_details_format['results'];


					//$technical_details_stored = array();
					foreach ($technical_details_format as $key => $value) {
						if(isset($value['options']) && is_array($value['options'])){
							foreach ($value['options'] as $key1 => $value1) {
								$technical_details_stored[] = $value1;
							}
						}
					}

					$cat_specific_technical_detail[$catId] = $technical_details_stored;

					update_option('ced_technical_detail_of_onbuy_categories'.$shop_id, $cat_specific_technical_detail);
				}

				$catName     = $obtain_cat[1];
				$final_cat[] = array('catId' => $catId , 'cat_name' => $catName);
			}
		}
		$merged_cat = array_merge($saved_cat, $final_cat);
		if (isset($final_cat) && !empty($final_cat)) {
			update_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array_values(array_unique($merged_cat, SORT_REGULAR)));
		}
	}
	if (!empty($_POST['ced_woo_categories']) || !empty($_POST['ced_onbuy_cat_features'])) {
		if (!empty($_POST['ced_onbuy_cat_features']) && is_array($_POST['ced_onbuy_cat_features'])) {
			$cat_features                 = isset($_POST['ced_onbuy_cat_features']) ?  $_POST['ced_onbuy_cat_features']  : '';
			$cat_features_saved[$shop_id] = isset($_POST['ced_onbuy_cat_features']) ?  $_POST['ced_onbuy_cat_features'] : '';
			update_option('ced_onbuy_features_to_render' , $cat_features_saved);
			$saved_features = get_option('ced_onbuy_category_features_' . $shop_id , array());
			$saved_features = array();
			foreach ($cat_features as $onbuy_catId => $fea_value) {
				foreach ($fea_value as $key => $value) {
					$selected_features[$onbuy_catId][] = $value;  
				}
			}
			$replace_feature = array_replace($saved_features, $selected_features);
			update_option('ced_onbuy_category_features_' . $shop_id , $replace_feature);
		}
		if (!empty($_POST['ced_woo_categories']) && is_array($_POST['ced_woo_categories'])) {
			$categories                 = isset($_POST['ced_woo_categories']) ?  $_POST['ced_woo_categories']  : '';
			$categories_saved[$shop_id] = isset($_POST['ced_woo_categories']) ?  $_POST['ced_woo_categories']  : '';
			update_option('ced_onbuy_saved_categories' , $categories_saved);
			
			foreach ($categories as $onbuy_catId => $cat_value) {
				foreach ($cat_value as $key => $value) {
					update_term_meta($value , 'ced_onbuy_category_id_' . $shop_id , $onbuy_catId );
				}
			}
		}
	}

}
$shop_id              = isset( $_GET['shop_id'] ) ? sanitize_text_field( $_GET['shop_id'] ) :'';
$woo_store_categories = get_terms( 'product_cat', array( 'hide_empty' => false ) );
$saved_cat            = get_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array());$saved_cat_fea        = get_option('ced_onbuy_features_to_render' , array());

if (isset($saved_cat_fea) && !empty($saved_cat_fea) && is_array($saved_cat_fea)) {
	$saved_cat_fea = isset($saved_cat_fea[$shop_id]) ? $saved_cat_fea[$shop_id] : '';
}
$woo_saved_cat = get_option('ced_onbuy_saved_categories' , array());
if (isset($woo_saved_cat) && !empty($woo_saved_cat) && is_array($woo_saved_cat)) {
	$woo_saved_cat = isset($woo_saved_cat[$shop_id]) ? $woo_saved_cat[$shop_id] : '';
}
$woo_cat = ced_onbuy_get_woo_categories();
if (isset($saved_cat) && !empty($saved_cat)) {
	foreach ($saved_cat as $key => $value) {
		if (!isset($value['features']) && empty($value['features']) && !isset($value['is_features'])) {
			$cat_feature = $ced_onbuy_instance->ced_onbuy_get_category_features($value['catId'] , $shop_id);
			if (isset($cat_feature['results']) && !empty($cat_feature['results'])) {
				$saved_cat[$key]['features'] = $cat_feature['results'];
			}
			$saved_cat[$key]['is_features'] = true;
		}
	}
	update_option('ced_onbuy_selected_cat_to_render_' . $shop_id , $saved_cat);
}
$saved_cat = get_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array());
?>
<form method="post" action="">
	<div class="ced_onbuy_heading">
		<?php wp_nonce_field( 'save_category_search', 'save_category_submit' ); ?>
		<?php echo esc_html_e( get_onbuy_instuctions_html( 'SEARCH ONBUY CATEGORIES' ) ); ?>
		<div class="ced_onbuy_child_element">

			<table class="wp-list-table widefat fixed  ced_onbuy_global_settings_fields_table">
				
				<tbody>
					<tr>
						<th>
							<label><?php esc_html_e( 'Enter Keyword To Search', 'onbuy-integration-by-cedcommerce' ); ?></label>
							<span class="ced_ombuy_tooltip">[ Type in some keywords in order to get the Onbuy category list. For eg : Clothing ]</span>
						</th>
						<td>
							<input type="text" name="" id="ced_onbuy_category_search" class="ced_onbuy_inputs">
						</td>
					</tr>
				</tbody>
			</table>


			<div class="ced_onbuy_fetched_categories">
				<div>

					<table class="wp-list-table widefat fixed  ced_onbuy_global_settings_fields_table">
						<thead>
						</thead>
						<tbody>
							<tr>
								<th class="">
									<label class="basic_heading">
										<?php esc_html_e( 'OnBuy Fetched Categories', 'onbuy-integration-by-cedcommerce' ); ?>
									</label>
									<span class="ced_ombuy_tooltip">[ Select the Onbuy categories in which you want to list your products. ]</span>
								</th>
								<td class="ced-onbuy-select">
									<select class="ced_onbuy_category_select ced_onbuy_select2" name="ced_onbuy_category_select[]" multiple="" >

									</select>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>

		</div>
	</div>
	<div class="ced_onbuy_fetched_category_wrap">
		
			<h2>
				<?php esc_html_e( 'Fetched Categories', 'onbuy-integration-by-cedcommerce' ); ?>
			</h2>
		<?php
		if (isset($saved_cat) && !empty($saved_cat) && is_array($saved_cat)) { 
			?>
			<?php
			foreach ($saved_cat as $key => $value) {
				?>
				<div class="ced_onbuy_render_category_wrapper ced_onbuy_global_wrap ced-onbuy-category-search-list-wrap-parent">
					<button class="delete_profile button" id="<?php echo $value['catId']; ?>" shop_id="<?php echo $shop_id;?>">X</button>
					<label class="basic_heading ced_onbuy_render_categroy_toggle_<?php echo esc_attr( $value['catId'] ); ?>" data-id="<?php echo esc_attr( $value['catId'] ); ?>"><?php echo esc_attr( stripslashes($value['cat_name'] ) ); ?><span class="dashicons dashicons-arrow-down-alt2 ced_onbuy_instruction_icon"></span></label>
					
					<div class="ced_onbuy_render_category_<?php echo esc_attr( $value['catId'] ); ?>  ced_onbuy_category_label ced_onbuy_child_element ced-onbuy-category-search-list-wrap">
						<table class="wp-list-table widefat fixed">
							<tbody>
								<tr>
									<th><label>Map Woocommerce Categories</label></th>
									<td class=""><input type="hidden" name="ced_onbuy_cat[<?php echo esc_attr( $value['catId'] ); ?>]"></td>
									<td class="ced-onbuy-select">
										
										<select class="ced_woo_categories_select ced_onbuy_select2" name="ced_woo_categories[<?php echo esc_attr( $value['catId'] ); ?>][]"" multiple="">
											<?php
											echo "<option value=''>--select woo categories--</option>";
											foreach ($woo_store_categories as $woo_key => $woo_value) {
												if (isset($woo_saved_cat[$value['catId']]) && !empty($woo_saved_cat[$value['catId']])) {
													if ( in_array( $woo_value->term_id, $woo_saved_cat[$value['catId']] ) ) {
														$selected = 'selected';
													} else {
														$selected = '';
													}
												} else {
													$selected = '';
												}
												?>
												<option <?php echo esc_attr( $selected ); ?> value='<?php echo esc_attr( $woo_value->term_id ); ?>'><?php echo esc_attr( $woo_value->name); ?> </option>
												<?php 
											}
											?>
										</select>
									</td>
								</tr>
							</tbody>
							<tbody>
								<tr>
									<th><label>Select OnBuy Category Features</label></th>
									<?php
									if (isset($value['features']) && !empty($value['features'])) {
										foreach ($value['features'] as $feature_key => $feature_value) {
											echo "<td class = 'ced-onbuy-select'><b>" . esc_attr( $feature_value['name'] ) . '</b></br>';
											if (isset($feature_value['options']) && !empty($feature_value['options'])) { 

												?>
												<select class="ced_onbuy_cat_features ced_onbuy_select2" name="ced_onbuy_cat_features[<?php echo esc_attr( $value['catId'] ); ?>][<?php echo esc_attr( $feature_value['name'] ); ?>][]" multiple="">
													<?php		
													foreach ($feature_value['options'] as $option_key => $option_value) {
														if (isset($saved_cat_fea[$value['catId']][$feature_value['name']]) && !empty($saved_cat_fea[$value['catId']][$feature_value['name']])) {
															if ( in_array( $option_value['option_id'], $saved_cat_fea[$value['catId']][$feature_value['name']] ) ) {
																$selected = 'selected';
															} else {
																$selected = '';
															}
														} else {
															$selected = '';
														}
														?>

														<option <?php echo esc_attr( $selected ); ?> value="<?php echo esc_attr( $option_value['option_id'] ); ?>">' <?php echo esc_attr( $option_value['name'] ); ?>'</option>										
														<?php
													}
													echo '</select>';	
												}
												echo '</td>';	
											}
										} else {
											echo '<td>';
											echo '<th>No Features For This Category</th>';
											echo '</td>';
										}
										?>
									</tr>
								</tbody>
								<tbody>
									<tr>
										<th><label>Fill OnBuy Category Technical Details</label></th>
										<?php
										$tech_details = get_option('ced_technical_detail_of_onbuy_categories'.$shop_id, array());

										$technical_details = get_option('ced_onbuy_technical_details'.$shop_id);

										$technical_details_units = get_option('ced_onbuy_technical_details_respective_units'.$shop_id);

										if (isset($tech_details[$value['catId']]) && !empty($tech_details[$value['catId']])) {
											foreach ($tech_details[$value['catId']] as $key => $details) {
												echo "<tr><td class = 'ced-onbuy-select'><b>" . esc_attr( $details['name'] ) . '</b></br>';

												if(isset($technical_details[$value['catId']][$details['detail_id']]) && "" != $technical_details[$value['catId']][$details['detail_id']]){

													$render_value =  $technical_details[$value['catId']][$details['detail_id']]['value'];
												}else{
													$render_value = "";
												}
												?>
												<input type="text" name="ced_onbuy_tech_details[<?php echo $value['catId'];?>][<?php echo $details['detail_id']?>][value]" value = <?php echo $render_value;?>>
												<?php

												if(isset($details['units']) && is_array($details['units'])){
													?>
													<select name="ced_onbuy_tech_details[<?php echo $value['catId'];?>][<?php echo $details['detail_id']?>][unit]">
														<?php

														echo '<option value = "">--Select--</option>';
														foreach ($details['units'] as $key3 => $unit) {
															if($unit == $technical_details[$value['catId']][$details['detail_id']]['unit']){

																echo '<option value = '.$unit.' selected>'.$unit.'</option>';
															}else{
																echo '<option value = '.$unit.'>'.$unit.'</option>';
															}
														}
														echo '</select>';

													}
													echo '</br>';
													echo '</td></tr>';	
												}
											} else {
												echo '<td>';
										// echo '<th>No Features For This Category</th>';
												echo '<th>No Technical details For This Category</th>';
												echo '</td>';
											}
											?>
										</tr>
									</tbody>
								</table>
							</div>

						</div>
							
						<?php
					}
				} else {
					echo "<span class='notice-warning'>No category to display !!</span>";
				}
				?>
			</div>
			<div align="" class="ced-button-wrapper">
				<button id="save_category_search"  name="save_category_search" class="button-primary" ><?php esc_html_e( 'Save', 'onbuy-integration-by-cedcommerce' ); ?></button>
			</div>
		</form>


