<?php
if ( !class_exists( 'Class_Ced_Onbuy_Products' ) ) {

	/**
	 * Single product related functionality.
	*
	* Manage all single product related functionality required for listing product on marketplaces.
	*
	* @since      1.0.0
	* @package    Onbuy_Integration_By_CedCommerce
	* @subpackage Onbuy_Integration_By_CedCommerce/admin/clover-fr
	* @author     CedCommerce <cedcommerce.com>
	*/
	class Class_Ced_Onbuy_Products {
		
		/**
		 * The Instace of Class_Ced_Onbuy_Products.
		 *
		 * @since    1.0.0
		 * @var      $_instance   The Instance of Class_Ced_Onbuy_Products class.
		 */
		private static $_instance;
		private $plugin_name;
		private $version;

		public $new_id;
		/**
		 * Class_Ced_Onbuy_Products Instance.
		 *
		 * Ensures only one instance of Class_Ced_Onbuy_Products is loaded or can be loaded.
		 *
		 * @author CedCommerce <plugins@cedcommerce.com>
		 * @since 1.0.0
		 * @static
		 * @return Class_Ced_Onbuy_Products instance.
		 */
		public static function get_instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}
		
		public function __construct() {

			$this->load_dependency();

		}

		public function load_dependency() {
			$file_request = CED_ONBUY_DIRPATH . 'admin/onbuy/lib/class-ced-onbuy-request.php';
			if ( file_exists( $file_request ) ) {
				include_once $file_request;
			}
			$this->ced_onbuy_request = new Class_Ced_Onbuy_Request();
		}


		/**
		 * Uploading products to clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_doupload( $shop_id ) {
			$response              = $this->ced_upload_to_onbuy( $this->data, $shop_id );
			// print_r($response);
			$this->upload_response = $response;
			return $response;
			
		}


		/**
		 * Syncing products to clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_do_product_sync( $product_code = '', $shop_id ) {
			$response = $this->ced_product_sync_from_onbuy( $product_code, $shop_id );
			return $response;
		}

		/**
		 * Updating products to clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_doupdate( $shop_id, $opc ) {
			$response = $this->ced_update_to_onbuy( $this->data, $shop_id, $opc );
			return $response;
		}

		/**
		 * Deleting products from clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_dodelete( $shop_id ) {
			$response = $this->ced_delete_from_onbuy( $this->data , $shop_id );
			return $response;
		}


		/**
		 * Update Inventory to clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_doUpdateInventory( $shop_id ) {
			$response = $this->update_stock_to_onbuy( $this->data, $shop_id );
			return $response;
		}


		/**
		 * Update stock to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function update_stock_to_onbuy( $parameters, $shop_id ) {
			$action       = 'listings/by-sku';
			$queries      = '';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$response     = $this->ced_onbuy_request->ced_onbuy_put_method($action , $queries , $access_token , $parameters);
			return $response;
		}

		/**
		 * Deleting product from clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_delete_from_onbuy( $parameters, $shop_id ) {
			$action       = 'listings/by-sku';
			$queries      = '';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$response     = $this->ced_onbuy_request->ced_onbuy_delete_method($action , $queries , $access_token , $parameters);
			return $response;
		}

		/**
		 * Uploading product to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_upload_to_onbuy( $parameters, $shop_id ) {
			$action       = 'products';
			$queries      = '';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$response     = $this->ced_onbuy_request->ced_onbuy_post_method($action , $queries , $access_token , $parameters);
			return $response;
		}


		/**
		 * Sync product to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_product_sync_from_onbuy( $parameters, $shop_id ) {
			$action       = 'products';
			$queries      = 'site_id=2000&filter[query]=' . $parameters . '&filter[field]=product_code';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$response     = $this->ced_onbuy_request->ced_onbuy_get_method($action , $queries , $access_token );
			return $response;
		}

		/**
		 * Update product to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_update_to_onbuy( $parameters, $shop_id, $opc ) {
			$action       = 'products';
			$queries      = '';
			$access_token = get_transient('ced_onbuy_refresh_token_' . $shop_id);
			$response     = $this->ced_onbuy_request->ced_onbuy_put_method($action , $queries , $access_token , $parameters, $opc);
			return $response;
		}

		/**
		 * Function for preparing product data to be uploaded
		 *
		 * @since 1.0.0
		 * @param array $pro_ids Product Ids.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_onbuy_prepare_data_for_uploading( $pro_ids = array(), $shop_id ) {
			global $wpdb;
			$table_name = 'wp_ced_onbuy_queue';
			
			foreach ( $pro_ids as $key => $value ) {
	
				$prod_data        = wc_get_product( $value );
				if(!is_object($prod_data)) {
					continue;
				}
				$type             = $prod_data->get_type();
				$already_uploaded = get_post_meta( $value, '_ced_onbuy_listing_id_' . $shop_id, true );
				
				if (empty($already_uploaded)) {
					if ( 'variable' == $type ) {
						$prepared_data[] = $this->ced_get_variable_formatted_data($value , $shop_id);
					} else {
						$prepared_data[] = $this->ced_get_formatted_data( $value, $shop_id );
					}
				} else {
					$response_data[$value] = 'products already uploaded'; 
				}
				
			}
			// print_r($prepared_data);die;
			if (isset($prepared_data) && !empty($prepared_data) && is_array($prepared_data)) {
				$dataToPost['site_id']  = '2000';
				$dataToPost['products'] = $prepared_data;
				$this->data             = json_encode($dataToPost);
				$response               = self::ced_doupload( $shop_id );
				// print_r($response);die;
				
				if (isset($response['results']) && !empty($response['results']) && is_array($response['results'])) {
					foreach ($response['results'] as $key => $value) {
						
						if (isset($value['success']) && $value['success']) {
							$queue_to_insert[$value['uid']] = $value['queue_id'];
							
							update_post_meta($value['uid'] , '_ced_onbuy_queue_id_' . $shop_id , $value['queue_id'] );
							$response_data[$value['uid']] = 'Product Id - ' . $value['uid'] . ' Uploaded Successfully Queued For Process , Please Check The Queue Status';
						} elseif (!$value['success']) {
							$response_data[$value['uid']] = $value['error'];
						}
					}
				} else {	
					$response_data[$shop_id] = $response['error']['message'];
				}
				if (isset($queue_to_insert) && !empty($queue_to_insert)) {
					$wpdb->insert(
						$table_name,
						array(
							'queue_id'    => json_encode($queue_to_insert),
							'shop_id'    => $shop_id,
							'post_time'           => time(),
							'queue_type'      => 'Create Product',
						)
					);
				}
			} else {
				$response_data[$shop_id] = 'There are some issues in data preparation , please consult with support';
			}
			return $response_data;
			
		}

		/**
		 * Function for preparing product data to be updated
		 *
		 * @since 1.0.0
		 * @param array $pro_ids Product Ids.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_onbuy_prepare_data_for_updating( $pro_ids = array(), $shop_id ) {
			global $wpdb;		
			$table_name = 'wp_ced_onbuy_queue';
			foreach ( $pro_ids as $key => $value ) {			
				$prod_data     = wc_get_product( $value );
				if(!is_object($prod_data)) {
					continue;
				}
				$type          = $prod_data->get_type();
				$onbuy_item_id = get_post_meta( $value, '_ced_onbuy_listing_id_' . $shop_id, true );			
				if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
					if ( 'variable' == $type ) {
						$variableData = array();
						$variableData[] = $this->ced_get_variable_formatted_data($value , $shop_id , $onbuy_item_id);					
						$prepared_data = $variableData;
						
						
						// if ( isset( $variableData ) && !empty( $variableData ) && is_array( $variableData ) ) {
						// 	foreach ($variableData as $key => $value) {
						// 		$prepared_data[] = $value;
						// 	}
						// }
					} else {
						$prepared_data[] = $this->ced_get_formatted_data( $value, $shop_id , $onbuy_item_id);
						// print_r($prepared_data);
						// die;
					}
				} else {
					$response_data[$value] = 'Products Not Found On OnBuy'; 
				}
			}

			if(isset($prepared_data[0]['variants'])){
				$childarray = $prepared_data[0]['variants'];
						
				unset($prepared_data[0]['variants']);
				$prepared_data = array_merge($prepared_data,$childarray);
				// print_r($prepared_data);
				// echo "jjjj";
				// die;	
			}
			// print_r($prepared_data);
			// die;
			//foreach ($childarray as $key => $prepared_data) {
				//$prepared_data[0] = $prepared_data;
				//print_r($prepared_data);
				//die;
			
			if (isset($prepared_data) && !empty($prepared_data) && is_array($prepared_data)) {
				$opc = $prepared_data[0]['opc'];
				
				global $wpdb;
				
				$store_products   = get_posts(
					array(
						'numberposts'  => -1,
						'post_type'    => 'product',					
						'meta_query'=>array(
							array(
								'key'     => '_ced_onbuy_listing_id_'.$shop_id,
								'value'   => $opc,
								'compare' => 'EXISTS',
							),
						),
					)
				);
				
				$store_products = $store_products[0]->ID;
				$product_to_check = wc_get_product($store_products);
				if(is_object($product_to_check)) {
					$type = $product_to_check->get_type();
				}
				// $type = $product_to_check->get_type();
				if($type  == "variable"){
					$opc = "";
				}
				// print_r($type);
				// print_r($store_products);
				// die;
				
				$dataToPost['site_id']  = '2000';
				$dataToPost['products'] = $prepared_data;
				
				$this->data             = json_encode($dataToPost);
				$response               = self::ced_doupdate( $shop_id, $opc);
				// print_r($response);
				// die;
					
				
				// if (isset($response) && !empty($response) && is_array($response)) {
				// 	//foreach ($response['products'] as $key => $value) {
				// 	if (isset($response['success']) && !empty($response['success']) && $response['success'] == 1) {
				// 		$queue_to_insert[] = $response['queue_id'];
				// 		$response_data[]   =  'Product Id - Updated Successfully Queued For Process , Please Check The Queue Status';
				// 	} elseif (empty($response['success'])) {	
				// 		$id                 = isset($response['uid']) ? $response['uid'] : $shop_id;
				// 		$response_data[$id] = $response['error']['message'];
				// 	}
				// 	//}
				// }
				if (isset($response['products']) && !empty($response['products']) && is_array($response['products'])) {
					foreach ($response['products'] as $key => $value) {
						if (isset($value['success']) && $value['success']) {
							$queue_to_insert[] = $value['queue_id'];
							$response_data[]   =  'Product Id - Updated Successfully Queued For Process , Please Check The Queue Status';
						} elseif (empty($value['success'])) {	
							$id                 = isset($value['uid']) ? $value['uid'] : $shop_id;
							$response_data[$id] = $value['error']['message'];
						}
					}
				}else{
                    if (isset($response['success']) && !empty($response['success']) && $response['success'] == 1) {
                        $queue_to_insert[] = $response['queue_id'];
                        $response_data[]   =  'Product Id - Updated Successfully Queued For Process , Please Check The Queue Status';
                    } elseif (empty($response['success'])) {
                        $id                 = isset($response['uid']) ? $response['uid'] : $shop_id;
                        $response_data[$id] = $response['error']['message'];
                    }
                }
				if (isset($queue_to_insert) && !empty($queue_to_insert)) {
					$wpdb->insert(
						$table_name,
						array(
							'queue_id'    => json_encode($queue_to_insert),
							'shop_id'    => $shop_id,
							'post_time'           => time(),
							'queue_type'      => 'Update Product',
						)
					);
				}
			}
		//}
			return $response_data;
		}

		/**
		 * Function for preparing product data to be deleted
		 *
		 * @since 1.0.0
		 * @param array $pro_ids Product Ids.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_onbuy_prepare_data_for_delete( $pro_ids = array(), $shop_id ) {

			foreach ( $pro_ids as $key => $value ) {
				$prod_data     = wc_get_product( $value );
				if(!is_object($prod_data)) {
					continue;
				}
				$type          = $prod_data->get_type();
				$onbuy_item_id = get_post_meta( $value, '_ced_onbuy_listing_id_' . $shop_id, true );
				if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
					if ( 'variable' == $type ) {
						$variations = $_product->get_available_variations();
						foreach ($variations as $key => $variation) {
							$skudata[] = get_post_meta($variation['variation_id'] , '_sku' , true);
						}
					} else {
						$skudata[] = get_post_meta($value , '_sku' , true); 
					}
				} else {
					$response_data[$value] = 'Products Not Found On OnBuy'; 
				}
			}
			if (isset($skudata) && !empty($skudata) && is_array($skudata)) {
				$dataToPost['site_id'] = '2000';
				$dataToPost['skus']    = $skudata;
				$this->data            = json_encode($dataToPost);
				$response              = self::ced_dodelete( $shop_id );
				if (isset($response['success']) && !empty($response['success'])) {
					foreach ($response['results'] as $sku => $value) {
						if ( 'ok' == $value['status'] ) {
							$proId                 = wc_get_product_id_by_sku($sku);

							$parent_product_id = wp_get_post_parent_id($proId);
							
							if(isset($parent_product_id) && !empty($parent_product_id)){
								delete_post_meta($parent_product_id,'_ced_onbuy_listing_id_' . $shop_id);
							}

							delete_post_meta($proId , '_ced_onbuy_listing_id_' . $shop_id);
							
							$response_data[$proId] = 'Product Id ' . $proId . ' Deleted successfully';
							
						}
					}
				} else {
					$response_data[$shop_id] = 'Error details - ' . $response['error']['message'];

				}
			}
			return $response_data;
		}

		public function ced_get_formatted_data_create_listing( $pro_ids = '', $shop_id = '', $onbuy_item_id = '' )
		{

			$args = array();
			$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );

			$global = get_option( 'ced_onbuy_global_settings_' . $shop_id, array() );

			$product      = wc_get_product( $pro_ids );
			$price = (float)get_post_meta($pro_ids , 'ced_onbuy_custom_price' , true);
			if(empty($price)){
				$price = (float)get_post_meta($pro_ids , 'ced_onbuy_price' , true);
				if(empty($price) && $price == ""){
					$price       = (float)$this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
					
				}
			}
			// $price = (float)$this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
			if($product->get_type() == 'variation')
			{
				$parent_id = $product->get_parent_id();
				$parentproduct = wc_get_product($parent_id);
				$parent_product_data = $parentproduct->get_data();
			}
			if ( WC()->version > '3.0.0' ) {
				if(is_object($product)) {
					$product_data = $product->get_data();
					$product_type = $product->get_type();
				}
				
				$quantity     = (int) get_post_meta( $pro_ids, '_stock', true );
				$sku = $product_data['sku'];
				
				$stock = (int)$this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_stock');
				if(empty($stock) && $stock == ""){
					$stock = (int)$quantity;
				}
				if ( empty( $price ) ) {
					$price = (float) $product_data['price'];
					if ( 'variable' == $product_type ) {
						$variations = $product->get_available_variations();
						if ( isset( $variations['0']['display_regular_price'] ) ) {
							$price = (float)$variations['0']['display_regular_price'];
						}
					}
				}
			}
			$sku = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_sku');

			// ================================================================
			$ced_update_decreased_price = get_option('ced_update_decreased_price');
			$winning_status = get_post_meta($pro_ids, 'ced_onbuy_winning_price_status_'.$shop_id, true);
		
			$ced_buybox_price_type = get_option('ced_onbuy_buybox_price_type');
			// print_r($ced_buybox_price_type);
			
			if( empty($winning_status) && 'yes' == $ced_update_decreased_price) {
				if (! empty($ced_buybox_price_type)) {
					
					$ced_buybox_price = get_option('ced_onbuy_buybox_price');
					// print_r($ced_buybox_price);

					if (! empty($ced_buybox_price)) {
						if ('Fixed_Decreased' == $ced_buybox_price_type) {
							$price = (float)$price - $ced_buybox_price;
						} elseif ('Percentage_Decreased' == $ced_buybox_price_type) {
							$price = (float)($price - (($ced_buybox_price / 100) * $price));
						}
					}
				}
			}else{
                $conversion_rate          = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_conversion_rate');
                $conversion_rate = $global[$shop_id]['ced_onbuy_conversion_rate'];
                if (! empty($conversion_rate)) {
                    $price = (float)$price * $conversion_rate;
                    if (!empty($rrp)) {
                        $rrp = $rrp * $conversion_rate;
                    }
                }
                $markup_type     = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup_type');
                $markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
                if (! empty($markup_type)) {
                    $markup_value = (float) $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup');
                    $markup_value = (float) $global[$shop_id]['ced_onbuy_product_markup'];
                    if (! empty($markup_value)) {
                        if ('Fixed_Increased' == $markup_type) {
                            $price = (float)$price + $markup_value;
                            if (!empty($rrp)) {
                                $rrp = $rrp + $markup_value;
                            }
                        } elseif ('Fixed_Decreased' == $markup_type) {
                            $price = (float)$price - $markup_value;
                            if (!empty($rrp)) {
                                $rrp = $rrp - $markup_value;
                            }
                        } elseif ('Percentage_Increased' == $markup_type) {
                            $price = (float)($price + (($markup_value / 100) * $price));
                            if (!empty($rrp)) {
                                $rrp = ($rrp + (($markup_value / 100) * $rrp));
                            }
                        } elseif ('Percentage_Decreased' == $markup_type) {
                            $price = (float)($price - (($markup_value / 100) * $price));
                            if (!empty($rrp)) {
                                $rrp = ($rrp - (($markup_value / 100) * $rrp));
                            }
                        }
                    }
                }
            }
			$condition = $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_condition');
			$handling_time = $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_handling_time');
			$args['delivery_weight'] = get_post_meta($pro_ids , '_weight' , true );
			$args['condition'] = $condition;
			$args['opc'] = $onbuy_item_id;
			if($stock < 0){
				$stock = 0;
				$args['stock'] = $stock;
			}else{
				$args['stock'] = $stock;
			}
			// $args['stock'] = $stock;
			$args['price'] = $price;
			$args['handling_time'] = $handling_time;
			$args['sku'] = $sku;
			return $args;
			
		}
		// =====================================================================

		/**
		 * Check winning price of a product to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_check_winning_price_to_onbuy( $parameters, $shop_id ) {
			$action = 'listings/check-winning';
			$queries = '';
			$access_token = get_transient('ced_onbuy_refresh_token_'.$shop_id);
			// $parameters = array(
			// 	'site_id'=>'2000',
			// 	'skus'=>array($parameters)
		
			//   );
			$response = $this->ced_onbuy_request->ced_onbuy_get_method_check_win_price($action , $queries , $access_token, $parameters );

			if (isset($response['results']) && !empty($response['results'])) {
				foreach($response['results'] as $key => $value){

					// print_r($value['lead_price']);
					$prod_id = wc_get_product_id_by_sku($value['sku']);
					if (!empty($prod_id)) {
						update_post_meta($prod_id, 'ced_onbuy_winning_price_data_'.$shop_id, $value);
						update_post_meta($prod_id, 'ced_onbuy_lead_price_'.$shop_id, $value['lead_price']);
						update_post_meta($prod_id, 'ced_onbuy_winning_price_status_'.$shop_id, $value['winning']);
						// print_r($prod_id);
						// var_dump(update_post_meta($prod_id, 'ced_onbuy_winning_price_data_'.$shop_id, $response));
					}
				}
			}
			return $response;
		}
		// ===============================================================================	

		/**
		 * Create Listing of products to clover
		 *
		 * @since 1.0.0
		 * @param int $product_id Product ID.
		 * @param int $shop_id Clover Shop Id.
		 */
		public function ced_doCreateListing( $shop_id ) {
			$response              = $this->ced_create_listing_to_onbuy( $this->data, $shop_id );
			return $response;
		}

		/**
		 * Uploading product to clover
		 *
		 * @since 1.0.0
		 * @param array $parameters Parameters required on Clover.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_create_listing_to_onbuy( $parameters, $shop_id ) {
			$action = 'listings';
			$queries = '';
			$access_token = get_transient('ced_onbuy_refresh_token_'.$shop_id);
			$response = $this->ced_onbuy_request->ced_onbuy_post_method($action , $queries , $access_token , $parameters);
			return $response;
		}

		public function ced_onbuy_prepare_data_for_create_listing(  $pro_ids = array(), $shop_id )
		{
				if(empty($pro_ids))
			return;
		if(isset($pro_ids) && !empty($pro_ids) && is_array($pro_ids))
		{
			// print_r($pro_ids);
			$response_data = array();
            foreach ($pro_ids as $key => $pro_id) {
				$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );
				
				$product      = wc_get_product( $pro_id );
				$type         = $product->get_type();
				
				// print_r($type);die;
				// $parentproduct       = wc_get_product($parent_id);

				if( 'variable' == $type ){
					
					$variations           = $product->get_available_variations();
					// print_r($variations);
					if (isset($variations) && !empty($variations) && is_array($variations)) {
						foreach ($variations as $variation) {
							$variation_id  = $variation['variation_id'];

							$product_code    = get_post_meta($variation_id , 'ced_onbuy_ean' , true);
                            if (empty($product_code) && $product_code == "") {
                                $product_code = $this->ced_fetch_meta_value_of_product($variation_id, '_ced_onbuy_ean');
                            }
							$product_code_len = strlen($product_code);
							// print_r($product_code_len);
							$count = 13;
							$ean_diff = $count - $product_code_len;
							// print_r($ean_diff);

							for( $i = 0; $i< $ean_diff; $i++ ){
								$product_code = '0'.$product_code;
							}
							// print_r($product_code);
							if (isset($product_code) && !empty($product_code)) {
								$response = $this->ced_do_product_sync($product_code, $shop_id);
								// print_r($response);
								// die;
								if (isset($response['results'][0]['opc']) && !empty($response['results'][0]['opc'])) {
									$proIdsForCreate[] = $variation_id;

									$variation = wc_get_product($variation_id);
									$parent_id = $variation->get_parent_id() ;
									// print_r($parent_id);die;

									update_post_meta($parent_id, '_ced_onbuy_listing_id_'.$shop_id, $response['results'][0]['opc']);
									update_post_meta($variation_id, '_ced_onbuy_listing_id_'.$shop_id, $response['results'][0]['opc']);
									
									update_post_meta($variation_id, '_ced_onbuy_listing_id_data_'.$shop_id, $response['results']);
								} else {
									$response_data[$variation_id] = "No listing found on OnBuy.";
								}
							}
						}
					}

				}else{
					// $profile_data = $this->ced_onbuy_get_setting_data( $shop_id );
					// echo $pro_id;
					$product_code    = get_post_meta($pro_id , 'ced_onbuy_ean' , true);
                    if (empty($product_code) && $product_code == "") {
                        $product_code = $this->ced_fetch_meta_value_of_product($pro_id, '_ced_onbuy_ean');
                    }
					$product_code_len = strlen($product_code);
					// print_r($product_code_len);
					$count = 13;
					$ean_diff = $count - $product_code_len;
					// print_r($ean_diff);

					for( $i = 0; $i< $ean_diff; $i++ ){
						$product_code = '0'.$product_code;
					}
					// print_r($product_code);
					// echo 'simple';
					// print_r($product_code.'code');
                    if (isset($product_code) && !empty($product_code)) {
                        $response = $this->ced_do_product_sync($product_code, $shop_id);
                        if (isset($response['results'][0]['opc']) && !empty($response['results'][0]['opc'])) {
                            $proIdsForCreate[] = $pro_id;
                            update_post_meta($pro_id, '_ced_onbuy_listing_id_'.$shop_id, $response['results'][0]['opc']);
                            update_post_meta($pro_id, '_ced_onbuy_listing_id_data_'.$shop_id, $response['results']);
                        } else {
                        	$response_data[$pro_id] = "No Product Found For Creating Listing.";
                        }
                    }
                }
            }
			if(isset($proIdsForCreate) && !empty($proIdsForCreate) && is_array($proIdsForCreate))
			{
				foreach ($proIdsForCreate as $key => $value) {
					$onbuy_item_id = get_post_meta( $value, '_ced_onbuy_listing_id_' . $shop_id, true );
					if(isset($onbuy_item_id) && !empty($onbuy_item_id))
					{
						$prepared_data[] = $this->ced_get_formatted_data_create_listing( $value, $shop_id , $onbuy_item_id);
						// print_r($prepared_data);
						// die;
						
					}
				}
			}
			
			
			if(isset($prepared_data) && !empty($prepared_data) && is_array($prepared_data))
			{
				
				$dataToPost['site_id'] = '2000';
				$dataToPost['listings'] = $prepared_data;
				$this->data = json_encode($dataToPost);
				$response = self::ced_doCreateListing( $shop_id );
				if(isset($response['success']))
				{
					
					foreach ($response['results'] as $key => $value) {
						$response_data[$value['sku']] = 'Product Sku - '.$value['sku'].' Created successfully';
						if(isset($value['error']) && !empty($value['error']))
						{
							
							$response_data[$value['sku']] = "Error details - ".$value['error'];
							
						}
						
					}
					
				}
				else
				{
					$response_data[$shop_id] = "Error details - ".$response['error']['message'];

				}
			}
			return $response_data;
		
		}
		}

		/**
		 * Function for preparing product data to update stock
		 *
		 * @since 1.0.0
		 * @param array $pro_ids Product Ids.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_onbuy_prepare_data_for_update_stock( $pro_ids = array(), $shop_id ) {
			foreach ( $pro_ids as $key => $value ) {
				$prod_data     = wc_get_product( $value );
				if(!is_object($prod_data)) {
					continue;
				}
				$type          = $prod_data->get_type();
				$onbuy_item_id = get_post_meta( $value, '_ced_onbuy_listing_id_' . $shop_id, true );
				if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
					if ( 'variable' == $type ) {
						$variableData = array();
						$variableData = $this->ced_get_variable_formatted_data_inventory($value , $shop_id , $onbuy_item_id);
						if ( isset( $variableData ) && !empty( $variableData ) && is_array( $variableData ) ) {
							foreach ($variableData as $key => $value) {
								$prepared_data[] = $value;
							}
						}
					} else {
						$prepared_data[] = $this->ced_get_formatted_data_inventory( $value, $shop_id , $onbuy_item_id);
					}
				} else {
					$response_data[$value] = 'Products Not Found On OnBuy'; 
				}
			}
			if (isset($prepared_data) && !empty($prepared_data) && is_array($prepared_data)) {
				$dataToPost['site_id']  = '2000';
				$dataToPost['listings'] = $prepared_data;
				$this->data             = json_encode($dataToPost);
				$response               = self::ced_doUpdateInventory( $shop_id );
				if (isset($response['success'])) {
					foreach ($response['results'] as $key => $value) {
						if (isset($value['error']) && !empty($value['error'])) {
							$response_data[$value['sku']] = 'Error details - ' . $value['error'];
						}
					}
					$response_data[$shop_id] = 'Product Sku - ' . $value['sku'] . ' Updated successfully';
				} else {
					$response_data[$shop_id] = 'Error details - ' . $response['error']['message'];

				}
			}
			return $response_data;
		}

		/**
		 * Function for preparing product data to synced product
		 *
		 * @since 1.0.0
		 * @param array $pro_ids Product Ids.
		 * @param int   $shop_id Clover Shop Id.
		 */
		public function ced_onbuy_prepare_data_for_product_sync( $pro_ids = array(), $shop_id ) {
			if (empty($pro_ids)) {
				return;
			}
			$attribute_key = get_option('ced_onbuy_product_sync_scheduler_key_' . $shop_id , '' );
			if (!empty($attribute_key)) {
				foreach ($pro_ids as $key => $pro_id) {
					$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );
					$product_code = $this->ced_fetch_meta_value_of_product($pro_id , $attribute_key );
					if (isset($product_code) && !empty($product_code)) {
						$response = $this->ced_do_product_sync($product_code , $shop_id );
						if (isset($response['results']['opc']) && !empty($response['results']['opc'])) {
							update_post_meta($pro_id , '_ced_onbuy_listing_id_' . $shop_id , $response['results']['opc']);
							update_post_meta($pro_id , '_ced_onbuy_listing_id_data_' . $shop_id , $response['results']);
						}
					}
				}
			}
		}

		/**
		 * Function for preparing  product data
		 *
		 * @since 1.0.0
		 * @param int $pro_ids Product Id.
		 * @param int $shop_id Clover Shop Id.
		 * @param int $clover_item_id Clover Product Listing Id.
		 */
		public function ced_get_formatted_data( $pro_ids = '', $shop_id = '', $onbuy_item_id = '' ) {
			$args         = array();
			$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );
			

			$global = get_option( 'ced_onbuy_global_settings_' . $shop_id, array() );//product data setting
			// print_r($global);
			$product      = wc_get_product( $pro_ids );
			// $price        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
			$price = (float)get_post_meta($pro_ids , 'ced_onbuy_custom_price' , true);
			if(empty($price)){
				$price = (float)get_post_meta($pro_ids , 'ced_onbuy_price' , true);
				if(empty($price) && $price == ""){
					$price       = (float)$this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
					
				}
			}
			

			$deliveries = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_deliveries');

			// print_r($deliveries.'deliver');
			// die();

			if($deliveries){
				global $wpdb;
				$result = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM wp_ced_onbuy_accounts'), 'ARRAY_A' );
				$shop_id = get_option('ced_onbuy_shop_id');
				foreach($result as $key => $value){
					if($value['shop_id'] == $shop_id){
						$deliveries_option = json_decode($value['seller_deliveries']);
						//$test = json_decode($deliveries_option[0]);
						// print_r($test);
						// echo "++++";
						// die;
					}
				}
				// print_r($deliveries_option);echo '</br>';
				foreach($deliveries_option as $k => $v){
					if($v->template_name == $deliveries){

						$delivery = $v->seller_delivery_template_id;
					}
				}
				// print_r($delivery);echo '</br>';
				// die;
				//$deliveries = 8731;
			}
			if ($product->get_type() == 'variation') {
				$parent_id           = $product->get_parent_id();
				$parentproduct       = wc_get_product($parent_id);
				$parent_product_data = $parentproduct->get_data();
			}
			if ( WC()->version > '3.0.0' ) {
				if(is_object($product)) {
					$product_data = $product->get_data();
					$product_type = $product->get_type();
				}
				
				$quantity     = (int) get_post_meta( $pro_ids, '_stock', true );
				$sku          = $product_data['sku'];

				// $description = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_description');
				$description = get_post_meta($pro_ids , 'ced_onbuy_description' , true);
				if(empty($description) && $description == ""){
					$description = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_description');
					
					if(empty($description) && $description == ""){
						$description  = $product_data['description'] . ' ' . $product_data['short_description'];
					}
				}
				
				

				// $title        = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_title');
				$title           = get_post_meta($pro_ids , 'ced_onbuy_title' , true);
				if(empty($title) && $title == ""){
					$title        = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_title');
					if(empty($title) && $title == ""){
						$title        = $product_data['name'];
					}
				}

				$stock        = (int)$this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_stock');
				if(empty($stock) && $stock == ""){
					$stock        = (int)$quantity;
				}

				if ( empty( $price ) ) {
					$price = (float) $product_data['price'];
					if ( 'variable' == $product_type ) {
						$variations = $product->get_available_variations();
						if ( isset( $variations['0']['display_regular_price'] ) ) {
							$price = (float)$variations['0']['display_regular_price'];
						}
					}
				}
			}
			$sku = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_sku');
			if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
				$args['opc'] = $onbuy_item_id;
			}
			// $rrp             = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_rrp');
			$rrp           = get_post_meta($pro_ids , 'ced_onbuy_rrp' , true);
			if(empty($rrp) && $rrp == ""){
				$rrp             = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_rrp');
				
			}

			// ================================================================
			$ced_update_decreased_price = get_option('ced_update_decreased_price');
			$winning_status = get_post_meta($pro_ids, 'ced_onbuy_winning_price_status_'.$shop_id, true);
		
			$ced_buybox_price_type = get_option('ced_onbuy_buybox_price_type');
			// print_r($ced_buybox_price_type);
			
			if( empty($winning_status) && 'yes' == $ced_update_decreased_price) {
				if (! empty($ced_buybox_price_type)) {
					
					$ced_buybox_price = get_option('ced_onbuy_buybox_price');
					// print_r($ced_buybox_price);

					if (! empty($ced_buybox_price)) {
						if ('Fixed_Decreased' == $ced_buybox_price_type) {
							$price = (float)$price - $ced_buybox_price;
						} elseif ('Percentage_Decreased' == $ced_buybox_price_type) {
							$price = (float)($price - (($ced_buybox_price / 100) * $price));
						}
					}
				}
			}else{
				$conversion_rate = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_conversion_rate');
				$conversion_rate = $global[$shop_id]['ced_onbuy_conversion_rate'];

				if (! empty($conversion_rate)) {
					$price = (float)$price * $conversion_rate;
					if (!empty($rrp)) {
						$rrp = $rrp * $conversion_rate;
					}
				}
				$markup_type = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup_type');

				$global = get_option('ced_onbuy_global_settings_' . $shop_id, array());
				$markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
				if (! empty($markup_type)) {
					$markup_value = (float) $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup');
					$markup_value = (float) $global[$shop_id]['ced_onbuy_product_markup'];
					if (! empty($markup_value)) {
						if ('Fixed_Increased' == $markup_type) {
							$price = (float)$price + $markup_value;
							if (!empty($rrp)) {
								$rrp = $rrp + $markup_value;
							}
						} elseif ('Fixed_Decreased' == $markup_type) {
							$price = (float)$price - $markup_value;
							if (!empty($rrp)) {
								$rrp = $rrp - $markup_value;
							}
						} elseif ('Percentage_Increased' == $markup_type) {
							$price = (float)($price + (($markup_value / 100) * $price));
							if (!empty($rrp)) {
								$rrp = ($rrp + (($markup_value / 100) * $rrp));
							}
						} elseif ('Percentage_Decreased' == $markup_type) {
							$price = (float)($price - (($markup_value / 100) * $price));
							if (!empty($rrp)) {
								$rrp = ($rrp - (($markup_value / 100) * $rrp));
							}
						}
					}
				}
			}
			// $condition        = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_condition');
			$condition           = get_post_meta($pro_ids , 'ced_onbuy_condition' , true);
			if(empty($condition) && $condition == ""){
				$condition        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_condition');
				
			}
			$handling_time    = get_post_meta($pro_ids , 'ced_onbuy_handling_time' , true);
			if(empty($handling_time) && $handling_time == ""){
				$handling_time        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_handling_time');
				
			}
			// $product_code     = $this->ced_fetch_meta_value_of_product($pro_ids, '_ced_onbuy_ean');
			$product_code    = get_post_meta($pro_ids , 'ced_onbuy_ean' , true);
			if(empty($product_code) && $product_code == ""){
				$product_code     = $this->ced_fetch_meta_value_of_product($pro_ids, '_ced_onbuy_ean');
				
			}
			$published        = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_published');
			$summary = substr( $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_summary_points'), 0 , 500 );
			if(!empty($summary))
				$summary_points[] = $summary;
			if(empty($summary_points[0]))
			{
				for ($i=0; $i < 5; $i++) { 
					$summary = '';
					$summary = substr( $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_summary_points'.$i), 0 , 500 );
					if(!empty($summary))
						$summary_points[] = $summary;
				}
			}

			// $mpn   = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_mpn');
			$mpn    = get_post_meta($pro_ids , 'ced_onbuy_mpn' , true);
			if(empty($mpn) && $mpn == ""){
				$mpn   = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_mpn');
				
			}
			// $brand = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_brand');
			$brand    = get_post_meta($pro_ids , 'ced_onbuy_brand' , true);
			if(empty($brand) && $brand == ""){
				$brand = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_brand');
				
			}

			$image_url            = wp_get_attachment_image_src( get_post_thumbnail_id( $pro_ids ), 'full' );
			$attachment_ids       = 	$product->get_gallery_image_ids();
			$alternate_image_urls = 	array();
			if (count($attachment_ids)) {
				foreach ( $attachment_ids as $attachment_id ) {
					$alternate_image_urls[] = wp_get_attachment_url( $attachment_id );
				}
			}
			$videos     = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_video');
			$deliveries = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_video');
			if ( isset($videos) && '' != $videos ) {
				$args['videos'][0]['label'] = 'youtube';
				$args['videos'][0]['url']   = $videos; 
			}

			// // primary category.
			// //-----------------------------------------------------------------------------------------
			// $taxonomy = 'product_cat'; 
			// $primary_cat_id = get_post_meta($pro_ids,'_yoast_wpseo_primary_' . $taxonomy, true);

			// //-----------------------------------------------------------------------------------------
			
			// $custom_cat = false;
			// if(!empty($primary_cat_id)){
			// 	$category = get_term_meta($primary_cat_id , 'ced_onbuy_category_id_' . $shop_id , true);
			// 	if(!empty($category)) {
			// 		$custom_cat = true;
			// 	}
			// }
			// if(!$custom_cat) {

			// 	foreach ($product_data['category_ids'] as $key => $value) {
				
			// 		$category = get_term_meta($value , 'ced_onbuy_category_id_' . $shop_id , true);
			// 		if (!empty($category)) {
			// 			break;
			// 		}
				
			// 	}

			// }
			foreach ($product_data['category_ids'] as $key => $value) {
				$category = get_term_meta($value , 'ced_onbuy_category_id_' . $shop_id , true);
				if (!empty($category)) {
					break;
				}
			}
			$saved_cat = get_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array());
			$features_array = get_option('ced_onbuy_category_features_' . $shop_id , true );
			// echo '<pre>';
			// print_r($saved_cat);
			$features       = array();
			if (isset($features_array[$category]) && !empty($features_array[$category]) && is_array($features_array[$category])) {
				foreach ($saved_cat as $cat_key => $cat_value) {
					if ($cat_value['catId'] == $category) {
						foreach ($cat_value['features'] as $feature_key => $feature_value) {
							// $feature_name = strtolower($feature_value['name']);
							foreach ($feature_value['options'] as $option_key => $option_value) {
								// $option_name = strtolower($option_value['name']);
								foreach ($features_array[$category] as $key => $value) {
									foreach ($value as $vkey => $vvalue) {
										
										if($option_value['option_id'] == $vvalue){
											$features[] = array('option_id' => $option_value['option_id'], 'name' => $option_value['name']);
										}	
									}
								}
							}
						}
					}
				}
			}
			// $features_array = get_option('ced_onbuy_category_features_' . $shop_id , true );
			// $features       = array();
			// if (isset($features_array[$category]) && !empty($features_array[$category]) && is_array($features_array[$category])) {
			// 	foreach ($features_array[$category] as $key => $value) {
			// 		foreach ($value as $vkey => $vvalue) {
			// 			$features[] = array('option_id' => $vvalue); 
			// 		}
			// 	}
			// }
			$args['category_id']                   = $category;

			$fetch_details = get_option('ced_technical_detail_of_onbuy_categories'.$shop_id, array());
			$technical_details    = get_option('ced_onbuy_technical_details'.$shop_id); 

			if(isset($category) && !empty($category)){
				if (isset($fetch_details[$category]) && !empty($fetch_details[$category])) {
					if (isset($technical_details) && !empty($technical_details) && is_array($technical_details)) {
						
						foreach ($technical_details as $cat_id => $value) {	
							foreach ($value as $id => $id_value) {
								foreach ($fetch_details[$category] as $key => $details) {
									if( $category == $cat_id ){
									
										if($details['detail_id'] == $id && 'Material' == $details['name']){
											
											$value[$id]['detail_id'] = $details['detail_id'];
											$args['technical_details'] = $value;	
										}
										if($details['detail_id'] == $id && 'Colour' == $details['name']){
											
											$value[$id]['detail_id'] = $details['detail_id'];
											$args['technical_details'] = $value;	
										}
										if($details['detail_id'] == $id && 'Weight' == $details['name']){
											
											$product_weight = get_post_meta($pro_ids, '_weight', true);
											if(!empty($product_weight)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_weight;
												$value[$id]['unit'] = 'kg';
												$args['technical_details'] = $value;
											}
											else{
												$value[$id]['detail_id'] = $details['detail_id'];
												$args['technical_details'] = $value;
											}
										}
										if($details['detail_id'] == $id && 'Height' == $details['name']){

											$product_height = get_post_meta($pro_ids, '_height', true);
											if(!empty($product_height)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_height;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$value[$id]['detail_id'] = $details['detail_id'];
												$args['technical_details'] = $value;
											}
										}
										if($details['detail_id'] == $id && 'Length' == $details['name']){

											$product_length = get_post_meta($pro_ids, '_length', true);	
											if(!empty($product_length)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_length;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$value[$id]['detail_id'] = $details['detail_id'];
												$args['technical_details'] = $value;
											}
										}

										if($details['detail_id'] == $id && 'Width' == $details['name']){
											
											$product_width = get_post_meta($pro_ids, '_width', true);
											if(!empty($product_width)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_width;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$value[$id]['detail_id'] = $details['detail_id'];
												$args['technical_details'] = $value;
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
			if(empty($args['technical_details'])){
				$args['technical_details'] = '';
			} else {
				$args['technical_details'] = array_values($args['technical_details']);
			}
			$condition                             = !empty($condition) ? $condition : 'new';
			$args['uid']                           = $pro_ids;
			if($stock < 0){
				$stock = 0;
				$args['listings'][$condition]['stock'] = $stock;
			}else{
				$args['listings'][$condition]['stock'] = $stock;
			}
			
			$args['listings'][$condition]['price'] = $price;
			if (isset($deliveries) && !empty($deliveries)) {
				$args['listings'][$condition]['delivery_template_id'] = $deliveries;
			} else {
				$args['listings'][$condition]['handling_time'] = $handling_time;
			}
			$args['listings'][$condition]['sku']             = $sku;
			$args['listings'][$condition]['delivery_weight'] = get_post_meta( $pro_ids , '_weight' , true );
			$args['listings'][$condition]['delivery_template_id'] = $delivery;
			$args['product_codes']                           = !empty($product_code) ? array($product_code) : '';
			$args['description']                             = $description;
			$args['product_name']                            = $title;
			$args['published']                               = $published;
			if (isset($rrp) && !empty($rrp)) {
				$args['rrp'] = $rrp;
			}
			$args['summary_points']    = $summary_points;
			$args['mpn']               = $mpn;

			$custom_image_url = get_post_meta($args['uid'], '_custom_onbuy_image', true);	
				

			if(!empty($custom_image_url)) {
				$args['default_image']     = $custom_image_url;
			} else {
				$args['default_image']     = !empty($image_url[0]) ? $image_url[0] : '';
			}
			$args['additional_images'] = !empty($alternate_image_urls) ? $alternate_image_urls : '';
			$args['brand_name']        = $brand;
			$args['features']          = $features; 
			// print_r($args);
			// die();
			return $args;
			
		}

		public function ced_get_formatted_data_inventory( $pro_ids = '', $shop_id = '', $onbuy_item_id = '' ) {
			$args         = array();
			$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );

			$global = get_option( 'ced_onbuy_global_settings_' . $shop_id, array() );

			$product      = wc_get_product( $pro_ids );
			$price = (float)get_post_meta($pro_ids , 'ced_onbuy_custom_price' , true);
			if(empty($price)){
				$price = (float)get_post_meta($pro_ids , 'ced_onbuy_price' , true);
				if(empty($price) && $price == ""){
					$price       = (float)$this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
					
				}
			}
			// $price        = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_price');
		
			// ============================================================
			// $price        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
			if ($product->get_type() == 'variation') {
				$parent_id           = $product->get_parent_id();
				$parentproduct       = wc_get_product($parent_id);
				$parent_product_data = $parentproduct->get_data();
			}
			if (WC()->version > '3.0.0') {
				if(is_object($product)) {
					$product_data = $product->get_data();
					$product_type = $product->get_type();
				}
				
				$quantity     = (int) get_post_meta($pro_ids, '_stock', true);
				$sku          = $product_data['sku'];
				
				$stock        = (int)$this->ced_fetch_meta_value_of_product($pro_ids, '_ced_onbuy_stock');
				if (empty($stock) && $stock == "") {
					$stock        = (int)$quantity;
				}

				if (empty($price)) {
					$price = (float) $product_data['price'];
					if ('variable' == $product_type) {
						$variations = $product->get_available_variations();
						if (isset($variations['0']['display_regular_price'])) {
							$price = (float)$variations['0']['display_regular_price'];
						}
					}
				}
			}
			$sku             = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_sku');
			
			// ================================================================
			$ced_update_decreased_price = get_option('ced_update_decreased_price');
			$winning_status = get_post_meta($pro_ids, 'ced_onbuy_winning_price_status_'.$shop_id, true);
		
			$ced_buybox_price_type = get_option('ced_onbuy_buybox_price_type');
			// print_r($ced_buybox_price_type);
			
			if( empty($winning_status) && 'yes' == $ced_update_decreased_price) {
				if (! empty($ced_buybox_price_type)) {
					
					$ced_buybox_price = get_option('ced_onbuy_buybox_price');
					// print_r($ced_buybox_price);

					if (! empty($ced_buybox_price)) {
						if ('Fixed_Decreased' == $ced_buybox_price_type) {
							$price = (float)$price - $ced_buybox_price;
						} elseif ('Percentage_Decreased' == $ced_buybox_price_type) {
							$price = (float)($price - (($ced_buybox_price / 100) * $price));
						}
					}
				}
			}else{
				$conversion_rate = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_conversion_rate');
				$conversion_rate = $global[$shop_id]['ced_onbuy_conversion_rate'];
				if (! empty($conversion_rate)) {
					$price = (float)$price * $conversion_rate;
					if (!empty($rrp)) {
						$rrp = $rrp * $conversion_rate;
					}
				}
		
				$markup_type = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup_type');
				$markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
				if (! empty($markup_type)) {
					$markup_value = (float) $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_product_markup');
					$markup_value = (float) $global[$shop_id]['ced_onbuy_product_markup'];
					if (! empty($markup_value)) {
						if ('Fixed_Increased' == $markup_type) {
							$price = (float)$price + $markup_value;
							if (!empty($rrp)) {
								$rrp = $rrp + $markup_value;
							}
						} elseif ('Fixed_Decreased' == $markup_type) {
							$price = (float)$price - $markup_value;
							// print_r($price);
							if (!empty($rrp)) {
								$rrp = $rrp - $markup_value;
							}
						} elseif ('Percentage_Increased' == $markup_type) {
							$price = (float)($price + (($markup_value / 100) * $price));
							if (!empty($rrp)) {
								$rrp = ($rrp + (($markup_value / 100) * $rrp));
							}
						} elseif ('Percentage_Decreased' == $markup_type) {
							$price = (float)($price - (($markup_value / 100) * $price));
							if (!empty($rrp)) {
								$rrp = ($rrp - (($markup_value / 100) * $rrp));
							}
						}
					}
				}
			}
			$condition             = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_condition');
			$handling_time         = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_handling_time');
			if ($stock < 0) {
				$stock = 0;
				$args['stock']         = $stock;
			} else {
				$args['stock']         = $stock;
			}
			// $args['stock']         = $stock;
			
			$args['price']         = $price;
			$args['handling_time'] = $handling_time;
			$args['sku']           = $sku;
			
			return $args;
		}

		public function ced_get_variable_formatted_data( $pro_ids = '', $shop_id = '', $onbuy_item_id = '') {
			$proData      = array();
			$args         = array();
			$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );

			$global = get_option( 'ced_onbuy_global_settings_' . $shop_id, array() );

			$product      = wc_get_product( $pro_ids );
			$price        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
			if ($product->get_type() == 'variation') {
				$parent_id           = $product->get_parent_id();
				$parentproduct       = wc_get_product($parent_id);
				$parent_product_data = $parentproduct->get_data();
			}
			if ( WC()->version > '3.0.0' ) {
				if(is_object($product)) {
					$product_data = $product->get_data();
					$product_type = $product->get_type();
				}
				
				$quantity     = (int) get_post_meta( $pro_ids, '_stock', true );
				$sku          = $product_data['sku'];
				$description        = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_description');
				if(empty($description) && $description == ""){
					$description  = $product_data['description'] . ' ' . $product_data['short_description'];
				}
				$title        = $this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_title');
				if(empty($title) && $title == ""){
					$title        = $product_data['name'];
				}

				$stock        = (int)$this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_stock');
				if(empty($stock) && $stock == ""){
					$stock        = (int)$quantity;
				}

				if ( empty( $price ) ) {
					$price = (float) $product_data['price'];
					if ( 'variable' == $product_type ) {
						$variations = $product->get_available_variations();
						if ( isset( $variations['0']['display_regular_price'] ) ) {
							$price = (float)$variations['0']['display_regular_price'];
						}
					}
				}
			}
			if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
				$args['opc'] = $onbuy_item_id;
			}
			$sku             = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_sku');
			$rrp             = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_rrp');
			$conversion_rate = $this->ced_fetch_meta_value_of_product( $pro_ids, 'ced_onbuy_conversion_rate' );
			$conversion_rate = $global[$shop_id]['ced_onbuy_conversion_rate'];
			if ( ! empty( $conversion_rate ) ) {
				$price = (float)$price * $conversion_rate;
				if (!empty($rrp)) {
					$rrp = $rrp * $conversion_rate;
				}
			}
			$markup_type = $this->ced_fetch_meta_value_of_product( $pro_ids, 'ced_onbuy_product_markup_type' );
			$markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
			if ( ! empty( $markup_type ) ) {
				$markup_value = (float) $this->ced_fetch_meta_value_of_product( $pro_ids, 'ced_onbuy_product_markup' );
				$markup_value = $global[$shop_id]['ced_onbuy_product_markup'];
				if ( ! empty( $markup_value ) ) {
					if ( 'Fixed_Increased' == $markup_type ) {
						$price = (float)$price + $markup_value;
						if (!empty($rrp)) {
							$rrp = $rrp + $markup_value;
						}
					} elseif ( 'Fixed_Decreased' == $markup_type ) {
						$price = (float)$price - $markup_value;
						if (!empty($rrp)) {
							$rrp = $rrp - $markup_value;
						}
					} elseif ( 'Percentage_Increased' == $markup_type ) {
						$price = (float)( $price + ( ( $markup_value / 100 ) * $price ) );
						if (!empty($rrp)) {
							$rrp = ( $rrp + ( ( $markup_value / 100 ) * $rrp ) );
						}
					} elseif ( 'Percentage_Decreased' == $markup_type ) {
						$price = (float)( $price - ( ( $markup_value / 100 ) * $price ) );
						if (!empty($rrp)) {
							$rrp = ( $rrp - ( ( $markup_value / 100 ) * $rrp ) );
						}
					}
				}
			}
			$condition        = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_condition');
			$handling_time    = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_handling_time');
			$product_code     = $this->ced_fetch_meta_value_of_product($pro_ids, '_ced_onbuy_ean');
			$published        = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_published');
			$summary = substr( $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_summary_points'), 0 , 500 );
			if(!empty($summary))
				$summary_points = array();
				$summary_points[] = $summary;
			if(empty($summary_points[0]))
			{
				for ($i=0; $i < 5; $i++) { 
					$summary = '';
					$summary = substr( $this->ced_fetch_meta_value_of_product($pro_ids,'ced_onbuy_summary_points'.$i), 0 , 500 );
					if(!empty($summary))
						$summary_points[] = $summary;
				}
			}

			$mpn   = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_mpn');
			$brand = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_brand');

			$image_url            = wp_get_attachment_image_src( get_post_thumbnail_id( $pro_ids ), 'full' );
			$attachment_ids       = 	$product->get_gallery_image_ids();
			$alternate_image_urls = 	array();
			if (count($attachment_ids)) {
				foreach ( $attachment_ids as $attachment_id ) {
					$alternate_image_urls[] = wp_get_attachment_url( $attachment_id );
				}
			}
			$videos = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_video');
			if (isset($videos) && '' != $videos) {
				$args['videos'][0]['label'] = 'youtube';
				$args['videos'][0]['url']   = $videos; 
			}

			$deliveries = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_deliveries');

			if($deliveries){
				global $wpdb;
				$result = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM wp_ced_onbuy_accounts'), 'ARRAY_A' );
				$shop_id = get_option('ced_onbuy_shop_id');
				foreach($result as $key => $value){
					if($value['shop_id'] == $shop_id){
						$deliveries_option = json_decode($value['seller_deliveries']);
						//$test = json_decode($deliveries_option[0]);
						// print_r($test);
						// echo "++++";
						// die;
					}
				}
				// print_r($deliveries_option);echo '</br>';
				foreach($deliveries_option as $k => $v){
					if($v->template_name == $deliveries){

						$delivery = $v->seller_delivery_template_id;
					}
				}
				// print_r($delivery);echo '</br>';
				// die;
				//$deliveries = 8731;
			}

			// // primary category.
			// //-----------------------------------------------------------------------------------------
			// $taxonomy = 'product_cat'; 
			// $primary_cat_id = get_post_meta($pro_ids,'_yoast_wpseo_primary_' . $taxonomy, true);

			// //-----------------------------------------------------------------------------------------
			
			// $custom_cat = false;
			// if(!empty($primary_cat_id)){
			// 	$category = get_term_meta($primary_cat_id , 'ced_onbuy_category_id_' . $shop_id , true);
			// 	if(!empty($category)) {
			// 		$custom_cat = true;
			// 	}
			// }
			// if(!$custom_cat) {

			// 	foreach ($product_data['category_ids'] as $key => $value) {
				
			// 		$category = get_term_meta($value , 'ced_onbuy_category_id_' . $shop_id , true);
			// 		if (!empty($category)) {
			// 			break;
			// 		}
				
			// 	}

			// }

			foreach ($product_data['category_ids'] as $key => $value) {
				$category = get_term_meta($value , 'ced_onbuy_category_id_' . $shop_id , true);
				if (!empty($category)) {
					break;
				}
			}
			$saved_cat = get_option('ced_onbuy_selected_cat_to_render_' . $shop_id , array());
			$features_array = get_option('ced_onbuy_category_features_' . $shop_id , true );
			// echo '<pre>';
			// print_r($saved_cat);
			$features       = array();
			if (isset($features_array[$category]) && !empty($features_array[$category]) && is_array($features_array[$category])) {
				foreach ($saved_cat as $cat_key => $cat_value) {
					if ($cat_value['catId'] == $category) {
						foreach ($cat_value['features'] as $feature_key => $feature_value) {
							// $feature_name = strtolower($feature_value['name']);
							foreach ($feature_value['options'] as $option_key => $option_value) {
								// $option_name = strtolower($option_value['name']);
								foreach ($features_array[$category] as $key => $value) {
									foreach ($value as $vkey => $vvalue) {
										
										if($option_value['option_id'] == $vvalue){
											$features[] = array('option_id' => $option_value['option_id'], 'name' => $option_value['name']);
										}	
									}
								}
							}
						}
					}
				}
			}
			// if (isset($features_array[$category]) && !empty($features_array[$category]) && is_array($features_array[$category])) {
			// 	foreach ($features_array[$category] as $key => $value) {
			// 		foreach ($value as $vkey => $vvalue) {
			// 			$features[] = array('option_id' => $vvalue, 'name' => $vvalue); 
			// 		}
			// 	}
			// }
			$parent_sku                            = $sku;
			$args['category_id']                   = $category;

			$fetch_details = get_option('ced_technical_detail_of_onbuy_categories'.$shop_id, array());
			$technical_details    = get_option('ced_onbuy_technical_details'.$shop_id); 
			
			if(isset($category) && !empty($category)){
				if (isset($fetch_details[$category]) && !empty($fetch_details[$category])) {
					if (isset($technical_details) && !empty($technical_details) && is_array($technical_details)) {
						
						foreach ($technical_details as $cat_id => $value) {	
							foreach ($value as $id => $id_value) {
								foreach ($fetch_details[$category] as $key => $details) {
									if( $category == $cat_id ){
									
										if($details['detail_id'] == $id && 'Material' == $details['name']){
											
											$value[$id]['detail_id'] = $details['detail_id'];
											$args['technical_details'] = $value;	
										}
										if($details['detail_id'] == $id && 'Colour' == $details['name']){
											
											$value[$id]['detail_id'] = $details['detail_id'];
											$args['technical_details'] = $value;	
										}
										if($details['detail_id'] == $id && 'Weight' == $details['name']){
											
											$product_weight = get_post_meta($pro_ids, '_weight', true);
											if(!empty($product_weight)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_weight;
												$value[$id]['unit'] = 'kg';
												$args['technical_details'] = $value;
											}
											else{
												$args['technical_details'] = $value;
											}
										}
										if($details['detail_id'] == $id && 'Height' == $details['name']){

											$product_height = get_post_meta($pro_ids, '_height', true);
											if(!empty($product_height)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_height;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$args['technical_details'] = $value;
											}
										}
										if($details['detail_id'] == $id && 'Length' == $details['name']){

											$product_length = get_post_meta($pro_ids, '_length', true);	
											if(!empty($product_length)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_length;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$args['technical_details'] = $value;
											}
										}

										if($details['detail_id'] == $id && 'Width' == $details['name']){
											
											$product_width = get_post_meta($pro_ids, '_width', true);
											if(!empty($product_width)){
												$value[$id]['detail_id'] = $details['detail_id'];
												$value[$id]['value'] = $product_width;
												$value[$id]['unit'] = 'cm';
												$args['technical_details'] = $value;
											}
											else{
												$args['technical_details'] = $value;
											}
										}
									}
								}
							}
						}
					}
				}
			}
			// $args['category_id']                   = $category;
			// print_r($category);
			if(empty($args['technical_details'])){
				$args['technical_details'] = '';
			}
			$condition                             = !empty($condition) ? $condition : 'new';
			$args['uid']                           = $pro_ids;
			if($stock < 0){
				$stock = 0;
				$args['listings'][$condition]['stock'] = $stock;
			}else{
				$args['listings'][$condition]['stock'] = $stock;
			}
			// $args['listings'][$condition]['stock'] = $stock;
			$args['listings'][$condition]['price'] = $price;
			if ( isset($deliveries) && !empty($deliveries)) {
				$args['listings'][$condition]['delivery_template_id'] = $delivery;
			} else {
				$args['listings'][$condition]['handling_time'] = $handling_time;
			}
			$args['listings'][$condition]['delivery_weight'] = get_post_meta( $pro_ids , '_weight' , true );
			$args['listings'][$condition]['sku']             = $sku;
			$args['product_codes']                           = !empty($product_code) ? array($product_code) : '';
			$args['description']                             = $description;
			$args['product_name']                            = $title;
			$args['published']                               = $published;
			if (isset($rrp) && !empty($rrp)) {
				$args['rrp'] = $rrp;
			}
			$args['summary_points']    = $summary_points;
			$args['mpn']               = $mpn;

			$custom_image_url = get_post_meta($args['uid'], '_custom_onbuy_image', true);	
			
			
			if(!empty($custom_image_url)) {
				$args['default_image']     = $custom_image_url;
			} else {
				$args['default_image']     = !empty($image_url[0]) ? $image_url[0] : '';
			}
			// $args['default_image']     = !empty($image_url[0]) ? $image_url[0] : '';
			$args['additional_images'] = !empty($alternate_image_urls) ? $alternate_image_urls : '';
			$args['brand_name']        = $brand;
			$args['features']          = $features;

			// $proData[] = $args; /* used for update listing*/

			$attr_variations = $product->get_variation_attributes();
			// print_r($attr_variations);
			if (isset($attr_variations) && !empty($attr_variations) && is_array($attr_variations) && empty($onbuy_item_id)) {
				$attr_count = 1;
				foreach ($attr_variations as $key => $value) {
					
					$key = str_replace("attribute_", "", $key);
					$key = wc_attribute_label($key);
					// print_r($key);
					// if($key == 'Color'){
					// 	continue;
					// }
					$args['variant_' . $attr_count]['name'] = $key;
					$attr_count                             = ++$attr_count;

				}
			}
			$variations           = $product->get_available_variations();
			// print_r($variations);
			$final_onbuy_products = array();
			if (isset($variations) && !empty($variations) && is_array($variations)) {
				foreach ($variations as $variation) {
					$variation_id  = $variation['variation_id'];
					$onbuy_item_id = get_post_meta($variation_id , '_ced_onbuy_listing_id_' . $shop_id , true);
					$_product      = wc_get_product($variation_id);
					$var_data      = $_product->get_data();
					$attributes    = $_product->get_attributes();
					
					if (isset($attributes) && is_array($attributes) && empty($onbuy_item_id)) {
						$variant_count = 1;
						foreach ($attributes as $key => $attribute_value) {
							$key = str_replace( 'attribute_', '', $key );
							
							// if ($key == 'pa_color') {
							// 	continue;
							// }else{
								$term = get_term_by('slug', $attribute_value, $key);
								$product_term = $attribute_value;
								if (is_object($term)) {
									$product_term = $term->name;
								}

								$variation_data['variant_' . $variant_count]['name'] = $product_term;
								$variant_count                                       = ++$variant_count;
							// }
						}
					}
					$quantity    = (int)$_product->get_stock_quantity();
					$variant_sku = $_product->get_sku();
					$price = (float)get_post_meta($variation_id , 'ced_onbuy_custom_price' , true);
                    if (empty($price)) {
                        $price = (float)get_post_meta($variation_id, 'ced_onbuy_price', true);
                        if (empty($price) && $price == "") {
                            // $title       = $var_data['name'];
                            $price       = (float)$this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_price');
                        }
                    }
					// $title       = $this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_title');
					$title = get_post_meta($variation_id , 'ced_onbuy_title' , true);
					if(empty($title) && $title == ""){
						// $title       = $var_data['name'];
						$title       = $this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_title');
						if(empty($title) && $title == ""){
							$title       = $var_data['name'];
						}
					}

					$stock       = (int)$this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_stock');
					if(empty($stock) && $stock == ""){
						$stock       = (int)$quantity;
					}

					// $description       = $this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_description');
					$description = get_post_meta($variation_id , 'ced_onbuy_description' , true);
					if(empty($description) && $description == ""){
						// $description = $var_data['description'];
						$description = $this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_description');
						if(empty($description) && $description == ""){
							$description = $var_data['description'];
						}
					}
					if (isset($onbuy_item_id) && !empty($onbuy_item_id)) {
						$variation_data['opc'] = $onbuy_item_id;
					}
					// $rrp             = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_rrp');
					$rrp             = get_post_meta($variation_id , 'ced_onbuy_rrp' , true);
					if(empty($rrp) && $rrp == ""){
						
						$rrp = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_rrp');
						
					}

					// ================================================================
					$ced_update_decreased_price = get_option('ced_update_decreased_price');
					$winning_status = get_post_meta($pro_ids, 'ced_onbuy_winning_price_status_'.$shop_id, true);
				
					$ced_buybox_price_type = get_option('ced_onbuy_buybox_price_type');
					// print_r($ced_buybox_price_type);
					
					if( empty($winning_status) && 'yes' == $ced_update_decreased_price) {
						if (! empty($ced_buybox_price_type)) {
							
							$ced_buybox_price = get_option('ced_onbuy_buybox_price');
							// print_r($ced_buybox_price);

							if (! empty($ced_buybox_price)) {
								if ('Fixed_Decreased' == $ced_buybox_price_type) {
									$price = (float)$price - $ced_buybox_price;
								} elseif ('Percentage_Decreased' == $ced_buybox_price_type) {
									$price = (float)($price - (($ced_buybox_price / 100) * $price));
								}
							}
						}
					}else{
						$conversion_rate = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_conversion_rate');
						if (! empty($conversion_rate)) {
							$price = (float)$price * $conversion_rate;
							if (!empty($rrp)) {
								$rrp = $rrp * $conversion_rate;
							}
						}
						$markup_type = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_product_markup_type');
						$markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
						if (! empty($markup_type)) {
							$markup_value = (float) $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_product_markup');
							$markup_value = $global[$shop_id]['ced_onbuy_product_markup'];
							if (! empty($markup_value)) {
								if ('Fixed_Increased' == $markup_type) {
									$price = (float)$price + $markup_value;
									if (!empty($rrp)) {
										$rrp = $rrp + $markup_value;
									}
								} elseif ('Fixed_Decreased' == $markup_type) {
									$price = (float)$price - $markup_value;
									if (!empty($rrp)) {
										$rrp = $rrp - $markup_value;
									}
								} elseif ('Percentage_Increased' == $markup_type) {
									$price = (float)($price + (($markup_value / 100) * $price));
									if (!empty($rrp)) {
										$rrp = ($rrp + (($markup_value / 100) * $rrp));
									}
								} elseif ('Percentage_Decreased' == $markup_type) {
									$price = (float)($price - (($markup_value / 100) * $price));
									if (!empty($rrp)) {
										$rrp = ($rrp - (($markup_value / 100) * $rrp));
									}
								}
							}
						}
					}
					// $condition        = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_condition');
					$condition = get_post_meta($variation_id , 'ced_onbuy_condition' , true);
					if(empty($condition) && $condition == ""){
						
						$condition = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_condition');
						
					}
					// $handling_time    = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_handling_time');
					$handling_time    = get_post_meta($variation_id , 'ced_onbuy_handling_time' , true);
					if(empty($handling_time) && $handling_time == ""){
						
						$handling_time = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_handling_time');
						
					}

					// $product_code     = $this->ced_fetch_meta_value_of_product($variation_id, '_ced_onbuy_ean');
					$product_code     = get_post_meta($variation_id , 'ced_onbuy_ean' , true);
					if(empty($product_code) && $product_code == ""){
						
						$product_code = $this->ced_fetch_meta_value_of_product($variation_id , '_ced_onbuy_ean');
						
					}
					$published        = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_published');

					$summary_points = array();
					for ($i=0; $i < 5; $i++) { 
						$summary = '';
						$summary = substr( $this->ced_fetch_meta_value_of_product($variation_id,'ced_onbuy_summary_points'.$i), 0 , 500 );
						if(!empty($summary))
							$summary_points[] = $summary;
					}
					
					if(empty($summary_points[0])){
						$summary = substr( $this->ced_fetch_meta_value_of_product($variation_id,'ced_onbuy_summary_points'), 0 , 500 );
						$summary_points[] = $summary;

					}
					// if(empty($summary_points[0]))
					// {
					// 	for ($i=0; $i < 5; $i++) { 
					// 		$summary = '';
					// 		$summary = substr( $this->ced_fetch_meta_value_of_product($variation_id,'ced_onbuy_summary_points'.$i), 0 , 500 );
					// 		if(!empty($summary))
					// 			$summary_points[] = $summary;
					// 	}
					// }
					

					// $mpn   = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_mpn');
					$mpn    = get_post_meta($variation_id , 'ced_onbuy_mpn' , true);
					if(empty($mpn) && $mpn == ""){
						
						$mpn = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_mpn');
						
					}

					// $brand = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_brand');
					$brand  = get_post_meta($variation_id , 'ced_onbuy_brand' , true);
					if(empty($brand) && $brand == ""){
						
						$brand = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_brand');
						
					}

					$image_url            = !empty(wp_get_attachment_image_src( get_post_thumbnail_id( $variation_id ), 'full' )) ? wp_get_attachment_image_src( get_post_thumbnail_id( $variation_id ), 'full' ) : wp_get_attachment_image_src( get_post_thumbnail_id( $pro_ids ), 'full' ) ;
					$attachment_ids       = 	$product->get_gallery_image_ids();
					$alternate_image_urls = 	array();
					if (count($attachment_ids)) {
						foreach ( $attachment_ids as $attachment_id ) {
							$alternate_image_urls[] = wp_get_attachment_url( $attachment_id );
						}
					}
					$videos = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_video');
					if ( isset($videos) && '' != $videos ) {
						
						$variation_data['videos'][0]['label'] = 'youtube';
						$variation_data['videos'][0]['url']   = $videos; 
					}

					$deliveries = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_deliveries');

					if($deliveries){
						global $wpdb;
						$result = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM wp_ced_onbuy_accounts'), 'ARRAY_A' );
						$shop_id = get_option('ced_onbuy_shop_id');
						foreach($result as $key => $value){
							if($value['shop_id'] == $shop_id){
								$deliveries_option = json_decode($value['seller_deliveries']);
								//$test = json_decode($deliveries_option[0]);
								// print_r($test);
								// echo "++++";
								// die;
							}
						}
						// print_r($deliveries_option);echo '</br>';
						foreach($deliveries_option as $k => $v){
							if($v->template_name == $deliveries){

								$delivery = $v->seller_delivery_template_id;
							}
						}
						// print_r($delivery);echo '</br>';
						// die;
						//$deliveries = 8731;
					}

					$condition                                       = !empty($condition) ? $condition : 'new';
					$variation_data['uid']                           = $variation_id;
					if($stock < 0){
						$stock = 0;
						$variation_data['listings'][$condition]['stock'] = $stock;
					}else{
						$variation_data['listings'][$condition]['stock'] = $stock;
					}
					// $variation_data['listings'][$condition]['stock'] = $stock;
					$variation_data['listings'][$condition]['price'] = $price;
					if (isset($deliveries) && !empty($deliveries)) {
						$variation_data['listings'][$condition]['delivery_template_id'] = $delivery;
					} else {
						$variation_data['listings'][$condition]['handling_time'] = $handling_time;
					}
					$variation_data['listings'][$condition]['group_sku'] = $parent_sku;
					$sku = !empty($variant_sku) ? $variant_sku : $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_sku');
					$variation_data['listings'][$condition]['delivery_weight'] = get_post_meta( $variation_id , '_weight' , true );
					$variation_data['listings'][$condition]['sku']             = $variant_sku;
					$variation_data['product_codes']                           = !empty($product_code) ? array($product_code) : '';
					$variation_data['description']                             = $description;
					$variation_data['product_name']                            = $title;
					$variation_data['published']                               = $published;
					if (isset($rrp) && !empty($rrp)) {
						$variation_data['rrp'] = $rrp;
					}

					$variation_data['summary_points']    = $summary_points;
					$variation_data['default_image']     = !empty($image_url[0]) ? $image_url[0] : '';
					$variation_data['additional_images'] = !empty($alternate_image_urls) ? $alternate_image_urls : '';
					$variation_data['brand_name']        = $brand;
					$final_onbuy_products[]              = $variation_data;
					$proData[]                           = $variation_data;
				}
			} 
			$args['variants'] = $final_onbuy_products;
			// print_r($args['variants']);
			// print_r($args);
			// die();
			if (!empty($onbuy_item_id)) {
				return $proData;
			}
			// print_r($args);
			// die();
			return $args;
		}

		public function ced_get_variable_formatted_data_inventory( $pro_ids = '', $shop_id = '', $onbuy_item_id = '') {

			$paren_data   = array();
			$args         = array();
			$profile_data = $this->ced_onbuy_get_setting_data( $shop_id );

			$global = get_option( 'ced_onbuy_global_settings_' . $shop_id, array() );

			$product      = wc_get_product( $pro_ids );
			$price        = $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_price');
			if ($product->get_type() == 'variation') {
				$parent_id           = $product->get_parent_id();
				$parentproduct       = wc_get_product($parent_id);
				$parent_product_data = $parentproduct->get_data();
			}
			if ( WC()->version > '3.0.0' ) {
				if(is_object($product)) {
					$product_data = $product->get_data();
					$product_type = $product->get_type();
				}
				
				$quantity     = (int) get_post_meta( $pro_ids, '_stock', true );
				$sku          = $product_data['sku'];
				
				$stock        = (int)$this->ced_fetch_meta_value_of_product($pro_ids , '_ced_onbuy_stock');
				if(empty($stock) && $stock == ""){
					$stock        = (int)$quantity;
				}
				if ( empty( $price ) ) {
					$price = (float) $product_data['price'];
					if ( 'variable' == $product_type ) {
						$variations = $product->get_available_variations();
						if ( isset( $variations['0']['display_regular_price'] ) ) {
							$price = (float)$variations['0']['display_regular_price'];
						}
					}
				}
			}
			$sku             = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($pro_ids , 'ced_onbuy_sku');

			$handling_time = $this->ced_fetch_meta_value_of_product($pro_ids, 'ced_onbuy_handling_time');
			if($stock < 0){
				$stock = 0;
				$paren_data['stock']         = $stock;
			}else{
				$paren_data['stock']         = $stock;
			}
			// $paren_data['stock']         = $stock;
			$paren_data['price']         = $price;
			$paren_data['handling_time'] = $handling_time;
			$paren_data['sku']           = $sku;
			$args[]                      = $paren_data;
			$variations                  = $product->get_available_variations();
			if (isset($variations) && !empty($variations) && is_array($variations)) {
				foreach ($variations as $variation) {
					$variation_id = $variation['variation_id'];

					$_product    = wc_get_product($variation_id);
					$var_data    = $_product->get_data();
					$quantity    = (int)$_product->get_stock_quantity();
					$variant_sku = $_product->get_sku();
					$price = (float)get_post_meta($variation_id , 'ced_onbuy_custom_price' , true);
                    if (empty($price)) {
                        $price = (float)get_post_meta($variation_id, 'ced_onbuy_price', true);
                        if (empty($price) && $price == "") {
                            // $title       = $var_data['name'];
                            $price       = (float)$this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_price');
                        }
                    }
					// $price       = $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_price');

					// ================================================================
					$ced_update_decreased_price = get_option('ced_update_decreased_price');
					$winning_status = get_post_meta($pro_ids, 'ced_onbuy_winning_price_status_'.$shop_id, true);
				
					$ced_buybox_price_type = get_option('ced_onbuy_buybox_price_type');
					// print_r($ced_buybox_price_type);
					
					if( empty($winning_status) && 'yes' == $ced_update_decreased_price) {
						if (! empty($ced_buybox_price_type)) {
							
							$ced_buybox_price = get_option('ced_onbuy_buybox_price');
							// print_r($ced_buybox_price);

							if (! empty($ced_buybox_price)) {
								if ('Fixed_Decreased' == $ced_buybox_price_type) {
									$price = (float)$price - $ced_buybox_price;
								} elseif ('Percentage_Decreased' == $ced_buybox_price_type) {
									$price = (float)($price - (($ced_buybox_price / 100) * $price));
								}
							}
						}
					}else{
						$conversion_rate = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_conversion_rate');
						$conversion_rate = $global[$shop_id]['ced_onbuy_conversion_rate'];
						if (! empty($conversion_rate)) {
							$price = (float)$price * $conversion_rate;
							if (!empty($rrp)) {
								$rrp = $rrp * $conversion_rate;
							}
						}
						$markup_type = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_product_markup_type');
						$markup_type = $global[$shop_id]['ced_onbuy_product_markup_type'];
						if (! empty($markup_type)) {
							$markup_value = (float) $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_product_markup');
							$markup_value = $global[$shop_id]['ced_onbuy_product_markup'];
							if (! empty($markup_value)) {
								if ('Fixed_Increased' == $markup_type) {
									$price = (float)$price + $markup_value;
									if (!empty($rrp)) {
										$rrp = $rrp + $markup_value;
									}
								} elseif ('Fixed_Decreased' == $markup_type) {
									$price = (float)$price - $markup_value;
									if (!empty($rrp)) {
										$rrp = $rrp - $markup_value;
									}
								} elseif ('Percentage_Increased' == $markup_type) {
									$price = (float)($price + (($markup_value / 100) * $price));
									if (!empty($rrp)) {
										$rrp = ($rrp + (($markup_value / 100) * $rrp));
									}
								} elseif ('Percentage_Decreased' == $markup_type) {
									$price = (float)($price - (($markup_value / 100) * $price));
									if (!empty($rrp)) {
										$rrp = ($rrp - (($markup_value / 100) * $rrp));
									}
								}
							}
						}
					}
					$sku           = !empty($sku) ? $sku : $this->ced_fetch_meta_value_of_product($variation_id , 'ced_onbuy_sku');
					$handling_time = $this->ced_fetch_meta_value_of_product($variation_id, 'ced_onbuy_handling_time');

					$variation_data['stock']         = (int)$quantity;
					$variation_data['price']         = $price;
					$variation_data['handling_time'] = $handling_time;
					$variation_data['sku']           = $variant_sku;

					$args[] = $variation_data;
				}
			}
			// $args['variants'] = $final_onbuy_products;
			// if (!empty($onbuy_item_id)) {
			// 	return $proData;
			// }
			return $args;;
		}

		public function ced_onbuy_get_setting_data( $shop_id = '') {
			if (empty($shop_id)) {
				return 'shop not selected';
			}
			$setting_data = get_option( 'ced_onbuy_global_settings_' . $shop_id, false );
			if (isset($setting_data[$shop_id]) && !empty($setting_data[$shop_id])) {
				$this->profile_data                   = $setting_data[$shop_id]; 
				$this->is_profile_assigned_to_product = true;
			} else {
				$this->is_profile_assigned_to_product = false;
			}
		}

		public function ced_fetch_meta_value_of_product( $pro_ids, $meta_key ) {
			if ( isset( $this->is_profile_assigned_to_product ) && $this->is_profile_assigned_to_product ) {
				$_product = wc_get_product( $pro_ids );
				if ( $_product->get_type() == 'variation' ) {
					$parent_id = $_product->get_parent_id();
				} else {
					$parent_id = '0';
				}

				if ( ! empty( $this->profile_data ) && isset( $this->profile_data[ $meta_key ] ) ) {
					$profile_data      = $this->profile_data[ $meta_key ];
					$temp_profile_data = $profile_data;

					if ( isset( $temp_profile_data['default'] ) && ! empty( $temp_profile_data['default'] ) && ! is_null( $temp_profile_data['default'] ) ) {

						$value = $temp_profile_data['default'];

					} elseif ( isset( $temp_profile_data['metakey'] ) && ! empty( $temp_profile_data['metakey'] ) && 'null' != $temp_profile_data['metakey'] ) {
						
						if ( $temp_profile_data['metakey']) {
							$woo_attribute = $temp_profile_data['metakey'];
							if ( $_product->get_type() == 'variation' ) {
								$var_product = wc_get_product( $parent_id );
								$attributes  = $var_product->get_variation_attributes();
								if ( isset( $attributes[ 'attribute_pa_' . $woo_attribute ] ) && ! empty( $attributes[ 'attribute_pa_' . $woo_attribute ] ) ) {
									$woo_attribute_value = $attributes[ 'attribute_pa_' . $woo_attribute ];
									if ( '0' != $parent_id ) {
										$product_terms = get_the_terms( $parent_id, 'pa_' . $woo_attribute );
									} else {
										$product_terms = get_the_terms( $pro_ids, 'pa_' . $woo_attribute );
									}
								} else {
									$woo_attribute_value = $var_product->get_attribute( 'pa_' . $woo_attribute );
									$woo_attribute_value = explode( ',', $woo_attribute_value );
									$woo_attribute_value = $woo_attribute_value[0];

									if ( '0' != $parent_id ) {
										$product_terms = get_the_terms( $parent_id, 'pa_' . $woo_attribute );
									} else {
										$product_terms = get_the_terms( $pro_ids, 'pa_' . $woo_attribute );
									}
								}
								if ( is_array( $product_terms ) && ! empty( $product_terms ) ) {
									foreach ( $product_terms as $tempkey => $tempvalue ) {
										if ( $tempvalue->slug == $woo_attribute_value ) {
											$woo_attribute_value = $tempvalue->name;
											break;
										}
									}
									if ( isset( $woo_attribute_value ) && ! empty( $woo_attribute_value ) ) {
										$value = $woo_attribute_value;
									} else {
										$value = get_post_meta( $pro_ids, $meta_key, true );
									}
								} else {
									$value = get_post_meta( $pro_ids, $meta_key, true );
								}
							} else {
								$woo_attribute_value = $_product->get_attribute( 'pa_' . $woo_attribute );
								$product_terms       = get_the_terms( $pro_ids, 'pa_' . $woo_attribute );
								if ( is_array( $product_terms ) && ! empty( $product_terms ) ) {
									foreach ( $product_terms as $tempkey => $tempvalue ) {
										if ( $tempvalue->slug == $woo_attribute_value ) {
											$woo_attribute_value = $tempvalue->name;
											break;
										}
									}
									if ( isset( $woo_attribute_value ) && ! empty( $woo_attribute_value ) ) {
										$value = $woo_attribute_value;
									} else {
										$value = get_post_meta( $pro_ids, $meta_key, true );
									}
								} else {
									$value = get_post_meta( $pro_ids, $meta_key, true );
								}
							}
						} 
						if (empty($value)) {
							$value = get_post_meta( $pro_ids, $temp_profile_data['metakey'], true );
							if ( '_thumbnail_id' == $temp_profile_data['metakey'] ) {
								$value = wp_get_attachment_image_url( get_post_meta( $pro_ids, '_thumbnail_id', true ), 'thumbnail' ) ? wp_get_attachment_image_url( get_post_meta( $pro_ids, '_thumbnail_id', true ), 'thumbnail' ) : '';
							}
							if ( ! isset( $value ) || empty( $value ) || is_null( $value ) || '0' == $value || 'null' == $value ) {
								if ( '0' == $parent_id ) {
									$value = get_post_meta( $parent_id, $temp_profile_data['metakey'], true );
									if ( '_thumbnail_id' == $temp_profile_data['metakey'] ) {
										$value = wp_get_attachment_image_url( get_post_meta( $parent_id, '_thumbnail_id', true ), 'thumbnail' ) ? wp_get_attachment_image_url( get_post_meta( $parent_id, '_thumbnail_id', true ), 'thumbnail' ) : '';
									}

									if ( ! isset( $value ) || empty( $value ) || is_null( $value ) ) {
										$value = get_post_meta( $pro_ids, $meta_key, true );
									}
								} else {
									$value = get_post_meta( $pro_ids, $meta_key, true );
								}
							}
						}
					} else {
						$value = get_post_meta( $pro_ids, $meta_key, true );
					}
				} else {
					$value = get_post_meta( $pro_ids, $meta_key, true );
				}
				return $value;
			}
		}

	}
}
