<?php

/**
 * Fired during plugin activation
 *
 * @link       http://www.tychesoftwares.com/
 * @since      1.0.0
 *
 * @package    Bkap_Outlook_Calendar
 * @subpackage Bkap_Outlook_Calendar/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Bkap_Outlook_Calendar
 * @subpackage Bkap_Outlook_Calendar/includes
 * @author     Tyche Softwares <vishal@tychesoftwares.com>
 */
class Bkap_Outlook_Calendar_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		// add outlook event summary & description.
		add_option( 'bkap_outlook_calendar_event_summary', 'SITE_NAME, ORDER_NUMBER' );
		add_option( 'bkap_outlook_calendar_event_description', 'PRODUCT_WITH_QTY,Name: CLIENT,Contact: EMAIL, PHONE' );
		// add GCal event city.
		add_option( 'bkap_outlook_calendar_event_location', 'CITY' );
	}

}
