<?php
/**
 * This function checks if all required option for Outlook Connectivity is saved.
 *
 * @param array $booking_settings Booking Settings.
 *
 * @since 1.0.0
 */
function bkap_outlook_calendar_connected( $booking_settings = array() ) {

	$status = '';
	if ( count( $booking_settings ) > 0 ) {
		if ( isset( $booking_settings['bkap_outlook_calendar'] ) && 'on' === $booking_settings['bkap_outlook_calendar'] ) {
			$client_id     = bkap_outlook_calendar_settings_set( $booking_settings, 'bkap_outlook_calendar_client_id' );
			$client_secret = bkap_outlook_calendar_settings_set( $booking_settings, 'bkap_outlook_calendar_client_secret' );
			$calendar_id   = bkap_outlook_calendar_settings_set( $booking_settings, 'bkap_outlook_calendar_id' );

			if ( '' !== $calendar_id && '' !== $client_id && '' !== $client_secret ) {
				return 'product';
			}
		}
	}

	if ( 'disabled' !== get_option( 'bkap_outlook_calendar_integration', '' ) ) {
		$client_id     = get_option( 'bkap_outlook_calendar_client_key', '' );
		$client_secret = get_option( 'bkap_outlook_calendar_client_secret', '' );
		$calendar_id   = get_option( 'bkap_outlook_calendar_id', '' );

		if ( '' !== $calendar_id && '' !== $client_id && '' !== $client_secret ) {
			return 'global';
		}
	}

	return $status;
}

/**
 * This function check if the key is set in the given array then return value.
 *
 * @param array  $data Array.
 * @param string $key Key.
 *
 * @since 1.0.0
 */
function bkap_outlook_calendar_settings_set( $data, $key ) {

	$value = isset( $data[ $key ] ) && '' !== $data[ $key ] ? $data[ $key ] : '';
	return $value;
}

/**
 * This function inserts the event to Outlook Calendar.
 *
 * @param int   $item_id Item ID.
 * @param int   $product_id Product ID.
 * @param obj   $order Order Object.
 * @param array $event_details Array of Event Data.
 *
 * @since 1.0.0
 */
function bkap_outlook_calendar_common_insert_event( $item_id, $product_id, $order, $event_details ) {

	$booking_settings  = bkap_setting( $product_id );
	$active_connection = bkap_outlook_calendar_connected( $booking_settings );

	if ( '' !== $active_connection ) {

		$product_id       = ( 'product' === $active_connection ) ? $product_id : 0;
		$user_id          = bkap_get_user_id();
		$outlook_calendar = new BKAP_Outlook_Calendar_OAuth( $product_id, $user_id );

		$status = $outlook_calendar->bkap_outlook_insert_event( $event_details, $item_id, $user_id, $product_id, false );

		if ( $status ) {
			// add an order note, mentioning an event has been created for the item.
			$post_title = $event_details['product_name'];
			$order_note = __( "Booking details for $post_title have been exported to the Outlook Calendar", 'bkap-outlook-calendar' );
			$order->add_order_note( $order_note );
		}
	}
}