<?php

/**
 *
 * @link              http://www.tychesoftwares.com/
 * @since             1.0.0
 * @package           Bkap_Outlook_Calendar
 *
 * @wordpress-plugin
 * Plugin Name:       Outlook Calendar Sync
 * Plugin URI:        http://www.tychesoftwares.com/
 * Description:       This addon to Booking & Appoinment Plugin for WooCommerce allows to sync bookings with Outlook.com calendar in real time.
 * Version:           1.0.0
 * Author:            Tyche Softwares
 * Author URI:        http://www.tychesoftwares.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       bkap-outlook-calendar
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'BKAP_OUTLOOK_CALENDAR_VERSION', '1.0.0' );

if ( ! defined( 'BKAPOC_FILE' ) ) {
	define( 'BKAPOC_FILE', __FILE__ );
}

/**
 * This is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
 * IMPORTANT: change the name of this constant to something unique to prevent conflicts with other plugins using this system
 */
define( 'EDD_SL_STORE_URL_BKAP_OUTLOOK', 'https://www.tychesoftwares.com/' );

/**
 * The name of your product. This is the title of your product in EDD and should match the download title in EDD exactly
 * IMPORTANT: change the name of this constant to something unique to prevent conflicts with other plugins using this system
 */
define( 'EDD_SL_ITEM_NAME_BKAP_OUTLOOK', 'Outlook Calendar Sync' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-bkap-outlook-calendar-activator.php
 */
function activate_bkap_outlook_calendar() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-bkap-outlook-calendar-activator.php';
	Bkap_Outlook_Calendar_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-bkap-outlook-calendar-deactivator.php
 */
function deactivate_bkap_outlook_calendar() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-bkap-outlook-calendar-deactivator.php';
	Bkap_Outlook_Calendar_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_bkap_outlook_calendar' );
register_deactivation_hook( __FILE__, 'deactivate_bkap_outlook_calendar' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-bkap-outlook-calendar.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_bkap_outlook_calendar() {

	$plugin = new Bkap_Outlook_Calendar();
	$plugin->run();
}
run_bkap_outlook_calendar();
