<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * This file may be updated more in future version of the Boilerplate; however, this is the
 * general skeleton and outline for how the file should work.
 *
 * For more information, see the following discussion:
 * https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate/pull/123#issuecomment-28541913
 *
 * @link       http://www.tychesoftwares.com/
 * @since      1.0.0
 *
 * @package    Bkap_Outlook_Calendar
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

$option_data = array(
	'bkap_outlook_calendar_client_key',
	'bkap_outlook_calendar_client_secret',
	'bkap_outlook_calendar_id',
	'bkap_outlook_event_uids_ids',
);

/**
 * Delete the data for the WordPress Multisite.
 */
if ( is_multisite() ) {

	$sites = get_sites();

	foreach ( $sites as $site_key => $site_value ) {
		$site_ud = $site_value->blog_id;

		foreach ( $option_data as $key => $value ) {
			// Delete the global booking settings.
			delete_blog_option( $site_ud, $value );
		}
	}
} else {
	foreach ( $option_data as $key => $value ) {
		// Delete the global booking settings.
		delete_option( $value );
	}
}
