<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://www.tychesoftwares.com/
 * @since      1.0.0
 *
 * @package    Bkap_Outlook_Calendar
 * @subpackage Bkap_Outlook_Calendar/Settings
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Bkap_Outlook_Calendar
 * @subpackage Bkap_Outlook_Calendar/Settings
 * @author     Tyche Softwares <vishal@tychesoftwares.com>
 */
class Bkap_Outlook_Calendar_Settings {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of this plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * General Settings Section.
	 *
	 * @since    1.0.0
	 */
	public static function bkap_outlook_sync_general_settings_callback() {}

	/**
	 * Outlook Calendar Location Data.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_event_location_callback( $args ) {
		$outlook_calendar_location = get_option( 'bkap_outlook_calendar_event_location' );
		echo '<input type="text" name="bkap_outlook_calendar_event_location" id="bkap_outlook_calendar_event_location" value="' . esc_attr( $outlook_calendar_location ) . '" />';
		$html = '<label for="bkap_outlook_calendar_event_location"> ' . $args[0] . '</label>';
		echo $html;
	}

	/**
	 * Outlook Calendar Summary Data.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_event_summary_callback( $args ) {
		$outlook_summary = get_option( 'bkap_outlook_calendar_event_summary' );
		echo '<input id="bkap_outlook_calendar_event_summary" name="bkap_outlook_calendar_event_summary" value="' . esc_attr( $outlook_summary ) . '" size="90" type="text"/>';
	}

	/**
	 * Outlook Calendar Description Data.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_event_description_callback( $args ) {
		$outlook_description = get_option( 'bkap_outlook_calendar_event_description' );
		echo '<textarea id="bkap_outlook_calendar_event_description" name="bkap_outlook_calendar_event_description" cols="90" rows="4" name="gcal_description">' . esc_textarea( $outlook_description ) . '</textarea>';
		$html = '<label for="bkap_outlook_calendar_event_description"> ' . $args[0] . '</label>';
		echo $html;
	}

	/**
	 * Outlook Calendar Section.
	 *
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_settings_callback() {}

	/**
	 * Integration Mode.
	 *
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_integration_callback() {
		$sync_oauth   = '';
		$sync_disable = '';
		$mode         = get_option( 'bkap_outlook_calendar_integration', '' );

		switch ( $mode ) {
			case 'oauth':
				$sync_oauth = 'checked';
				break;
			default:
				$sync_disable = 'checked';
				break;
		}

		echo '<input type="radio" name="bkap_outlook_calendar_integration" id="bkap_outlook_calendar_integration" value="oauth" ' . $sync_oauth . '/>' . __( 'OAuth Sync', 'bkap-outlook-calendar' ) . '&nbsp;&nbsp;
			<input type="radio" name="bkap_outlook_calendar_integration" id="bkap_outlook_calendar_integration" value="disabled" ' . $sync_disable . '/>' . __( 'Disabled', 'bkap-outlook-calendar' );
		echo '<label for="bkap_outlook_calendar_integration"></label>';
	}

	/**
	 * Instructions.
	 *
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_instructions_callback() {

		?>
		<div id="bkap_outlook_calendar_steps"><?php _e( 'To find your <b>Client ID</b> and <b>Client Secret</b> do the following:', 'bkap-outlook-calendar' ); // phpcs:ignore ?>
			<div class="description outlook-calendar-instructions">
				<ul style="list-style-type:decimal;">
					<li><?php printf( __( 'Sign in to the <a href="%s" target="_blank"><b>Azure portal</b></a> using either a work or school account or a personal Microsoft account.', 'bkap-outlook-calendar' ), 'https://portal.azure.com/' ); ?></li>
					<li><?php _e( 'In the left-hand navigation pane, select the <b>Azure Active Directory</b> service, and then select <b>App registrations > New registration</b>.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
					<li><?php _e( 'When the <b>Register an application</b> page appears, enter your application\'s <b>Name</b> and select <b>Supported account types</b> as <i>Accounts in any organizational directory (Any Azure AD directory - Multitenant) and personal Microsoft accounts (e.g. Skype, Xbox)</i> and <b>Redirect URI</b> found in Redirect URI field below. When finished, select <b>Register</b>.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
					<li><?php _e( 'Azure AD assigns a unique application (client) ID to your app, and you\'re taken to your application\'s <b>Overview</b> page.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
					<li><?php _e( 'Copy the Application (client) ID. You\'ll use it in the Client ID field.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
					<li><?php _e( 'Under <b>Certificates & secrets</b>, choose New client secret, set Expires to Never and click Add. Copy the app secret value from the Client secrets list before leaving the page. Insert the secret into the <b>Client secret</b> field.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
					<li><?php _e( 'Under <b>API permissions</b>, choose <b>Add a permission</b>, and select <b>Microsoft Graph > Delegated permissions</b>. In <b>Select permissions</b> find <b>Calendars.ReadWrite</b>, select it and click <b>Add permissions</b> button.', 'bkap-outlook-calendar' ); // phpcs:ignore?></li>
				</ul>
			</div>
		</div>
		<?php
	}

	/**
	 * Function to display Clinet ID Field.
	 *
	 * @param Array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_client_key_callback( $args ) {
		$bkap_outlook_calendar_client_key = get_option( 'bkap_outlook_calendar_client_key' );

		$readonly = ( $args['readonly'] ) ? 'readonly' : '';
		echo '<input type="text" name="bkap_outlook_calendar_client_key" id="bkap_outlook_calendar_client_key" value="' . esc_attr( $bkap_outlook_calendar_client_key ) . '" size="60" ' . esc_attr( $readonly ) . '/>';
		$html = sprintf( '<br><label for="bkap_outlook_calendar_client_key">%s</label>', __( 'Client ID.', 'bkap-outlook-calendar' ) );
		echo $html; // phpcs:ignore
	}

	/**
	 * Function to display Client Secret Field.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_client_secret_callback( $args ) {
		$bkap_outlook_calendar_client_secret = get_option( 'bkap_outlook_calendar_client_secret' );
		$readonly                            = ( $args['readonly'] ) ? 'readonly' : '';

		echo '<input type="text" id="bkap_outlook_calendar_client_secret" name="bkap_outlook_calendar_client_secret" value="' . esc_attr( $bkap_outlook_calendar_client_secret ) . '" size="60" ' . esc_attr( $readonly ) . '/>';
		$html = sprintf( '<br><label for="bkap_outlook_calendar_client_secret">%s</label>', __( 'Client Secret.', 'bkap-outlook-calendar' ) );
		echo $html; // phpcs:ignore
	}

	/**
	 * Function to display Redirect URI field.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_redirect_uri_callback( $args ) {

		global $wp;

		$redirect_uri = $args['redirect_uri'];

		echo '<input readonly="readonly" class="bkap-auth-redirect-uri" style="width:89%;" type="text" id="bkap-auth-redirect-uri" name="bkap-outlook-redirect-uri" value="' . $redirect_uri . '">
		<em><a href="javascript:void(0)" style="border: 1px solid #eee;padding: 4px;" id="bkap_copy_redirect_uri" data-selector-to-copy="#bkap-auth-redirect-uri" data-tip="Copied!" class="dashicons dashicons-admin-page bkap-outlook-url-copy-to-clipboard"></a><span id="bkap_redirect_uri_copied"></span></em>';
	}

	/**
	 * Function to display Connect button.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_connect_callback( $args ) {

		$connect_link = $args['connect_link'];
		$connect      = __( 'Connect to Outlook', 'bkap-outlook-calendar' );
		printf( '<a style="" href="%s" class="button-primary">%s</a>', $connect_link, $connect );
	}

	/**
	 * Function to display Calendar Dropdown.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_id_callback( $args ) {
		$bkap_outlook_calendar_id = get_option( 'bkap_outlook_calendar_id' );
		$calendars                = $args['calendars'];
		?>

		<select name="bkap_outlook_calendar_id" id="bkap_outlook_calendar_id">
			<?php
			foreach ( $calendars as $key => $value ) {
				$selected = '';
				if ( $value['id'] == $bkap_outlook_calendar_id ) {
					$selected = 'selected';
				}
				echo '<option value="' . $value['id'] . '" ' . $selected . '>' . $value['name'] . '</option>';
			}
			?>
		</select>
		<?php
	}

	/**
	 * Function to display Disconnect button.
	 *
	 * @param array $args Arguments.
	 * @since    1.0.0
	 */
	public static function bkap_outlook_calendar_logout_callback( $args ) {
		$logout_link = $args['logout_link'];
		echo sprintf( '<a style="" href="%s" class="button-primary">%s</a>', $logout_link, __( 'Disconnect', 'bkap-outlook-calendar' ) );
	}
}
