(function( $ ) {
	'use strict';
	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$( window ).load(function() {
		$( '#bkap_copy_outlook_redirect_uri' ).on( 'click', function() {
			$( '.bkap-outlook-redirect-uri' ).select();
			document.execCommand( 'copy' );
			$( "#bkap_outlook_redirect_uri_copied" ).html("<b>Copied!</b>");
			$( "#bkap_outlook_redirect_uri_copied" ).show();
			setTimeout( function(){ $( "#bkap_outlook_redirect_uri_copied" ).hide(); 
			$( "#bkap_outlook_redirect_uri_copied" ).html("");
			}, 4000 );
		});
	});

})( jQuery );

function bkap_additional_integration_data( gcal_settings ) {

	if ( jQuery( "#bkap_outlook_calendar" ).prop( "checked" ) ) {
		gcal_settings[ 'bkap_outlook_calendar' ] =  jQuery( "#bkap_outlook_calendar" ).val();
	}
	
	gcal_settings[ 'bkap_outlook_calendar_client_id' ]     = jQuery( '#bkap_outlook_calendar_client_id' ).val();
	gcal_settings[ 'bkap_outlook_calendar_client_secret' ] = jQuery( '#bkap_outlook_calendar_client_secret' ).val();
	let calendar_id = '';
	if ( jQuery( '#bkap_outlook_calendar_id').length > 0 ) {
		calendar_id = jQuery( '#bkap_outlook_calendar_id option:selected' ).val();
	}
	gcal_settings[ 'bkap_outlook_calendar_id' ] = calendar_id;

	return gcal_settings;
}