<?php
if (have_rows('featured_events_repeater', 'options')) {

        the_row();
        $event = get_sub_field('featured_event');
        ?>
        <div class="menu-featured-event">
            <article <?php post_class(); ?>>
                <div class="event-img">
                    <?php
                    $featImage = wp_get_attachment_image_src(get_post_thumbnail_id($event), "menu-featured-event") ? wp_get_attachment_image_src(get_post_thumbnail_id($event), "menu-featured-event") : array("http://placehold.it/640x480");
                    $featImgAlt = get_post_meta(get_post_thumbnail_id($event), '_wp_attachment_image_alt', true);
                    ?>

                    <a href="<?php echo get_permalink($event); ?>" title="<?php the_title_attribute($event); ?>">
                        <img class="img-responsive news-thumb" src="<?php echo $featImage[0]; ?>" alt="<?php echo $featImgAlt; ?>"/>
                    </a>                    
                </div>
                <div class="event-text">                    
                    <h2 class="entry-title"><a href="<?php echo get_permalink($event); ?>"><?php echo get_the_title($event); ?></a></h2>                    
                    <div class="entry-summary">
                        <?php
                        $postLink = '<a class="viewmore up" href="' . get_permalink($event) . '">Event Info </a>';
                        echo wp_trim_words(get_post_field('post_content', $event), 12, $postLink);
                        ?>
                    </div>
                </div>
            </article>
        </div>
        <div class="all-event-link"><a href="<?= get_post_type_archive_link('event'); ?>">View all events&nbsp;<i style="margin-left:15px" class="fa fa-chevron-circle-right"></i></a></div>
        <?php
    
}
?>