<?php


namespace B2\Controllers;
use League\OAuth2\Client\Provider\GenericProvider;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use GuzzleHttp\Psr7;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ClientException;


class LinkToCC
{
    const CC_CLIENT_ID = "0fef0904-e253-4d4b-8b4f-242fad4e74da";
    const CC_CLIENT_SECRET = "ZFukyqJHQgDz1ykLc_Zglw";
    const CC_CALLBACK_URI = "https://atholl-estates.co.uk//wp-json/blair/v1/oauth-callback";
    
    public function __construct()
    {
        $this->client = new Client([
            'base_uri' => 'https://api.cc.email/v3/'
        ]);
        add_action('wp_dashboard_setup', [$this, 'addCCWidget']);

        add_action('rest_api_init', function () {
            register_rest_route('blair/v1', '/cc-authentication/', [
                'methods' => 'GET',
                'callback' => [$this, 'getCCAuthorization'],
            ]);
        });
        add_action('rest_api_init', function () {
            register_rest_route('blair/v1', '/oauth-callback/', [
                'methods' => 'GET',
                'callback' => [$this, 'ccOAuthCallback'],
            ]);
        });
    }

    public function addCCWidget()
    {
        global $wp_meta_boxes;
        if (current_user_can('administrator')) {
            wp_add_dashboard_widget('addCCWidgetOAuth', 'Constant Contact Authentication', [$this, 'CCOAuthForm']);
        }
    }

    public function CCOAuthForm() { ?>
        <form action="/wp-json/blair/v1/cc-authentication" method="GET" name="ccOAuth">
            <p>Renew the authorization with Constant Contact. Don't touch until is necessary.</p>
            <input class="button button-primary " type="submit" name="ccAuth" value="Renew Constant Contact Authentication">
        </form>
      <?php
    }

    public function getCCAuthorization()
    {
        $baseURL = "https://api.cc.email/v3/idfed";
        $authURL = $baseURL . "?client_id=" . self::CC_CLIENT_ID . "&scope=contact_data&response_type=code" . "&redirect_uri=" . self::CC_CALLBACK_URI;

        // Redirect the user to the authorization URL.

        $provider = new GenericProvider([
            'clientId'                => self::CC_CLIENT_ID,
            'clientSecret'            => self::CC_CLIENT_SECRET,
            'redirectUri'             => self::CC_CALLBACK_URI,
            'urlAuthorize'            => 'https://api.cc.email/v3/idfed',
            'urlAccessToken'          => 'https://idfed.constantcontact.com/as/token.oauth2',
            'urlResourceOwnerDetails' => null
          ]);
        
        $options = [
              'scope' => ['contact_data']
          ];
        
        // This returns the authorizeUrl with necessary parameters applied (e.g. state).
        $authorizationUrl = $provider->getAuthorizationUrl($options);
        
        // Save the state generated for you and store it to the session.
        // For security, on callback we compare the saved state with the one returned to ensure they match.
        $_SESSION['oauth2state'] = $provider->getState();


        header('Location: ' . $authURL);
        exit();
    }

    public function ccOAuthCallback()
    {

        $provider = new GenericProvider([
            'clientId'                => self::CC_CLIENT_ID,
            'clientSecret'            => self::CC_CLIENT_SECRET,
            'redirectUri'             => self::CC_CALLBACK_URI,
            'urlAuthorize'            => 'https://api.cc.email/v3/idfed',
            'urlAccessToken'          => 'https://idfed.constantcontact.com/as/token.oauth2',
            'urlResourceOwnerDetails' => null
          ]);
        
        // If we don't have an authorization code then get one
        if (!isset($_GET['code'])) {
            echo "Something went wrong, no authorization code found";
            exit("Something went wrong, no authorization code found");
        
        // Check given state against previously stored one to mitigate CSRF attack
        // } elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {
        //     echo "Invalid State";
        //     unset($_SESSION['oauth2state']);
        //     exit('Invalid state');
        } else {
            try {
                // Try to get an access token using the authorization code grant.
                $accessToken = $provider->getAccessToken('authorization_code', [
                'code' => $_GET['code']
              ]);
                
                $expireTime = strtotime("+2 hours");
                update_field('token', $accessToken->getToken(), 'option');
                update_field('expires', $expireTime, 'option');
                update_field('refresh_token', $accessToken->getRefreshToken(), 'option');
                      
                
                
                
                wp_send_json(["response" => "Token updated"]);
                exit();
            } catch (IdentityProviderException $e) {
                wp_send_json(["response" => "There was an error on updating the token"]);
                exit();
            }
        }
    }

    public static function refreshTokenIfExpired()
    {
        $tokenExpired = true;
        $tokenExpireTime = get_field('expires', 'option');
        if ($tokenExpireTime) {
            if (strtotime("now") > $tokenExpireTime) {
                $tokenExpired = true;
            } else {
                $tokenExpired = false;
            }
        } else {
            $tokenExpired = true;
        }
        
        if ($tokenExpired) {
            $provider = new GenericProvider([
                'clientId'                => self::CC_CLIENT_ID,
                'clientSecret'            => self::CC_CLIENT_SECRET,
                'redirectUri'             => self::CC_CALLBACK_URI,
                'urlAuthorize'            => 'https://api.cc.email/v3/idfed',
                'urlAccessToken'          => 'https://idfed.constantcontact.com/as/token.oauth2',
                'urlResourceOwnerDetails' => null
              ]);
      
            $newAccessToken = $provider->getAccessToken('refresh_token', [
            'refresh_token' => get_field('refresh_token', 'option')
          ]);
                $expireTime = strtotime("+2 hours");
                update_field('token', $newAccessToken->getToken(), 'option');
                update_field('expires', $expireTime, 'option');
                update_field('refresh_token', $newAccessToken->getRefreshToken(), 'option');
                
        }
    }

    private static function searchContact($email){
        try{
            self::refreshTokenIfExpired();
            $client = new Client();
            $access_token = get_field('token', 'option');
            $response = $client->request('GET', 'https://api.cc.email/v3/contacts', [
                'query' => [
                    'email'     => $email,
                    'status'    => 'all'
                ],
                'headers' => [
                    'Authorization' => 'Bearer ' . $access_token,        
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ]
            ]);
            $res = json_decode($response->getBody()->getContents());
            if(count($res->contacts) > 0){
                return $res;
            }else{
                return false;
            }
        }catch(RequestException $e){
            var_dump($e);

        }
    }
    private static function createContact($name = [], $email){
        try{
            self::refreshTokenIfExpired();
            $client = new Client();
            $access_token = get_field('token', 'option');
            $body = [
                'email_address'     => [
                    'address'               => $email,
                    'permission_to_send'    => 'implicit'
                ],
                'first_name' => $name[0],
                'last_name'  => $name[1],
                'create_source' => 'Contact'
            ];
            
            $response = $client->request('POST', 'https://api.cc.email/v3/contacts', [
                'body' => json_encode($body),
                'headers' => [
                    'Authorization' => 'Bearer ' . $access_token,        
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'http_errors' => true
            ]);

            $res = json_decode($response->getBody()->getContents());
            if(isset($res->contact_id)){
                return $res;
            }else{
                return false;
            }
        }catch(RequestException $e){
            echo Psr7\Message::toString($e->getRequest());
        }
        catch (ClientException $e) {
            echo Psr7\Message::toString($e->getRequest());
            echo Psr7\Message::toString($e->getResponse());
        }
    }
    public function addContactToLists($contact, $list){
        try{
            self::refreshTokenIfExpired();
            $client = new Client();
            $access_token = get_field('token', 'option');
            $body = [
                'source'     => [
                    'contact_ids'   => [
                        $contact->contacts[0]->contact_id
                    ]
                ],
                'list_ids'  =>$list
            ];
            
            $response = $client->request('POST', 'https://api.cc.email/v3/activities/add_list_memberships', [
                'body' => json_encode($body),
                'headers' => [
                    'Authorization' => 'Bearer ' . $access_token,        
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'http_errors' => true
            ]);

            $res = json_decode($response->getBody()->getContents());
            if(isset($res)){
                return $res;
            }else{
                return false;
            }
        }catch(RequestException $e){
            echo Psr7\Message::toString($e->getRequest());
        }
        catch (ClientException $e) {
            echo Psr7\Message::toString($e->getRequest());
            echo Psr7\Message::toString($e->getResponse());
        }
    }

    public function searchorCreateContact($name = [], $email){
        
        try{
            if(!$contact = self::searchContact($email)){
                $contact = self::createContact($name, $email);
            }

            return $contact;
        }catch(RequestException $e){
            var_dump($e);

        }

    }
}