<?php

namespace B2;

class CustomWalker extends \Walker_Nav_Menu
{
    public static $currentId;
    public static $parentArray;
    public static $showChildren;

    public function __construct($args = array())
    {
        self::$currentId = !empty($args) ? $args['current_id'] : 0;
        self::$parentArray = null;
        self::$showChildren = false;
    }

    public function walk($elements, $max_depth, ...$args)
    {
        $args = array_slice(func_get_args(), 2);
        $output = '';

        if ($max_depth < -1) { //invalid parameter
            return $output;
        }

        if (empty($elements)) { //nothing to walk
            return $output;
        }

        $id_field = $this->db_fields['id'];
        $parent_field = $this->db_fields['parent'];

        // flat display
        if (-1 == $max_depth) {
            $empty_array = array();
            foreach ($elements as $e) {
                $this->display_element($e, $empty_array, 1, 0, $args, $output);
            }
            return $output;
        }

        /*
         * need to display in hierarchical order
         * separate elements into two buckets: top level and children elements
         * children_elements is two dimensional array, eg.
         * children_elements[10][] contains all sub-elements whose parent is 10.
         */
        $top_level_elements = array();
        $all_top_levels = array();
        $children_elements = array();
        $current = null;

        $current_element_markers = array('current-menu-item', 'current-menu-parent', 'current-menu-ancestor');
        foreach ($elements as $e) {
            $descend_test = array_intersect($current_element_markers, $e->classes);

            if (0 == $e->$parent_field) {
                $top_level_elements[] = $e;
                $all_top_levels[] = $e;
                if (!empty($descend_test)) {
                    $current = $e;
                }
            } else {
                $children_elements[$e->$parent_field][] = $e;
            }
        }

        /*
         * when none of the elements is top level
         * assume the first one must be root of the sub elements
         */

        if (empty($top_level_elements)) {
            $first = array_slice($elements, 0, 1);
            $root = $first[0];

            $top_level_elements = array();
            $all_top_levels = array();
            $children_elements = array();
            foreach ($elements as $e) {
                if ($root->$parent_field == $e->$parent_field) {
                    $top_level_elements[] = $e;
                    $all_top_levels[] = $e;
                } else {
                    $children_elements[$e->$parent_field][] = $e;
                }
            }
        }


        if (isset($children_elements[$current->ID])) {
            $top_level_elements = [$current];
        }

        foreach ($all_top_levels as $e) {
            $descend_test = array_intersect($current_element_markers, $e->classes);

            if (empty($descend_test)) {
                unset($children_elements[$e->ID]);
            }
        }

        foreach ($top_level_elements as $e) {

            // descend only on current tree
            $descend_test = array_intersect($current_element_markers, $e->classes);

            if (empty($descend_test)) {
                unset($children_elements[$e->ID]);
            }

            $this->display_element($e, $children_elements, $max_depth, 0, $args, $output);
        }

        /*
         * if we are displaying all levels, and remaining children_elements is not empty,
         * then we got orphans, which should be displayed regardless
         */
        if (($max_depth == 0) && count($children_elements) > 0) {
            $empty_array = array();
            foreach ($children_elements as $orphans) {
                foreach ($orphans as $op) {
                    $this->display_element($op, $empty_array, 1, 0, $args, $output);
                }
            }
        }

        return $output;
    }
}
