<?php

namespace B2;
use B2\Controllers\LinkToCC as LinkToCC;

class AthollEstatesSite extends \Fuse\Site
{

    private $pluginDirectory;

    public function __construct($pluginDirectory)
    {
        parent::__construct($pluginDirectory, false);

        $this->pluginDirectory = $pluginDirectory;

        add_action('init', array($this, 'registerPostTypes'));
        add_action('init', array($this, 'registerTaxonomies'));

        add_action('init', array($this, 'addCustomOptionsPages'));

        add_action('init', array($this, 'registerShortcodes'));

        // Theme setup functions
        add_action('after_setup_theme', array($this, 'theme_setup'));

        // On save post (for recur events)
        add_action('acf/save_post', array($this, 'onSaveEvents'), 20);

        add_filter('get_next_post_sort', array($this, 'my_next_post_sort'));
        add_filter('get_next_post_where', array($this, 'my_next_post_where'));
        add_filter('get_next_post_join', array($this, 'my_next_post_join'));

        add_action('rest_api_init', function () {
            register_rest_route('events/v1', '/featuredevents', array(
                'methods' => 'GET',
                'callback' => array($this, 'featuredEvents'),
            ));
        });
        add_action('rest_api_init', function () {
            register_rest_route('events/v1', '/menufeaturedevents', array(
                'methods' => 'GET',
                'callback' => array($this, 'menuFeaturedEvents'),
            ));
        });

        add_action('rest_api_init', function () {
            register_rest_route('events/v1', '/calendar', array(
                'methods' => 'GET',
                'callback' => array($this, 'calendarAtholl'),
            ));
        });

        add_action('rest_api_init', function () {
            register_rest_route('news/v1', '/latestnews', array(
                'methods' => 'GET',
                'callback' => array($this, 'latestNews'),
            ));
        });
        // Cron job to calculate event dates
        add_action('registerCalculateEventsDates', array($this, 'calculateEventDates'));
        add_action('init', array($this, 'registerCalculateEventsDates'));

        // custom instructions for featured image box
        add_filter('admin_post_thumbnail_html', [$this, 'featuredImageInstructions'], 10, 3);
        add_action("wpcf7_before_send_mail", [$this, "wpcf7Before"], 10, 3);  
        new LinkToCC();
    }

    public function registerPostTypes()
    {
//        $personPT = new \Fuse\PostType("person");
//        $personPT->register("Person", "People", array(), array("menu_icon" => "dashicons-admin-users", "has_archive" => true, "rewrite" => array("slug" => "people")));

        if (get_field('site', 'options') == 'athollestates') {
            $eventPT = new \Fuse\PostType("event");
            $eventPT->register("Event", "Events", array(), array("menu_icon" => "dashicons-calendar", "has_archive" => true, "rewrite" => array("slug" => "events")));
        }

        $propertiesPT = new \Fuse\PostType("property");
        $propertiesPT->register("Property", "Properties", [], ["menu_icon" => "dashicons-building", "has_archive" => true, "rewrite" => ["slug" => "properties"]]);
    }

    public function registerTaxonomies()
    {
//        $teamTax = new \Fuse\Taxonomy("team");
//        $teamTax->register("Team", "Teams", array("person"), array(), array("rewrite" => array("slug" => "team", "with_front" => false, "hierarchical" => false)));

        if (get_field('site', 'options') == 'athollestates') {
            $eventTax = new \Fuse\Taxonomy("event-category");
            $eventTax->register("Event Category", "Event Categories", array("event"), array(), array("rewrite" => array("slug" => "event_category", "with_front" => false, "hierarchical" => false)));
        }

        $propertyType = new \Fuse\Taxonomy("property-type");
        $propertyType->register("Property Type", "Property Types", ['property'], [], ["rewrite" => ["slug" => "property-types", "with_front" => false, "hierarchical" => false]]);
    }

    public function addCustomOptionsPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page(
                array(
                    "page_title" => "Theme Settings",
                    "icon_url" => "dashicons-admin-generic",
                )
            );
            acf_add_options_page(
                array(
                    "page_title" => "Admin Settings",
                    "icon_url" => "dashicons-admin-generic",
                    "capability" => "edit_dashboard"
                )
            );
        }
    }

    public function registerShortcodes()
    {
        add_shortcode('tickets_twitter_box', array($this, 'ticketsTwitterBox'));
        add_shortcode('events_calendar', array($this, 'eventsCalendar'));
    }

    public function theme_setup()
    {
        register_nav_menus([
            'primary_navigation' => 'Primary Navigation',
            'top_navigation' => 'Top Navigation',
            'footer_left_navigation' => 'Footer Left',
            'footer_right_navigation' => 'Footer Right',
//            'top_footer_left_navigation' => 'Top Footer Left',
//            'top_footer_right_navigation' => 'Top Footer Right',
//            'weddings-private-functions-tf_left_navigation' => 'Wedding Private Functions footer left',
//            'weddings-private-functions-tf_right_navigation' => 'Wedding Private Functions footer right',
            'weddings-private-functions' => 'Weddings Private Functions',
//            'corporate-hospitality-tf_left_navigation' => 'Corporate Hospitality footer left',
//            'corporate-hospitality-tf_right_navigation' => 'Corporate Hospitality footer right',
            'corporate-hospitality' => 'Corporate Hospitality',
//            'estate-activities-tf_left_navigation' => 'Estate Activities footer left',
//            'estate-activities-tf_right_navigation' => 'Estate Activities footer right',
            'estate-activities' => 'Estate Activities',
//            'stay-on-the-estate-tf_left_navigation' => 'Stay On The Estate footer left',
//            'stay-on-the-estate-tf_right_navigation' => 'Stay On The Estate footer right',
            'stay-on-the-estate' => 'Stay On The Estate',
//            'caravan-estate-tf_left_navigation' => 'Caravan Estate footer left',
//            'caravan-estate-tf_right_navigation' => 'Caravan Estate footer right',
            'caravan-estate' => 'Caravan Estate',
            'media_wall' => 'Media Wall',
            'team' => 'Team'
        ]);
    }

    /** Function to generate tickets twitter box (used for shortcode [tickets_twitter_box] * */
    function ticketsTwitterBox()
    {
        include(get_template_directory() . '/templates/feature/tickets-twitter.php');
    }

    /** Function to generate events calendar (used for shortcode [events_calendar] * */
    function eventsCalendar()
    {
        include(get_template_directory() . '/templates/feature/events-calendar.php');
    }

    public static function childSibMenu($this_page)
    {
        $theme_locations = get_nav_menu_locations();

        if ($this_page->post_parent) {
            $ancestors = get_post_ancestors($this_page->ID);
            $root = count($ancestors) - 1;
            $parent = $ancestors[$root];
        } else {
            $parent = $this_page->ID;
        }
        $parentSlug = get_post_field('post_name', $parent);

        if (has_nav_menu($parentSlug)) {
            $menuObj = wp_nav_menu(['menu' => $parentSlug, 'menu_class' => 'nav navbar-nav', 'echo' => false, 'walker' => new CustomWalker(array('current_id' => $this_page->ID))]);
        } elseif (has_nav_menu('primary_navigation')) {
            $menuObj = wp_nav_menu(['theme_location' => 'primary_navigation', 'menu_class' => 'nav navbar-nav', 'echo' => false, 'walker' => new CustomWalker(array('current_id' => $this_page->ID))]);
        }

        if ($menuObj) {
            return $menuObj;
        }
    }

    function my_next_post_sort()
    {
        if (get_post_type() == 'event') {
            return "ORDER BY pm.meta_value asc LIMIT 1";
        } elseif (get_post_type() == 'post') {
            return "ORDER BY p.post_date asc LIMIT 1";
        }
    }

    function my_next_post_join()
    {
        if (get_post_type() == 'event') {
            return "INNER JOIN pex_athollestates_postmeta pm on p.ID = pm.post_id";
        } else {
            return "";
        }
    }

    function my_next_post_where()
    {
        global $post, $wpdb;
        if (get_post_type() == 'event') {
            global $post, $wpdb;

            $event_start = get_field('event_start_date', $post->ID);
            $parts = explode('/', $event_start);
            $parts = array_reverse($parts);
            $event_start = implode('', $parts);

            $currentDate = current_time('Ymd');

            return $wpdb->prepare("WHERE (pm.meta_key = 'event_start_date' AND pm.meta_value > %s AND p.ID != %s AND pm.meta_value >= %s) "
                . "AND p.post_type = %s AND p.post_status = 'publish'", $event_start, $post->ID, $currentDate, $post->post_type);
        } else {
            return $wpdb->prepare("WHERE p.post_date > %s AND p.post_type = %s AND p.post_status = 'publish'", $post->post_date, $post->post_type);
        }
    }

    function wpbeginner_numeric_posts_nav()
    {
        if (is_singular())
            return;

        global $wp_query;

        /** Stop execution if there's only 1 page */
        if ($wp_query->max_num_pages <= 1)
            return;

        $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
        $max = intval($wp_query->max_num_pages);

        /** Add current page to the array */
        if ($paged >= 1)
            $links[] = $paged;

        /** Add the pages around the current page to the array */
        if ($paged >= 3) {
            $links[] = $paged - 1;
            $links[] = $paged - 2;
        }

        if (($paged + 2) <= $max) {
            $links[] = $paged + 2;
            $links[] = $paged + 1;
        }

        echo '<div class="blogNavigation"><ul>' . "\n";

        /** Previous Post Link */
        if (get_previous_posts_link())
            printf('<li>%s</li>' . "\n", get_previous_posts_link());


        /** Link to first page, plus ellipses if necessary */
        if (!in_array(1, $links)) {
            $class = 1 == $paged ? ' class="active"' : '';

            printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link(1)), '1');
            if (!in_array(2, $links))
                echo '<li>…</li>';
        }

        /** Link to current page, plus 2 pages in either direction if necessary */
        sort($links);
        foreach ((array)$links as $link) {
            $class = $paged == $link ? ' class="active"' : '';
            printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($link)), $link);
        }

        /** Link to last page, plus ellipses if necessary */
        if (!in_array($max, $links)) {
            if (!in_array($max - 1, $links))
                echo '<li>…</li>' . "\n";

            $class = $paged == $max ? ' class="active"' : '';
            printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($max)), $max);
        }

        /** Next Post Link */
        if (get_next_posts_link())
            printf('<li>%s</li>' . "\n", get_next_posts_link());
        echo '</ul></div>' . "\n";
    }

    public function featuredEvents(\WP_REST_Request $request)
    {
        ob_start();
        include $this->pluginDirectory . "templates/featuredevents.php";
        return ob_get_clean();
    }

    public function menuFeaturedEvents(\WP_REST_Request $request)
    {
        ob_start();
        include $this->pluginDirectory . "templates/menufeaturedevents.php";
        return ob_get_clean();
    }

    public function latestNews(\WP_REST_Request $request)
    {
        ob_start();
        include $this->pluginDirectory . "templates/latestnews.php";
        return ob_get_clean();
    }

    public static function featuredEventsBlair()
    {
        //delete_transient('b2_blaircastle_featuredevents');
        if (false == ($featuredEvents = get_transient('b2_blaircastle_featuredevents'))) {

            $events = get_field('get_featured_events', 'options') ? get_field('get_featured_events', 'options') : "http://atholl-estates.co.uk/wp-json/events/v1/featuredevents";
            $response = wp_remote_get($events);
            if (is_array($response)) {
                $featuredEvents = json_decode($response['body']);

                set_transient('b2_blaircastle_featuredevents', $featuredEvents, 900);
            }
        }

        return $featuredEvents;
    }

    public static function menuFeaturedEventsBlair()
    {
        //delete_transient('b2_blaircastle_featuredevents');
        if (false == ($featuredEvents = get_transient('b2_blaircastle_featuredevents'))) {

            $events = get_field('get_menu_featured_events', 'options') ?: "http://atholl-estates.co.uk/wp-json/events/v1/menufeaturedevents";
            $response = wp_remote_get($events);
            if (is_array($response)) {
                $featuredEvents = json_decode($response['body']);

                set_transient('b2_blaircastle_featuredevents', $featuredEvents, 900);
            }
        }

        return $featuredEvents;
    }

    public static function latestNewsBlair()
    {
        //delete_transient('b2_blaircastle_latestnews_widget');
        if (false == ($latest = get_transient('b2_blaircastle_latestnews_widget'))) {
            $news = get_field('get_latest_news', 'options') ? get_field('get_latest_news', 'options') : "http://atholl-estates.co.uk/wp-json/news/v1/latestnews";
            $response = wp_remote_get($news);

            if (is_array($response)) {
                $latest = json_decode($response['body']);

                set_transient('b2_blaircastle_latestnews_widget', $latest, 900);
            }
        }

        return $latest;
    }

    public static function eventsJson()
    {
        $args = array(
            "post_type" => "event"
        );
        $events = new \WP_Query($args);
        $out = array();

        if ($events->have_posts()) {
            while ($events->have_posts()) {
                $events->the_post();
                $datesArray = get_post_meta(get_the_ID(), 'b2_event_dates');
                if ($datesArray && get_field('repeats') != 'never') {

                    foreach ($datesArray[0] as $day) {

                        $startDate = strtotime($day['start']) * 1000;
                        $endDate = strtotime($day['finish']) * 1000;

                        $out[] = array(
                            'id' => get_the_ID(),
                            'title' => get_the_title(),
                            'url' => get_permalink(),
                            'class' => 'event-important',
                            'start' => $startDate,
                            'end' => $endDate
                        );
                    }
                } else {
                    $startDate = strtotime(get_field('event_start_date', false, false)) * 1000;
                    $endDate = get_field('event_end_date', false, false) ? strtotime(get_field('event_end_date', false, false)) * 1000 : '';

                    $out[] = array(
                        'id' => get_the_ID(),
                        'title' => get_the_title(),
                        'url' => get_permalink(),
                        'class' => 'event-important',
                        'start' => $startDate,
                        'end' => $endDate
                    );
                }
            }
        }

        $result = json_encode($out);

        return $result;
    }

    public function calendarAtholl(\WP_REST_Request $request)
    {
        return $this->eventsJson();
    }

    public static function calendarBlair()
    {
        //delete_transient('b2_blaircastle_calendar');
        if (false == ($calendar = get_transient('b2_blaircastle_calendar'))) {
            $calendarUrl = get_field('get_calendar', 'options') ? get_field('get_calendar', 'options') : "http://atholl-estates.co.uk/wp-json/events/v1/calendar";
            $response = wp_remote_get($calendarUrl);
            if (is_array($response)) {
                $calendar = json_decode($response['body']);
                //temporary expire every hour
                set_transient('b2_blaircastle_calendar', $calendar, 900);
            }
        }
        return $calendar;
    }

    public function onSaveEvents($post_id)
    {
        $post_type = get_post_type($post_id);

        if ("event" != $post_type) {
            return;
        }

        $repeats = get_field('repeats');
//        if ('never' == $repeats) {
//            return;
//        }

        $startDate = strtotime(get_field('event_start_date', false, false));
        $endDate = get_field('event_end_date', false, false);
        $endDate = $startDate < strtotime($endDate) ? strtotime($endDate) : $startDate;

        // $diff = $endDate2 ? intval($endDate2->diff($startDate2)->format('%a')) : 1;
        $endsOn = get_field('ends_on', false, false);
        $endsOn = $endsOn && $repeats != 'never' ? strtotime($endsOn) : strtotime(date("Y-m-d", $startDate) . "+ 1 year");

        if ('daily' == $repeats) {
            $dateCalc = " +1 day";
        } elseif ('weekly' == $repeats) {
            $dateCalc = " +1 week";
        } elseif ('fortnightly' == $repeats) {
            $dateCalc = " +14 days";
        } elseif ('monthly' == $repeats) {
            $dateCalc = " +1 month";
        } elseif ('never' == $repeats) {
            $dateCalc = " +1 day";
            $endsOn = strtotime(date("Y-m-d", $startDate));
        }

        $dateArray = array();
        while ($startDate <= $endsOn) {
            if (get_field('days')) {

                $start = date("Ymd", $startDate);
                $finish = $endDate ? date("Ymd", $endDate) : $endsOn;
                $days = get_field('days');

                foreach ($days as $day) {
                    for ($dow = strtotime($day, strtotime($start)); $dow <= $finish; $days = strtotime($dateCalc, $dow)) ;
                    $dateArray[] = array("start" => date("Ymd", $dow), "finish" => date("Ymd", $dow));
                }

                $dateArray[] = array("start" => $start, "finish" => $finish);
                $startDate = strtotime(date("Y-m-d", $startDate) . $dateCalc);
                $endDate = $endDate ? strtotime(date("Y-m-d", $endDate) . $dateCalc) : '';

            } else {
                $start = date("Ymd", $startDate);
                $finish = $endDate ? date("Ymd", $endDate) : $endsOn;

                $dateArray[] = array("start" => $start, "finish" => $finish);
                $startDate = strtotime(date("Y-m-d", $startDate) . $dateCalc);

                $endDate = $endDate ? strtotime(date("Y-m-d", $endDate) . $dateCalc) : '';
            }
        }
        update_post_meta($post_id, 'b2_event_dates', $dateArray);
        AthollEstatesSite::calculateEventDates();

        return;
    }

    public function registerCalculateEventsDates()
    {
        if (!wp_next_scheduled('AthollCalculateEventDates')) {
            wp_schedule_event(time(), 'daily', 'AthollCalculateEventDates');
        }
    }

    function calculateEventDates()
    {
        $args = array(
            'posts_per_page' => -1,
            'post_type' => 'event'
        );
        $events = new \WP_Query($args);
        if ($events->have_posts()) {
            while ($events->have_posts()) {
                $events->the_post();
                $datesArray = get_post_meta(get_the_ID(), 'b2_event_dates');

                if ($datesArray) {
                    AthollEstatesSite::processDates($datesArray);
                } else {
                    $startDate = get_field('event_start_date', false, false);
                    $endDate = get_field('event_end_date', false, false);
                    update_post_meta(get_the_ID(), 'b2_event_start_date', $startDate);
                    update_post_meta(get_the_ID(), 'b2_event_end_date', $endDate);
                }
            }
        }
    }

    public function processDates($datesArray)
    {
        $now = strtotime(date('Ymd'));
        foreach ($datesArray[0] as $day) {
            if (strtotime($day['start']) >= $now || strtotime($day['start']) < $now && strtotime($day['finish']) > $now) {
                update_post_meta(get_the_ID(), 'b2_event_start_date', date('Ymd', strtotime($day['start'])));
                update_post_meta(get_the_ID(), 'b2_event_end_date', date('Ymd', strtotime($day['finish'])));
                return;
            }
        }
    }

    public static function returnLinkType($link, $rowType)
    {
        switch ($link) {
            case $link == 'url' && $rowType == 'banner_boxes' :
                $url = get_sub_field('box_link');
                break;

            case $link == 'url' && $rowType == 'panels' :
                $url = get_sub_field('panel_link');
                break;

            case $link == 'url' && $rowType == 'blair_panels' :
                $url = get_sub_field('cta_link');
                break;

            case $link == 'url' && $rowType == 'blair_panels_slider' :
                $url = get_sub_field('slider_cta_link');
                break;

            case $link == 'phone' :
                $url = 'tel:' . get_sub_field('phone');
                break;

            case $link == 'email' :
                $url = 'mailto:' . get_sub_field('email');
                break;

            default :
                $url = get_sub_field('box_link');
                break;
        }
        return $url;
    }

    /**
     * featuredImageInstructions
     *
     * @return void
     */
    public static function featuredImageInstructions($content, $post_id, $thumbnail_id)
    {
        $post_type = get_post_type($post_id);

        if ($post_type === 'post') {
            $content .= '<em>Suggested minimum image size 1050 x 790 px.</em>';
            return $content;
        }

        if ($post_type === 'property') {
            $content .= '<em>Suggested minimum image size 640 x 480 px.</em>';
            return $content;
        }

        return $content;
    }

    function emptyCheck($var){
        return ($var !== NULL && $var !== FALSE && $var !== "");
    }

    function wpcf7Before($cf7) {
        // get the contact form object
        
        $formId = $cf7->id();
        $submission = \WPCF7_Submission::get_instance();

        if($formId == '2811'){
            $fname = $submission->get_posted_data('first_name');
            $lname = $submission->get_posted_data('last_name');
            $name = [
                $fname,
                $lname
            ];
            $email = $submission->get_posted_data('email');
            $checkbox1 = array_filter($submission->get_posted_data('checkbox-570'), [$this,"emptyCheck"]);
            $checkbox2 = array_filter($submission->get_posted_data('checkbox-571'), [$this,"emptyCheck"]);

            $newsletters = array_merge($checkbox1, $checkbox2);


            if($contact = LinkToCC::searchorCreateContact($name, $email)){
                LinkToCC::addContactToLists($contact, $newsletters);
            }
            
        }
        
        return $cf7;
    }

}
