<?php

namespace collectionDateCol\Filtering;

class collectionDateCol extends \ACP\Filtering\Model {

	public function get_filtering_data() {
		$data = [
			'options' => [
				'2022-12-22' => 'Dec 22, 2022',
				'2022-12-23' => 'Dec 23, 2022',
				'2022-12-24' => 'Dec 24, 2022',
				'2022-12-28' => 'Dec 28, 2022',
				'2022-12-29' => 'Dec 29, 2022',
				'2022-12-30' => 'Dec 30, 2022',
				'2022-12-31' => 'Dec 31, 2022',
			],
		];

		// (Optional) Order the options in the drop down menu
		// $data['order'] = true;

		// (Options) show empty options in the drop down.
		// $data['empty_option'] = true;

		return $data;
	}

	public function get_filtering_vars( $vars ) {
		// All actual filtering logic goes here, you'll need to alter the WP_Query.
		// $vars contains all WP_Query vars

		// Example of Meta Query filter
		// $vars['meta_query'][] = [
		// 	'key'   => 'meta_key', // For Meta columns, you can use $column->get_meta_key()
		// 	'value' => $this->get_filter_value(),
		// ];

		// Example of altering query
		add_filter( 'posts_where', array( $this, 'filter_by_custom_query' ), 10, 2 );

		// Always return $vars
		return $vars;
	}

	public function filter_by_custom_query( $where, \WP_Query $query ) {
		global $wpdb;

		$filterValue = $this->get_filter_value();

		if ( $query->is_main_query() ) {
			$where .= " AND {$wpdb->posts}.id IN (SELECT order_id FROM pex_simonhowie_christmas_woocommerce_order_items WHERE order_item_id IN (SELECT order_item_id FROM pex_simonhowie_christmas_woocommerce_order_itemmeta WHERE meta_key = '_pickup_date' AND meta_value = '".$filterValue."')) "; // Alter the Where clauses with SQL
			$where .= " AND {$wpdb->posts}.id NOT IN (SELECT order_id FROM pex_simonhowie_christmas_woocommerce_order_items WHERE order_item_name LIKE '%Delivery%') ";
		}

		return $where;
	}

}